/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.IOException;
import java.io.InputStream;
import org.agrona.DirectBuffer;

public class DirectBufferInputStream
extends InputStream {
    private DirectBuffer buffer;
    private int offset;
    private int length;
    private int position;

    public DirectBufferInputStream() {
    }

    public DirectBufferInputStream(DirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public DirectBufferInputStream(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public void wrap(DirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        if (null == buffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.position = 0;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.length - this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = (int)Math.min(n, (long)this.available());
        this.position += skipped;
        return skipped;
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this.position < this.length) {
            b = this.buffer.getByte(this.offset + this.position);
            ++this.position;
        }
        return b;
    }

    @Override
    public int read(byte[] dstBytes, int dstOffset, int length) throws IOException {
        int bytesRead = -1;
        if (this.position < this.length) {
            bytesRead = Math.min(length, this.available());
            this.buffer.getBytes(this.offset + this.position, dstBytes, dstOffset, bytesRead);
            this.position += bytesRead;
        }
        return bytesRead;
    }
}

