/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.browser;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jemmy.Rectangle;
import org.jemmy.browser.BrowserDescriptor;
import org.jemmy.browser.ElementRetriever;
import org.jemmy.browser.HierarchyDescriptor;
import org.jemmy.browser.ImageLabel;
import org.jemmy.browser.InterfacesPanel;
import org.jemmy.browser.NodeDescriptor;
import org.jemmy.browser.PropertiesPanel;
import org.jemmy.browser.ReflectionPanel;
import org.jemmy.browser.SearchDialog;
import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.lookup.ControlHierarchy;
import org.jemmy.lookup.ControlList;

public class HierarchyView
extends JFrame {
    private static final int MARKER_BORDER_GAP = 4;
    private static final int MARKER_BORDER_WIDTH = 4;
    private static final int WATCHER_LOOP_DELAY = 2000;
    DefaultTreeModel model;
    PropertiesPanel propPanel;
    InterfacesPanel intPanel;
    BrowserDescriptor descr;
    Wrap<?> root;
    ArrayList<Class> subHs;
    ComboBoxModel comboModel = new MyComboModel();
    ReflectionPanel reflectionPanel;
    private int sleepValue;
    SearchDialog sd = new SearchDialog(this);
    ImageLabel imageLabel;
    JWindow markerFrame;
    DefaultMutableTreeNode rootNode;
    private Robot robot;
    private BufferedImage shot = null;
    private java.awt.Rectangle fullScreen = new java.awt.Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
    private JTabbedPane controlTab;
    private JTree controlTree;
    private JCheckBox highlightControl;
    private JScrollPane imageScroll;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton refreshBtt;
    private JLabel refreshingLbl;
    private JTextField sleep;
    private JPanel underIntPanel;
    private JPanel underPropPanel;
    private JPanel underReflectionPanel;
    private JCheckBox watchCursor;
    private volatile boolean watcherRunning;
    private MyTreeNode latestWatched;

    public static void startApp(final String[] argv) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (argv.length > 0) {
                    try {
                        Class<?> appClass = Class.forName(argv[0]);
                        appClass.getMethod("main", new String[0].getClass()).invoke(null, new Object[]{Arrays.copyOfRange(argv, 1, argv.length)});
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (NoSuchMethodException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (SecurityException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ClassNotFoundException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }).start();
    }

    public HierarchyView(BrowserDescriptor descr) throws AWTException {
        this(descr, null);
    }

    private HierarchyView(final BrowserDescriptor descr, Wrap<?> root) throws AWTException {
        this.descr = descr;
        this.root = root;
        this.subHs = new ArrayList();
        this.setTitle(descr.getTitle());
        this.rebuildModel();
        this.initComponents();
        this.imageLabel = new ImageLabel();
        this.imageScroll.setViewportView(this.imageLabel);
        this.underPropPanel.setLayout(new BorderLayout());
        this.propPanel = new PropertiesPanel();
        this.underPropPanel.add(this.propPanel);
        this.underIntPanel.setLayout(new BorderLayout());
        this.intPanel = new InterfacesPanel();
        this.underIntPanel.add(this.intPanel);
        this.underReflectionPanel.setLayout(new BorderLayout());
        this.reflectionPanel = new ReflectionPanel();
        this.underReflectionPanel.add((Component)this.reflectionPanel, "Center");
        this.controlTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                if (descr.isActiveHighlightingProvided()) {
                    try {
                        MyTreeNode selected = (MyTreeNode)arg0.getPath().getLastPathComponent();
                        HierarchyView.this.propPanel.setWrap(selected.getWrap());
                        HierarchyView.this.intPanel.setWrap(selected.getWrap());
                        HierarchyView.this.reflectionPanel.setControl(selected.getWrap().getControl().getClass());
                        HierarchyView.this.positionImage(selected.getWrap());
                        if (HierarchyView.this.markerFrame == null) {
                            HierarchyView.this.markerFrame = new JWindow();
                            HierarchyView.this.markerFrame.setAlwaysOnTop(true);
                            HierarchyView.this.markerFrame.getContentPane().setBackground(Color.red);
                            HierarchyView.this.markerFrame.setVisible(HierarchyView.this.highlightControl.isSelected());
                        }
                        Rectangle bounds = selected.wrap.getScreenBounds();
                        HierarchyView.this.markerFrame.setLocation(bounds.x - 4, bounds.y - 4);
                        HierarchyView.this.markerFrame.setSize(bounds.width + 8, bounds.height + 8);
                        Area frame = new Area(new java.awt.Rectangle(bounds.width + 8, bounds.height + 8));
                        frame.subtract(new Area(new java.awt.Rectangle(4, 4, bounds.width + 8 - 8, bounds.height + 8 - 8)));
                        HierarchyView.this.markerFrame.setShape(frame);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.refreshingLbl.setVisible(false);
        this.controlTab.setMnemonicAt(0, 49);
        this.controlTab.setMnemonicAt(1, 50);
        this.controlTab.setMnemonicAt(2, 51);
        this.controlTab.setMnemonicAt(3, 52);
        this.robot = new Robot();
    }

    private void positionImage(Wrap<?> wrap) {
        Rectangle bounds = wrap.getScreenBounds();
        this.imageLabel.setBounds(bounds);
        Point center = new Point((int)(bounds.getX() + bounds.getWidth() / 2.0), (int)(bounds.getY() + bounds.getHeight() / 2.0));
        center.x -= this.imageScroll.getViewport().getWidth() / 2;
        center.y -= this.imageScroll.getViewport().getHeight() / 2;
        this.imageScroll.getHorizontalScrollBar().setValue(center.x);
        this.imageScroll.getVerticalScrollBar().setValue(center.y);
    }

    public ComboBoxModel getComboModel() {
        return this.comboModel;
    }

    private void rebuildModel() {
        this.rootNode = new DefaultMutableTreeNode("");
        this.model = new DefaultTreeModel(this.rootNode);
        this.fillAll(this.descr, this.rootNode, null);
    }

    private void fillAll(HierarchyDescriptor subDescr, DefaultMutableTreeNode parent, Wrap wrap) {
        HierarchyDescriptor hd;
        ControlList hierarchy = subDescr.getHierarchy();
        Wrapper wrapper = subDescr.getWrapper();
        List controls = null;
        if (wrap == null) {
            controls = hierarchy.getControls();
        } else if (hierarchy instanceof ControlHierarchy) {
            controls = ((ControlHierarchy)hierarchy).getChildren(wrap.getControl());
        }
        if (controls != null) {
            for (Object c : controls) {
                MyTreeNode node = new MyTreeNode(c, wrapper.wrap(Object.class, c), subDescr.getNodeDescriptor());
                parent.add(node);
                this.fillAll(subDescr, node, node.getWrap());
            }
        }
        if (wrap != null && (hd = subDescr.getSubHierarchyDescriptor(wrap)) != null) {
            this.fillAll(hd, parent, null);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.model;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.controlTree = new JTree();
        this.refreshBtt = new JButton();
        this.jLabel1 = new JLabel();
        this.sleep = new JTextField();
        this.jLabel2 = new JLabel();
        this.refreshingLbl = new JLabel();
        this.jButton1 = new JButton();
        this.highlightControl = new JCheckBox();
        this.watchCursor = new JCheckBox();
        this.controlTab = new JTabbedPane();
        this.underPropPanel = new JPanel();
        this.underReflectionPanel = new JPanel();
        this.underIntPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.imageScroll = new JScrollPane();
        this.setDefaultCloseOperation(3);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HierarchyView.this.formKeyReleased(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(400);
        this.controlTree.setModel(this.getTreeModel());
        this.controlTree.setRootVisible(false);
        this.controlTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HierarchyView.this.controlTreeKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.controlTree);
        this.refreshBtt.setMnemonic('r');
        this.refreshBtt.setText("Refresh");
        this.refreshBtt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HierarchyView.this.refreshBttActionPerformed(evt);
            }
        });
        this.jLabel1.setText("In");
        this.sleep.setText("0");
        this.sleep.setAlignmentX(1.0f);
        this.sleep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HierarchyView.this.sleepActionPerformed(evt);
            }
        });
        this.jLabel2.setText("seconds");
        this.refreshingLbl.setText("Refreshing");
        this.jButton1.setMnemonic('s');
        this.jButton1.setText("Search");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HierarchyView.this.jButton1ActionPerformed(evt);
            }
        });
        this.highlightControl.setText("Highlight control");
        this.highlightControl.setEnabled(this.descr.isActiveHighlightingProvided());
        this.highlightControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HierarchyView.this.highlightControlActionPerformed(evt);
            }
        });
        this.watchCursor.setText("Watch cursor");
        this.watchCursor.setEnabled(this.descr.getElementRetriever() != null);
        this.watchCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HierarchyView.this.watchCursorActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 59, Short.MAX_VALUE).addComponent(this.refreshingLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sleep, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshBtt).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.highlightControl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.watchCursor).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 409, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshBtt).addComponent(this.jLabel2).addComponent(this.sleep, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.refreshingLbl).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.highlightControl).addComponent(this.watchCursor)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        GroupLayout underPropPanelLayout = new GroupLayout(this.underPropPanel);
        this.underPropPanel.setLayout(underPropPanelLayout);
        underPropPanelLayout.setHorizontalGroup(underPropPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 439, Short.MAX_VALUE));
        underPropPanelLayout.setVerticalGroup(underPropPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 454, Short.MAX_VALUE));
        this.controlTab.addTab("1. Properties", this.underPropPanel);
        GroupLayout underReflectionPanelLayout = new GroupLayout(this.underReflectionPanel);
        this.underReflectionPanel.setLayout(underReflectionPanelLayout);
        underReflectionPanelLayout.setHorizontalGroup(underReflectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 439, Short.MAX_VALUE));
        underReflectionPanelLayout.setVerticalGroup(underReflectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 454, Short.MAX_VALUE));
        this.controlTab.addTab("2. Reflection", this.underReflectionPanel);
        GroupLayout underIntPanelLayout = new GroupLayout(this.underIntPanel);
        this.underIntPanel.setLayout(underIntPanelLayout);
        underIntPanelLayout.setHorizontalGroup(underIntPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 439, Short.MAX_VALUE));
        underIntPanelLayout.setVerticalGroup(underIntPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 454, Short.MAX_VALUE));
        this.controlTab.addTab("3. Interfaces", this.underIntPanel);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageScroll, GroupLayout.Alignment.TRAILING, -1, 439, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageScroll, -1, 454, Short.MAX_VALUE));
        this.controlTab.addTab("4. Image", this.jPanel2);
        this.jSplitPane1.setRightComponent(this.controlTab);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING));
        this.pack();
    }

    private void takeShot() {
        this.shot = this.robot.createScreenCapture(this.fullScreen);
        this.imageLabel.setIcon(new ImageIcon(this.shot));
    }

    private void formKeyReleased(KeyEvent evt) {
    }

    private void highlightControlActionPerformed(ActionEvent evt) {
        if (this.markerFrame != null) {
            this.markerFrame.setVisible(this.highlightControl.isSelected());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.sd.setLocation(this.getLocation().x, this.getLocation().y + this.getHeight() - this.sd.getHeight());
        this.sd.setVisible(true);
        if (this.sd.isConfirmed()) {
            MyTreeNode res = this.search(this.rootNode, this.sd.getClassNameFilter(), this.sd.getPropertyFilter());
            if (res != null) {
                this.controlTree.setSelectionPath(new TreePath(res.getPath()));
                this.controlTree.requestFocus();
            } else {
                String msg = "Class name: \"" + this.sd.getClassNameFilter() + "\"" + (this.sd.getPropertyFilter() != null ? ", property: \"" + this.sd.getPropertyFilter() + "\"" : "");
                JOptionPane.showMessageDialog(null, msg, "None found", 0);
            }
        }
    }

    private void sleepActionPerformed(ActionEvent evt) {
    }

    private void refreshBttActionPerformed(ActionEvent evt) {
        this.sleep.setEditable(false);
        this.refreshBtt.setVisible(false);
        this.refreshingLbl.setVisible(true);
        new Thread(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            HierarchyView.this.sleepValue = Integer.parseInt(HierarchyView.this.sleep.getText());
                        }
                    });
                    for (int restSleep = HierarchyView.this.sleepValue; restSleep > 0; --restSleep) {
                        final String newText = Integer.toString(restSleep);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HierarchyView.this.sleep.setText(newText);
                            }
                        });
                        Thread.sleep(1000L);
                    }
                    HierarchyView.this.rebuildModel();
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, ex);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HierarchyView.this.refreshingLbl.setVisible(false);
                            HierarchyView.this.refreshBtt.setVisible(true);
                            HierarchyView.this.sleep.setEditable(true);
                            HierarchyView.this.sleep.setText(Integer.toString(HierarchyView.this.sleepValue));
                            HierarchyView.this.controlTree.setModel(HierarchyView.this.model);
                            HierarchyView.this.controlTree.revalidate();
                            HierarchyView.this.controlTree.requestFocus();
                            HierarchyView.this.takeShot();
                        }
                    });
                }
                catch (InterruptedException e) {
                    Logger.getLogger(HierarchyView.class.getName()).log(Level.SEVERE, null, e);
                    {
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }).start();
    }

    private void controlTreeKeyReleased(KeyEvent evt) {
    }

    private void watchCursorActionPerformed(ActionEvent evt) {
        if (this.watchCursor.isSelected()) {
            this.watcherRunning = true;
            final ElementRetriever retriever = this.descr.getElementRetriever();
            if (retriever != null) {
                Thread watcher = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (HierarchyView.this.watcherRunning) {
                            Object element;
                            MyTreeNode watched;
                            Point pt = MouseInfo.getPointerInfo().getLocation();
                            try {
                                new Robot().waitForIdle();
                                for (int i = 0; i < 10; ++i) {
                                    if (!HierarchyView.this.watcherRunning) {
                                        return;
                                    }
                                    Thread.sleep(200L);
                                    Point new_pt = MouseInfo.getPointerInfo().getLocation();
                                    if (new_pt.equals(pt)) continue;
                                    pt = new_pt;
                                    i = 0;
                                }
                            }
                            catch (AWTException i) {
                            }
                            catch (InterruptedException i) {
                                // empty catch block
                            }
                            if ((watched = HierarchyView.this.search(HierarchyView.this.rootNode, element = retriever.fromPoint(pt))) == null || watched.equals(HierarchyView.this.latestWatched)) continue;
                            final TreePath treePath = new TreePath(watched.getPath());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HierarchyView.this.controlTree.setSelectionPath(treePath);
                                    HierarchyView.this.controlTree.scrollPathToVisible(treePath);
                                    HierarchyView.this.controlTree.requestFocus();
                                    HierarchyView.this.latestWatched = watched;
                                }
                            });
                        }
                    }
                });
                watcher.start();
            }
        } else {
            this.watcherRunning = false;
        }
    }

    private MyTreeNode search(DefaultMutableTreeNode node, List<Integer> path) {
        for (Integer index : path) {
            node = (MyTreeNode)node.getChildAt(index);
        }
        return (MyTreeNode)node;
    }

    private MyTreeNode search(DefaultMutableTreeNode node, Object control) {
        MyTreeNode mtnode;
        Object element;
        if (node instanceof MyTreeNode && (element = (mtnode = (MyTreeNode)node).getWrap().getControl()).equals(control)) {
            return mtnode;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MyTreeNode res = this.search((DefaultMutableTreeNode)node.getChildAt(i), control);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private MyTreeNode search(DefaultMutableTreeNode node, String className, String property) {
        if (node instanceof MyTreeNode && ((MyTreeNode)node).getWrap().getControl().getClass().getName().indexOf(className) > 1) {
            MyTreeNode mtnode = (MyTreeNode)node;
            if (property != null) {
                HashMap props = mtnode.getWrap().getProperties();
                for (String prop : props.keySet()) {
                    if (props.get(prop) == null || props.get(prop).toString() == null || !props.get(prop).toString().contains(property)) continue;
                    return mtnode;
                }
            } else {
                return mtnode;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MyTreeNode res = this.search((DefaultMutableTreeNode)node.getChildAt(i), className, property);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private class MyComboModel
    implements ComboBoxModel {
        Class<?> selected;

        private MyComboModel() {
        }

        @Override
        public void setSelectedItem(Object arg0) {
            System.out.println(arg0 + " selected");
            this.selected = (Class)arg0;
        }

        @Override
        public Object getSelectedItem() {
            System.out.println("selected = " + this.selected);
            return this.selected;
        }

        @Override
        public int getSize() {
            return HierarchyView.this.subHs.size();
        }

        @Override
        public Object getElementAt(int arg0) {
            return HierarchyView.this.subHs.get(arg0);
        }

        @Override
        public void addListDataListener(ListDataListener arg0) {
        }

        @Override
        public void removeListDataListener(ListDataListener arg0) {
        }
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        Wrap wrap;
        Object control;
        NodeDescriptor descriptor;

        public MyTreeNode(Object control, Wrap wrap, NodeDescriptor descriptor) {
            super(control);
            this.wrap = null;
            this.control = control;
            this.wrap = wrap;
            this.descriptor = descriptor;
        }

        public Wrap<?> getWrap() {
            return this.wrap;
        }

        @Override
        public String toString() {
            return this.descriptor.toString(this.control);
        }
    }
}

