/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.env.Timeout;
import org.jemmy.input.CharBindingMap;
import org.jemmy.input.DefaultCharBindingMap;
import org.jemmy.input.awt.RobotDriver;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Modifier;

public class KeyboardImpl
implements Keyboard {
    CharBindingMap<Keyboard.KeyboardButton, Keyboard.KeyboardModifier> map;
    Environment env;
    Wrap<?> target;
    RobotDriver robotDriver;
    private boolean detached;

    public KeyboardImpl(Wrap<?> target) {
        this.robotDriver = new RobotDriver(target.getEnvironment());
        this.env = target.getEnvironment();
        this.map = target.getEnvironment().getBindingMap();
        this.target = target;
    }

    private void runAction(Action action) {
        if (this.detached) {
            this.target.getEnvironment().getExecutor().executeDetached(this.target.getEnvironment(), false, action, new Object[0]);
        } else {
            this.target.getEnvironment().getExecutor().execute(this.target.getEnvironment(), false, action, new Object[0]);
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void pushKey(final Keyboard.KeyboardButton kbdButton, final Modifier[] modifiers, final Timeout pushTime) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                if (KeyboardImpl.this.target.is(Focusable.class)) {
                    ((Focusable)KeyboardImpl.this.target.as(Focusable.class)).focuser().focus();
                }
                KeyboardImpl.this.pressKey(kbdButton, modifiers);
                pushTime.sleep();
                KeyboardImpl.this.releaseKey(kbdButton, modifiers);
            }

            public String toString() {
                return "push " + kbdButton + " key with " + modifiers + " modifiers";
            }
        });
    }

    public void typeChar(char keyChar, Timeout pushTime) {
        this.pushKey(pushTime, (Keyboard.KeyboardButton)this.map.getCharKey(keyChar), this.map.getCharModifiers(keyChar));
    }

    public void pressKey(final Keyboard.KeyboardButton kbdButton, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                KeyboardImpl.this.robotDriver.pressKey(kbdButton, modifiers);
            }

            public String toString() {
                return "press " + kbdButton + " key with " + modifiers + " modifiers";
            }
        });
    }

    public void releaseKey(final Keyboard.KeyboardButton kbdButton, final Modifier ... modifiers) {
        this.runAction(new Action(){

            public void run(Object ... parameters) {
                KeyboardImpl.this.robotDriver.releaseKey(kbdButton, modifiers);
            }

            public String toString() {
                return "press " + kbdButton + " key with " + modifiers + " modifiers";
            }
        });
    }

    public void pressKey(Keyboard.KeyboardButton kbdButton) {
        this.pressKey(kbdButton, new Modifier[0]);
    }

    public void releaseKey(Keyboard.KeyboardButton kbdButton) {
        this.releaseKey(kbdButton, new Modifier[0]);
    }

    public void pushKey(Keyboard.KeyboardButton kbdButton, Modifier ... modifiers) {
        this.pushKey(kbdButton, modifiers, this.getEnvironment().getTimeout(PUSH.getName()));
    }

    public void pushKey(Keyboard.KeyboardButton kbdButton) {
        this.pushKey(kbdButton, new Modifier[0]);
    }

    public void typeChar(char keyChar) {
        this.typeChar(keyChar, this.getEnvironment().getTimeout(PUSH.getName()));
    }

    public Keyboard detached() {
        this.detached = true;
        return this;
    }

    public void pushKey(Timeout pushTime, Keyboard.KeyboardButton key, Modifier ... modifiers) {
        this.pushKey(key, modifiers, pushTime);
    }

    static {
        Environment.getEnvironment().setTimeout(new Timeout(PUSH.getName(), 100L));
        Environment.getEnvironment().setBindingMap((CharBindingMap)new DefaultCharBindingMap());
    }
}

