/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.image.BufferedImage;
import org.jemmy.Point;
import org.jemmy.image.awt.ImageFinder;

public class StrictImageFinder
implements ImageFinder {
    int bigWidth;
    int bigHeight;
    int[][] bigPixels;

    public StrictImageFinder(BufferedImage area) {
        this.bigWidth = area.getWidth();
        this.bigHeight = area.getHeight();
        this.bigPixels = new int[this.bigWidth][this.bigHeight];
        for (int x = 0; x < this.bigWidth; ++x) {
            for (int y = 0; y < this.bigHeight; ++y) {
                this.bigPixels[x][y] = area.getRGB(x, y);
            }
        }
    }

    @Override
    public Point findImage(BufferedImage image, int index) {
        int smallWidth = image.getWidth();
        int smallHeight = image.getHeight();
        int[][] smallPixels = new int[smallWidth][smallHeight];
        for (int x = 0; x < smallWidth; ++x) {
            for (int y = 0; y < smallHeight; ++y) {
                smallPixels[x][y] = image.getRGB(x, y);
            }
        }
        int count = 0;
        for (int X = 0; X <= this.bigWidth - smallWidth; ++X) {
            for (int Y = 0; Y <= this.bigHeight - smallHeight; ++Y) {
                boolean good = true;
                for (int x = 0; x < smallWidth; ++x) {
                    for (int y = 0; y < smallHeight; ++y) {
                        if (smallPixels[x][y] == this.bigPixels[X + x][Y + y]) continue;
                        good = false;
                        break;
                    }
                    if (!good) break;
                }
                if (!good) continue;
                if (count == index) {
                    return new Point(X, Y);
                }
                ++count;
            }
        }
        return null;
    }
}

