/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jemmy.Dimension;
import org.jemmy.env.Environment;
import org.jemmy.env.TestOut;
import org.jemmy.image.Image;
import org.jemmy.image.ImageComparator;
import org.jemmy.image.awt.AWTImage;
import org.jemmy.image.pixel.ResizeComparator;

public class ResizeImageComparator
extends ResizeComparator {
    public static final String OUTPUT = ResizeImageComparator.class.getName() + ".OUTPUT";
    ResizeMode resizeMode = ResizeMode.PROPORTIONAL_RESIZE;
    int hint = 1;
    double propDistThreshold = 0.02;

    public ResizeImageComparator(ImageComparator subComparator) {
        super(subComparator, ResizeComparator.Mode.LEFT);
    }

    public ResizeImageComparator(ResizeMode resizeMode, ImageComparator subComparator) {
        this(subComparator);
        this.resizeMode = resizeMode;
    }

    public ResizeImageComparator(double propDistThreshold, ImageComparator subComparator) {
        this(subComparator);
        this.propDistThreshold = propDistThreshold;
    }

    public ResizeImageComparator(ResizeMode resizeMode, double propDistThreshold, int hint, ImageComparator subComparator) {
        this(subComparator);
        this.resizeMode = resizeMode;
        this.hint = hint;
        this.propDistThreshold = propDistThreshold;
    }

    public Image resize(Image image, Dimension size) {
        Dimension isize = this.getSize(image);
        double scalex = (double)size.width / (double)isize.width;
        double scaley = (double)size.height / (double)isize.height;
        switch (this.resizeMode) {
            case NO_RESIZE: {
                return image;
            }
            case PROPORTIONAL_RESIZE: {
                if (Math.abs(scalex - scaley) > this.propDistThreshold) {
                    return null;
                }
            }
            case ARBITRARY_RESIZE: {
                BufferedImage res = new BufferedImage(size.width, size.height, ((AWTImage)image).getTheImage().getType());
                java.awt.Image scaled = ((AWTImage)image).getTheImage().getScaledInstance(size.width, size.height, this.hint);
                Graphics2D g = res.createGraphics();
                g.drawImage(scaled, 0, 0, null);
                g.dispose();
                return new AWTImage(res);
            }
        }
        return null;
    }

    public String getID() {
        return ResizeImageComparator.class.getName() + "(" + this.getSubComparator().getID() + ")";
    }

    public Dimension getSize(Image image) {
        BufferedImage bi = ((AWTImage)image).getTheImage();
        return new Dimension(bi.getWidth(), bi.getHeight());
    }

    static {
        Environment.getEnvironment().setOutput(OUTPUT, TestOut.getNullOutput());
    }

    public static enum ResizeMode {
        NO_RESIZE,
        PROPORTIONAL_RESIZE,
        ARBITRARY_RESIZE;

    }
}

