/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jemmy.Dimension;
import org.jemmy.JemmyException;
import org.jemmy.env.Environment;
import org.jemmy.image.Image;
import org.jemmy.image.ImageComparator;
import org.jemmy.image.ImageStore;
import org.jemmy.image.awt.BufferedImageComparator;
import org.jemmy.image.awt.PNGImageSaver;
import org.jemmy.image.pixel.PNGFileImageStore;
import org.jemmy.image.pixel.PixelImageComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.WriteableRaster;

public class AWTImage
implements Image,
WriteableRaster {
    public static final String OUTPUT = AWTImage.class.getName() + ".OUTPUT";
    public static final String PNG_FILE = ".png";
    private BufferedImage image;

    public static File getImageRoot() {
        ImageStore res = (ImageStore)Environment.getEnvironment().getProperty(ImageStore.class);
        if (!(res instanceof PNGFileImageStore)) {
            throw new IllegalStateException("Unsupported ImageStore: " + res.getClass().getName());
        }
        return ((PNGFileImageStore)res).getRoot();
    }

    public static void setImageRoot(File imageRoot) {
        Environment.getEnvironment().setProperty(ImageStore.class, (Object)new PNGFileImageStore(imageRoot));
    }

    public static ImageComparator getComparator() {
        return (ImageComparator)Environment.getEnvironment().getProperty(ImageComparator.class);
    }

    public static void setComparator(ImageComparator comparator) {
        Environment.getEnvironment().setProperty(ImageComparator.class, (Object)comparator);
    }

    public AWTImage(BufferedImage img) {
        this.image = img;
    }

    public BufferedImage getTheImage() {
        return this.image;
    }

    public Image compareTo(Image img) {
        return AWTImage.getComparator().compare((Image)this, img);
    }

    public void save(String fileName) {
        try {
            String fullPath = fileName;
            File imageRoot = AWTImage.getImageRoot();
            if (imageRoot != null) {
                fullPath = imageRoot.getAbsolutePath() + File.separator + fileName;
            }
            if (!fullPath.toLowerCase().endsWith(PNG_FILE)) {
                fullPath = fullPath + PNG_FILE;
            }
            new PNGImageSaver().save(this.image, fullPath);
            Environment.getEnvironment().getOutput(OUTPUT).println("Image saved to " + fullPath);
        }
        catch (IOException ex) {
            throw new JemmyException("Unable to save image", (Throwable)ex, (Object)fileName);
        }
    }

    public Dimension getSize() {
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public void getColors(int x, int y, double[] colors) {
        int orig = this.image.getRGB(x, y);
        for (Raster.Component c : this.getSupported()) {
            int ivalue;
            switch (c) {
                case ALPHA: {
                    ivalue = (orig & 0xFF000000) >>> 24;
                    break;
                }
                case RED: {
                    ivalue = (orig & 0xFF0000) >>> 16;
                    break;
                }
                case GREEN: {
                    ivalue = (orig & 0xFF00) >>> 8;
                    break;
                }
                case BLUE: {
                    ivalue = orig & 0xFF;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown color component" + c);
                }
            }
            colors[PixelImageComparator.arrayIndexOf((Raster.Component[])this.getSupported(), (Raster.Component)c)] = (double)ivalue / 255.0;
        }
    }

    public void setColors(int x, int y, double[] colors) {
        int rgb = 0;
        block6: for (Raster.Component c : this.getSupported()) {
            double value = colors[PixelImageComparator.arrayIndexOf((Raster.Component[])this.getSupported(), (Raster.Component)c)];
            if (value < 0.0 || value > 1.0) {
                throw new IllegalArgumentException("Color component value should be within (0, 1). Gotten: " + value);
            }
            int ivalue = (int)Math.round(value * 255.0);
            if (ivalue > 255) {
                throw new IllegalStateException("Component value is greater than 0xFF: " + ivalue);
            }
            switch (c) {
                case ALPHA: {
                    rgb |= ivalue << 24;
                    continue block6;
                }
                case RED: {
                    rgb |= ivalue << 16;
                    continue block6;
                }
                case GREEN: {
                    rgb |= ivalue << 8;
                    continue block6;
                }
                case BLUE: {
                    rgb |= ivalue;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown color component: " + c);
                }
            }
        }
        this.getTheImage().setRGB(x, y, rgb);
    }

    public Raster.Component[] getSupported() {
        return new Raster.Component[]{Raster.Component.RED, Raster.Component.BLUE, Raster.Component.GREEN, Raster.Component.ALPHA};
    }

    static {
        Environment.getEnvironment().setPropertyIfNotSet(ImageComparator.class, (Object)new BufferedImageComparator(Environment.getEnvironment()));
        Environment.getEnvironment().setPropertyIfNotSet(ImageStore.class, (Object)new PNGFileImageStore());
    }
}

