/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti.engine.impl.variable.VariableTypes;

public abstract class VariableScopeImpl
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;
    protected Map<String, VariableInstanceEntity> usedVariablesCache = new HashMap<String, VariableInstanceEntity>();
    protected ELContext cachedElContext;
    protected String id = null;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new ActivitiException("lazy loading outside command context");
            }
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances() {
        return this.collectVariableInstances(new HashMap<String, VariableInstance>());
    }

    @Override
    public Map<String, Object> getVariables(Collection<String> variableNames) {
        return this.getVariables(variableNames, true);
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames) {
        return this.getVariableInstances(variableNames, true);
    }

    @Override
    public Map<String, Object> getVariables(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string).getValue());
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariables();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : variables) {
            requestedVariables.put(variable.getName(), variable.getValue());
        }
        VariableScopeImpl variableScopeImpl = this.getParentVariableScope();
        if (variableScopeImpl != null) {
            requestedVariables.putAll(variableScopeImpl.getVariables(variableNamesToFetch, fetchAllVariables));
        }
        return requestedVariables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string));
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstances();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : variables) {
            requestedVariables.put(variable.getName(), variable);
        }
        VariableScopeImpl variableScopeImpl = this.getParentVariableScope();
        if (variableScopeImpl != null) {
            requestedVariables.putAll(variableScopeImpl.getVariableInstances(variableNamesToFetch, fetchAllVariables));
        }
        return requestedVariables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        return variables;
    }

    protected Map<String, VariableInstance> collectVariableInstances(HashMap<String, VariableInstance> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariableInstances(variables));
        }
        for (VariableInstance variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String string : this.usedVariablesCache.keySet()) {
            variables.put(string, this.usedVariablesCache.get(string));
        }
        return variables;
    }

    @Override
    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    @Override
    public VariableInstance getVariableInstance(String variableName) {
        return this.getVariableInstance(variableName, true);
    }

    @Override
    public Object getVariable(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstance(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    @Override
    public VariableInstance getVariableInstance(String variableName, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                return this.usedVariablesCache.get(variableName);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            VariableScopeImpl parentScope = this.getParentVariableScope();
            if (parentScope != null) {
                return parentScope.getVariableInstance(variableName, true);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            return this.variableInstances.get(variableName);
        }
        VariableInstanceEntity variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName, false);
        }
        return null;
    }

    protected abstract VariableInstanceEntity getSpecificVariable(String var1);

    @Override
    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    @Override
    public VariableInstance getVariableInstanceLocal(String variableName) {
        return this.getVariableInstanceLocal(variableName, true);
    }

    @Override
    public Object getVariableLocal(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstanceLocal(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    @Override
    public VariableInstance getVariableInstanceLocal(String variableName, boolean fetchAllVariables) {
        VariableInstanceEntity variable;
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                return this.usedVariablesCache.get(variableName);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName) && (variable = this.usedVariablesCache.get(variableName)) != null) {
            return variable;
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName) && (variable = this.variableInstances.get(variableName)) != null) {
            return this.variableInstances.get(variableName);
        }
        variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        return null;
    }

    @Override
    public boolean hasVariables() {
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        return variables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal() {
        HashMap<String, VariableInstance> variables = new HashMap<String, VariableInstance>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName));
        }
        return variables;
    }

    @Override
    public Map<String, Object> getVariablesLocal(Collection<String> variableNames) {
        return this.getVariablesLocal(variableNames, true);
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return this.getVariableInstancesLocal(variableNames, true);
    }

    @Override
    public Map<String, Object> getVariablesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariablesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable.getValue());
            }
        }
        return requestedVariables;
    }

    @Override
    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName));
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstancesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable);
            }
        }
        return requestedVariables;
    }

    protected abstract List<VariableInstanceEntity> getSpecificVariables(Collection<String> var1);

    @Override
    public Set<String> getVariableNamesLocal() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.keySet();
    }

    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return Collections.unmodifiableMap(this.variableInstances);
    }

    public Map<String, Object> getVariableValues() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        if (this.variableInstances != null) {
            for (String varName : this.variableInstances.keySet()) {
                VariableInstanceEntity variableEntity = this.variableInstances.get(varName);
                if (variableEntity != null) {
                    variableMap.put(varName, variableEntity.getValue());
                    continue;
                }
                variableMap.put(varName, null);
            }
        }
        return variableMap;
    }

    public Map<String, VariableInstanceEntity> getUsedVariablesCache() {
        return this.usedVariablesCache;
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    public void deleteVariablesInstanceForLeavingScope() {
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
            variableInstance.delete();
        }
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), true);
    }

    @Override
    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    protected void setVariable(String variableName, Object value, ExecutionEntity sourceActivityExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
            }
            if (this.hasVariableLocal(variableName)) {
                this.setVariableLocal(variableName, value, sourceActivityExecution, true);
                return;
            }
            VariableScopeImpl parentVariableScope = this.getParentVariableScope();
            if (parentVariableScope != null) {
                if (sourceActivityExecution == null) {
                    parentVariableScope.setVariable(variableName, value);
                } else {
                    parentVariableScope.setVariable(variableName, value, sourceActivityExecution, true);
                }
                return;
            }
            this.createVariableLocal(variableName, value);
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceActivityExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceActivityExecution);
                this.usedVariablesCache.put(variableName, variable);
            } else {
                VariableScopeImpl parent = this.getParentVariableScope();
                if (parent != null) {
                    if (sourceActivityExecution == null) {
                        parent.setVariable(variableName, value, fetchAllVariables);
                    } else {
                        parent.setVariable(variableName, value, sourceActivityExecution, fetchAllVariables);
                    }
                    return;
                }
                variable = this.createVariableInstance(variableName, value, sourceActivityExecution);
                this.usedVariablesCache.put(variableName, variable);
            }
        }
    }

    @Override
    public Object setVariableLocal(String variableName, Object value) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), true);
    }

    @Override
    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    public Object setVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance == null) {
                variableInstance = this.usedVariablesCache.get(variableName);
            }
            if (variableInstance == null) {
                this.createVariableLocal(variableName, value);
            } else {
                this.updateVariableInstance(variableInstance, value, sourceActivityExecution);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceActivityExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceActivityExecution);
            } else {
                variable = this.createVariableInstance(variableName, value, sourceActivityExecution);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
        return null;
    }

    @Override
    public void createVariableLocal(String variableName, Object value) {
        this.createVariableLocal(variableName, value, this.getSourceActivityExecution());
    }

    protected void createVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new ActivitiException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityExecution());
    }

    protected void removeVariable(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityExecution());
    }

    protected ExecutionEntity getSourceActivityExecution() {
        return null;
    }

    protected void removeVariableLocal(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            this.deleteVariableInstanceForExplicitUserCall(variableInstance, sourceActivityExecution);
        }
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance, ExecutionEntity sourceActivityExecution) {
        variableInstance.delete();
        variableInstance.setValue(null);
        Context.getCommandContext().getHistoryManager().recordVariableRemoved(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType newType = variableTypes.findVariableType(value);
        if (variableInstance != null && !variableInstance.getType().equals(newType)) {
            variableInstance.setValue(null);
            variableInstance.setType(newType);
            variableInstance.forceUpdate();
            variableInstance.setValue(value);
        } else if (variableInstance != null) {
            variableInstance.setValue(value);
        }
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        if (this.variableInstances != null) {
            this.variableInstances.put(variableName, variableInstance);
        }
        Context.getCommandContext().getHistoryManager().recordVariableCreate(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        return variableInstance;
    }

    protected boolean isActivityIdUsedForDetails() {
        return true;
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public <T> T getVariable(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(variableName));
    }

    @Override
    public <T> T getVariableLocal(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(variableName));
    }
}

