/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.task.Attachment;

public class AttachmentEntityManager
extends AbstractManager {
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
    }

    public void deleteAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        List attachments = this.getDbSqlSession().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
        boolean dispatchEvents = this.getProcessEngineConfiguration().getEventDispatcher().isEnabled();
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty()) {
            HistoricProcessInstanceEntity processInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId);
            if (processInstance != null) {
                processDefinitionId = processInstance.getProcessDefinitionId();
                executionId = processInstance.getId();
            }
            for (AttachmentEntity attachment : attachments) {
                if (attachment.getTaskId() != null) continue;
                String contentId = attachment.getContentId();
                if (contentId != null) {
                    this.getByteArrayManager().deleteByteArrayById(contentId);
                }
                this.getDbSqlSession().delete(attachment);
                if (!dispatchEvents) continue;
                this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
            }
        }
    }

    public void deleteAttachmentsByTaskId(String taskId) {
        HistoricTaskInstanceEntity task;
        this.checkHistoryEnabled();
        List attachments = this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
        boolean dispatchEvents = this.getProcessEngineConfiguration().getEventDispatcher().isEnabled();
        String processInstanceId = null;
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty() && (task = this.getHistoricTaskInstanceManager().findHistoricTaskInstanceById(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayManager().deleteByteArrayById(contentId);
            }
            this.getDbSqlSession().delete(attachment);
            if (!dispatchEvents) continue;
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use attachments, history should be enabled");
        }
    }
}

