/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class DeleteIdentityLinkForProcessInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkForProcessInstanceCmd(String processInstanceId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, processInstanceId, type);
        this.processInstanceId = processInstanceId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String processInstanceId, String type) {
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("type is required when deleting a process identity link");
        }
        if (userId == null && groupId == null) {
            throw new ActivitiIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process instance with id " + this.processInstanceId, ExecutionEntity.class);
        }
        processInstance.deleteIdentityLink(this.userId, this.groupId, this.type);
        commandContext.getHistoryManager().createProcessInstanceIdentityLinkComment(this.processInstanceId, this.userId, this.groupId, this.type, false);
        return null;
    }
}

