/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferEncodingStream;
import org.acplt.oncrpc.XdrHttpDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class OncRpcHttpClient
extends OncRpcClient {
    private String hostname;
    private int httpPort;
    private String cgiHandlerPath;
    private String oncrpcHostname;
    private int oncrpcProtocol;
    private HttpClientConnection httpClient;
    private XdrBufferEncodingStream sendingXdr;
    private XdrHttpDecodingStream receivingXdr;

    public OncRpcHttpClient(String hostname, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port) throws OncRpcException, IOException {
        this(hostname, 80, cgiHandlerPath, oncrpcHostname, program, version, port, 6);
    }

    public OncRpcHttpClient(String hostname, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        this(hostname, 80, cgiHandlerPath, oncrpcHostname, program, version, port, protocol);
    }

    public OncRpcHttpClient(String hostname, int httpPort, String cgiHandlerPath, String oncrpcHostname, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        super(null, program, version, -1, -42);
        this.httpPort = httpPort;
        this.cgiHandlerPath = cgiHandlerPath;
        this.oncrpcHostname = oncrpcHostname;
        this.oncrpcProtocol = protocol;
        this.port = port;
        this.hostname = hostname;
        this.httpClient = new HttpClientConnection(hostname, httpPort);
        this.sendingXdr = new XdrBufferEncodingStream(8192);
        this.receivingXdr = new XdrHttpDecodingStream(this.httpClient);
    }

    public void close() throws OncRpcException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sendingXdr = null;
            }
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.receivingXdr = null;
            }
        }
    }

    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        for (int refreshesLeft = 1; refreshesLeft >= 0; --refreshesLeft) {
            int contentLength;
            this.nextXid();
            OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
            OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
            try {
                this.sendingXdr.beginEncoding(null, 0);
                callHeader.xdrEncode(this.sendingXdr);
                params.xdrEncode(this.sendingXdr);
                this.sendingXdr.endEncoding();
            }
            catch (IOException e) {
                throw new OncRpcException(3, e.getLocalizedMessage());
            }
            StringBuffer prefix = new StringBuffer(512);
            prefix.append("CALL ");
            prefix.append(this.oncrpcHostname);
            if (this.port > 0) {
                prefix.append(":");
                prefix.append(this.port);
            }
            prefix.append(" ");
            prefix.append(this.oncrpcProtocol);
            prefix.append(" ");
            prefix.append("TEA/1.0");
            prefix.append("\r\n");
            prefix.append("\r\n");
            int lineCount = (contentLength + 47) / 48;
            int realLength = prefix.length() + (contentLength + 2) / 3 * 4 + lineCount * 2;
            byte[] xdrData = this.sendingXdr.getXdrData();
            try {
                this.httpClient.beginPostRequest(this.cgiHandlerPath, "text/plain", realLength);
                String s = prefix.toString();
                this.httpClient.writeContentBytes(s.getBytes(), 0, s.length());
                byte[] lines = new byte[6600];
                int xdrOffset = 0;
                int offset = 0;
                for (contentLength = this.sendingXdr.getXdrLength(); contentLength >= 48; contentLength -= 48) {
                    if (offset >= 6600) {
                        this.httpClient.writeContentBytes(lines, 0, offset);
                        offset = 0;
                    }
                    offset += Base64.encode(xdrData, xdrOffset, 48, lines, offset);
                    lines[offset++] = 13;
                    lines[offset++] = 10;
                    xdrOffset += 48;
                }
                if (contentLength > 0) {
                    if (offset >= 6600) {
                        this.httpClient.writeContentBytes(lines, 0, offset);
                        offset = 0;
                    }
                    offset += Base64.encode(xdrData, xdrOffset, contentLength, lines, offset);
                    lines[offset++] = 13;
                    lines[offset++] = 10;
                }
                if (offset > 0) {
                    this.httpClient.writeContentBytes(lines, 0, offset);
                }
                this.httpClient.endPostRequest();
            }
            catch (IOException e) {
                throw new OncRpcException(3, e.getLocalizedMessage());
            }
            try {
                this.receivingXdr.beginDecoding();
                int responseCode = this.httpClient.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    throw new OncRpcException(16, "HTTP tunnel response error " + responseCode);
                }
                replyHeader.xdrDecode(this.receivingXdr);
                if (replyHeader.messageId != callHeader.messageId) {
                    this.receivingXdr.endDecoding();
                    throw new OncRpcException(44);
                }
                if (!replyHeader.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (refreshesLeft > 0 && replyHeader.replyStatus == 1 && replyHeader.rejectStatus == 1 && this.auth.canRefreshCred()) continue;
                    throw replyHeader.newException();
                }
                result.xdrDecode(this.receivingXdr);
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException e) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException e) {
                throw new OncRpcException(4, e.getLocalizedMessage());
            }
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.sendingXdr.setCharacterEncoding(characterEncoding);
        this.receivingXdr.setCharacterEncoding(characterEncoding);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

