/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.jdbc.LookupStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityImpl;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class JdbcAclService
implements AclService {
    protected static final Log log = LogFactory.getLog((Class)(class$org$acegisecurity$acls$jdbc$JdbcAclService == null ? (class$org$acegisecurity$acls$jdbc$JdbcAclService = JdbcAclService.class$("org.acegisecurity.acls.jdbc.JdbcAclService")) : class$org$acegisecurity$acls$jdbc$JdbcAclService));
    private static final String selectAclObjectWithParent = "SELECT obj.object_id_identity obj_id, class.class class FROM acl_object_identity obj, acl_object_identity parent, acl_class class WHERE obj.parent_object = parent.id AND obj.object_id_class = class.id AND parent.object_id_identity = ? AND parent.object_id_class = (SELECT id FROM acl_class WHERE acl_class.class = ?)";
    protected JdbcTemplate jdbcTemplate;
    private LookupStrategy lookupStrategy;
    static /* synthetic */ Class class$org$acegisecurity$acls$jdbc$JdbcAclService;

    public JdbcAclService(DataSource dataSource, LookupStrategy lookupStrategy) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)lookupStrategy, (String)"LookupStrategy required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.lookupStrategy = lookupStrategy;
    }

    public ObjectIdentity[] findChildren(ObjectIdentity parentIdentity) {
        Object[] args = new Object[]{parentIdentity.getIdentifier(), parentIdentity.getJavaType().getName()};
        List objects = this.jdbcTemplate.query(selectAclObjectWithParent, args, new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                String javaType = rs.getString("class");
                String identifier = rs.getString("obj_id");
                return new ObjectIdentityImpl(javaType, (Serializable)((Object)identifier));
            }
        });
        return objects.toArray(new ObjectIdentityImpl[0]);
    }

    public Acl readAclById(ObjectIdentity object, Sid[] sids) throws NotFoundException {
        Map map = this.readAclsById(new ObjectIdentity[]{object}, sids);
        if (map.size() == 0) {
            throw new NotFoundException("Could not find ACL");
        }
        return (Acl)map.get(object);
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    public Map readAclsById(ObjectIdentity[] objects) {
        return this.readAclsById(objects, null);
    }

    public Map readAclsById(ObjectIdentity[] objects, Sid[] sids) throws NotFoundException {
        return this.lookupStrategy.readAclsById(objects, sids);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

