/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayCache {
    private final Logger log = LoggerFactory.getLogger(ReplayCache.class);
    private StorageService<String, ReplayCacheEntry> storage;
    private String partition;
    private long entryDuration;
    private ReentrantLock cacheLock;

    public ReplayCache(StorageService<String, ReplayCacheEntry> storageService, long duration) {
        this.storage = storageService;
        this.entryDuration = duration;
        this.partition = "replay";
        this.cacheLock = new ReentrantLock(true);
    }

    public ReplayCache(StorageService<String, ReplayCacheEntry> storageService, String storageParition, long duration) {
        this.storage = storageService;
        this.entryDuration = duration;
        this.partition = !DatatypeHelper.isEmpty((String)storageParition) ? DatatypeHelper.safeTrim((String)storageParition) : "replay";
        this.cacheLock = new ReentrantLock(true);
    }

    public boolean isReplay(String issuerId, String messageId) {
        this.log.debug("Attempting to acquire lock for replay cache check");
        this.cacheLock.lock();
        this.log.debug("Lock acquired");
        try {
            boolean replayed = true;
            String entryHash = String.valueOf(issuerId) + messageId;
            ReplayCacheEntry cacheEntry = this.storage.get(this.partition, entryHash);
            if (cacheEntry == null || cacheEntry.isExpired()) {
                if (this.log.isDebugEnabled()) {
                    if (cacheEntry == null) {
                        this.log.debug("Message ID {} was not a replay", (Object)messageId);
                    } else if (cacheEntry.isExpired()) {
                        this.log.debug("Message ID {} expired in replay cache at {}", (Object)messageId, (Object)cacheEntry.getExpirationTime().toString());
                        this.storage.remove(this.partition, entryHash);
                    }
                }
                replayed = false;
                this.addMessageID(entryHash, new DateTime().plus(this.entryDuration));
            } else {
                this.log.debug("Replay of message ID {} detected in replay cache, will expire at {}", (Object)messageId, (Object)cacheEntry.getExpirationTime().toString());
            }
            boolean bl = replayed;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    protected void addMessageID(String messageId, DateTime expiration) {
        this.log.debug("Writing message ID {} to replay cache with expiration time {}", (Object)messageId, (Object)expiration.toString());
        this.storage.put(this.partition, messageId, new ReplayCacheEntry(expiration));
    }

    public class ReplayCacheEntry
    implements ExpiringObject,
    Serializable {
        private static final long serialVersionUID = 2398693920546938083L;
        private DateTime expirationTime;

        public ReplayCacheEntry(DateTime expiration) {
            this.expirationTime = expiration;
        }

        public DateTime getExpirationTime() {
            return this.expirationTime;
        }

        public boolean isExpired() {
            return this.expirationTime.isBeforeNow();
        }

        public void onExpire() {
        }
    }
}

