/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.soap.client.ClientTransportFactory;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPClient {
    private HashMap<String, ClientTransportFactory> transportFactories;

    public Map<String, ClientTransportFactory> getRegisteredTransports() {
        return this.transportFactories;
    }

    public void send(URI endpointURI, MessageContext messageContext) throws TransportException, MessageDecodingException, SecurityPolicyException {
        if (!(messageContext.getOutboundMessage() instanceof Envelope)) {
            throw new TransportException("Outbound message must be a SOAP Envelope");
        }
        String transportScheme = endpointURI.getScheme();
        ClientTransportFactory transFactory = this.transportFactories.get(transportScheme);
        if (transFactory == null) {
            throw new TransportException("No transport registered for URI scheme: " + transportScheme);
        }
        Object transport = transFactory.createTransport();
        transport.send(endpointURI, messageContext);
    }
}

