/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.client;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.soap.client.ClientTransport;
import org.opensaml.ws.soap.client.ClientTransportFactory;
import org.opensaml.ws.soap.client.HTTPSOAPTransport;
import org.opensaml.ws.transport.http.HTTPTransport;

public class HTTPSOAPTransportFactory
implements ClientTransportFactory {
    private int socketTimeout = 30000;
    private int connectionTimeout = 60000;
    private HTTPTransport.HTTP_VERSION httpVersion = HTTPTransport.HTTP_VERSION.HTTP1_1;
    private MessageEncoder messageEncoder;
    private MessageDecoder messageDecoder;
    private HttpClient httpClient;

    public HTTPSOAPTransportFactory(MessageEncoder encoder, MessageDecoder decoder) {
        this.messageEncoder = encoder;
        this.messageDecoder = decoder;
        this.initializeHttpClient();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public HTTPTransport.HTTP_VERSION getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HTTPTransport.HTTP_VERSION version) {
        this.httpVersion = version;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public MessageDecoder getMessageDecoder() {
        return this.messageDecoder;
    }

    public MessageEncoder getMessageEncoder() {
        return this.messageEncoder;
    }

    public ClientTransport createTransport() {
        return new HTTPSOAPTransport(this.httpClient, this.messageEncoder, this.messageDecoder);
    }

    protected void initializeHttpClient() {
        HttpConnectionManagerParams connectionParams = new HttpConnectionManagerParams();
        connectionParams.setConnectionTimeout(this.connectionTimeout);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(connectionParams);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setSoTimeout(this.socketTimeout);
        if (this.httpVersion == HTTPTransport.HTTP_VERSION.HTTP1_0) {
            clientParams.setVersion(HttpVersion.HTTP_1_0);
        } else {
            clientParams.setVersion(HttpVersion.HTTP_1_1);
        }
        this.httpClient = new HttpClient(clientParams, (HttpConnectionManager)connectionManager);
    }
}

