/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.util.LinkedHashSet;
import javax.servlet.ServletRequest;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.provider.BaseTrustEngineRuleFactory;
import org.opensaml.ws.security.provider.ClientCertAuthRule;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertAuthRuleFactory
extends BaseTrustEngineRuleFactory<X509Credential, ServletRequest> {
    private CertificateNameOptions certNameOptions = this.newCertificateNameOptions();

    protected CertificateNameOptions newCertificateNameOptions() {
        return new CertificateNameOptions();
    }

    protected CertificateNameOptions getCertificateNameOptions() {
        return this.certNameOptions.clone();
    }

    @Override
    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        CertificateNameOptions newOptions = this.certNameOptions.clone();
        return new ClientCertAuthRule(this.getTrustEngine(), newOptions);
    }

    public boolean evaluateSubjectCommonName() {
        return this.certNameOptions.evaluateSubjectCommonName;
    }

    public void setEvaluateSubjectCommonName(boolean newValue) {
        this.certNameOptions.evaluateSubjectCommonName = newValue;
    }

    public boolean evaluateSubjectDN() {
        return this.certNameOptions.evaluateSubjectDN;
    }

    public void setEvaluateSubjectDN(boolean newValue) {
        this.certNameOptions.evaluateSubjectDN = newValue;
    }

    public LinkedHashSet<Integer> getSubjectAltNames() {
        return this.certNameOptions.subjectAltNames;
    }

    public X500DNHandler getX500DNHandler() {
        return this.certNameOptions.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.certNameOptions.x500DNHandler = handler;
    }

    public String getX500SubjectDNFormat() {
        return this.certNameOptions.x500SubjectDNFormat;
    }

    public void setX500SubjectDNFormat(String format) {
        this.certNameOptions.x500SubjectDNFormat = format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CertificateNameOptions
    implements Cloneable {
        private boolean evaluateSubjectDN;
        private boolean evaluateSubjectCommonName;
        private LinkedHashSet<Integer> subjectAltNames = new LinkedHashSet();
        private X500DNHandler x500DNHandler = new InternalX500DNHandler();
        private String x500SubjectDNFormat = "RFC2253";

        protected CertificateNameOptions() {
        }

        public boolean evaluateSubjectCommonName() {
            return this.evaluateSubjectCommonName;
        }

        public boolean evaluateSubjectDN() {
            return this.evaluateSubjectDN;
        }

        public LinkedHashSet<Integer> getSubjectAltNames() {
            return this.subjectAltNames;
        }

        public X500DNHandler getX500DNHandler() {
            return this.x500DNHandler;
        }

        public String getX500SubjectDNFormat() {
            return this.x500SubjectDNFormat;
        }

        protected CertificateNameOptions clone() {
            CertificateNameOptions clonedOptions;
            try {
                clonedOptions = (CertificateNameOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            clonedOptions.subjectAltNames = new LinkedHashSet();
            clonedOptions.subjectAltNames.addAll(this.subjectAltNames);
            clonedOptions.x500DNHandler = this.x500DNHandler.clone();
            return clonedOptions;
        }
    }
}

