/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import org.opensaml.ws.security.SecurityPolicyFactory;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSecurityPolicyFactory<RequestType extends ServletRequest>
implements SecurityPolicyFactory<RequestType> {
    private List<SecurityPolicyRuleFactory<RequestType>> policyRuleFactories = new ArrayList<SecurityPolicyRuleFactory<RequestType>>();

    protected BaseSecurityPolicyFactory() {
    }

    @Override
    public List<SecurityPolicyRuleFactory<RequestType>> getPolicyRuleFactories() {
        return this.policyRuleFactories;
    }

    public void setPolicyRuleFactories(List<SecurityPolicyRuleFactory<RequestType>> ruleFactories) {
        if (ruleFactories == null) {
            throw new IllegalArgumentException("Security policy rule factory list may not be null");
        }
        this.policyRuleFactories = ruleFactories;
    }

    protected List<SecurityPolicyRule<RequestType>> getPolicyRuleInstances() {
        ArrayList<SecurityPolicyRule<RequestType>> ruleInstances = new ArrayList<SecurityPolicyRule<RequestType>>();
        for (SecurityPolicyRuleFactory<RequestType> ruleFactory : this.policyRuleFactories) {
            ruleInstances.add(ruleFactory.createRuleInstance());
        }
        return ruleInstances;
    }
}

