/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.List;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="MemoryDataSource", category="DataSources", toolTipText="Memory-based data", iconPath="weka/gui/knowledgeflow/icons/DefaultDataSource.gif")
public class MemoryBasedDataSource
extends BaseStep {
    private static final long serialVersionUID = -1901014330145130275L;
    protected Instances m_instances;

    public void setInstances(Instances instances) {
        this.m_instances = instances;
    }

    public Instances getInstances() {
        return this.m_instances;
    }

    @Override
    public void stepInit() throws WekaException {
        if (this.m_instances == null) {
            throw new WekaException("Has not been initialized with a set of instances");
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return Arrays.asList("dataSet");
    }

    @Override
    public void start() throws WekaException {
        this.getStepManager().processing();
        Data output = new Data("dataSet", this.m_instances);
        this.getStepManager().outputData(output);
        this.getStepManager().finished();
    }
}

