/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import org.hyperledger.acy_py.generated.model.IssuerRevRegRecord;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.discover_features.DiscoverFeatureEvent;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueIndyCredentialEvent;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueLDCredentialEvent;
import org.hyperledger.aries.api.message.BasicMessage;
import org.hyperledger.aries.api.message.ProblemReport;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.revocation.RevocationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEventV2;
import org.hyperledger.aries.api.settings.Settings;
import org.hyperledger.aries.api.trustping.PingEvent;
import org.hyperledger.aries.webhook.EventParser;
import org.hyperledger.aries.webhook.EventType;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TenantAwareEventHandler
implements IEventHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAwareEventHandler.class);
    private static final String LOG_MSG_MULTI = "walletId: {}, topic: {}, payload: {}";
    private final EventParser parser = new EventParser();

    @Override
    public void handleEvent(String topic, String payload) {
        this.handleEvent(null, topic, payload);
    }

    @Override
    public void handleEvent(String walletId, String topic, String payload) {
        this.handleRaw(walletId, topic, payload);
        EventType.fromTopic(topic).ifPresent(t -> {
            try {
                switch (t) {
                    case CONNECTIONS: {
                        this.handleConnection(walletId, this.parser.parseValueSave(payload, ConnectionRecord.class).orElseThrow());
                        break;
                    }
                    case PRESENT_PROOF: {
                        this.handleProof(walletId, this.parser.parsePresentProof(payload).orElseThrow());
                        break;
                    }
                    case PRESENT_PROOF_V2: {
                        this.handleProofV2(walletId, this.parser.parseValueSave(payload, V20PresExRecord.class).orElseThrow());
                        break;
                    }
                    case ISSUE_CREDENTIAL: {
                        this.handleCredential(walletId, this.parser.parseValueSave(payload, V1CredentialExchange.class).orElseThrow());
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2: {
                        this.handleCredentialV2(walletId, this.parser.parseValueSave(payload, V20CredExRecord.class).orElseThrow());
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_INDY: {
                        this.handleIssueCredentialV2Indy(walletId, this.parser.parseValueSave(payload, V2IssueIndyCredentialEvent.class).orElseThrow());
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_LD_PROOF: {
                        this.handleIssueCredentialV2LD(walletId, this.parser.parseValueSave(payload, V2IssueLDCredentialEvent.class).orElseThrow());
                        break;
                    }
                    case BASIC_MESSAGES: {
                        this.handleBasicMessage(walletId, this.parser.parseValueSave(payload, BasicMessage.class).orElseThrow());
                        break;
                    }
                    case PING: {
                        this.handlePing(walletId, this.parser.parseValueSave(payload, PingEvent.class).orElseThrow());
                        break;
                    }
                    case ISSUER_CRED_REV: {
                        this.handleRevocation(walletId, this.parser.parseValueSave(payload, RevocationEvent.class).orElseThrow());
                        break;
                    }
                    case ENDORSE_TRANSACTION: {
                        this.handleEndorseTransaction(walletId, this.parser.parseValueSave(payload, EndorseTransactionRecord.class).orElseThrow());
                        break;
                    }
                    case PROBLEM_REPORT: {
                        this.handleProblemReport(walletId, this.parser.parseValueSave(payload, ProblemReport.class).orElseThrow());
                        break;
                    }
                    case DISCOVER_FEATURE: {
                        this.handleDiscoverFeature(walletId, this.parser.parseValueSave(payload, DiscoverFeatureEvent.class).orElseThrow());
                        break;
                    }
                    case REVOCATION_NOTIFICATION: {
                        this.handleRevocationNotification(walletId, this.parser.parseValueSave(payload, RevocationNotificationEvent.class).orElseThrow());
                        break;
                    }
                    case REVOCATION_NOTIFICATION_V2: {
                        this.handleRevocationNotificationV2(walletId, this.parser.parseValueSave(payload, RevocationNotificationEventV2.class).orElseThrow());
                        break;
                    }
                    case REVOCATION_REGISTRY: {
                        this.handleRevocationRegistry(walletId, this.parser.parseValueSave(payload, IssuerRevRegRecord.class).orElseThrow());
                        break;
                    }
                    case SETTINGS: {
                        this.handleSettings(walletId, this.parser.parseValueSave(payload, Settings.class).orElseThrow());
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.error("Error in webhook event handler:", e);
            }
        });
    }

    public void handleConnection(String walletId, ConnectionRecord connection) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.CONNECTIONS, connection});
    }

    public void handleProof(String walletId, PresentationExchangeRecord proof) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.PRESENT_PROOF, proof});
    }

    public void handleProofV2(String walletId, V20PresExRecord proof) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.PRESENT_PROOF_V2, proof});
    }

    public void handleCredential(String walletId, V1CredentialExchange credential) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ISSUE_CREDENTIAL, credential});
    }

    public void handleCredentialV2(String walletId, V20CredExRecord v20Credential) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ISSUE_CREDENTIAL_V2, v20Credential});
    }

    public void handleDiscoverFeature(String walletId, DiscoverFeatureEvent discoverFeature) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.DISCOVER_FEATURE, discoverFeature});
    }

    public void handleIssueCredentialV2Indy(String walletId, V2IssueIndyCredentialEvent credentialInfo) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ISSUE_CREDENTIAL_V2_INDY, credentialInfo});
    }

    public void handleIssueCredentialV2LD(String walletId, V2IssueLDCredentialEvent credentialInfo) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ISSUE_CREDENTIAL_V2_LD_PROOF, credentialInfo});
    }

    public void handleBasicMessage(String walletId, BasicMessage message) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.BASIC_MESSAGES, message});
    }

    public void handlePing(String walletId, PingEvent ping) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.PING, ping});
    }

    public void handleRevocation(String walletId, RevocationEvent revocation) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ISSUER_CRED_REV, revocation});
    }

    public void handleRevocationNotification(String walletId, RevocationNotificationEvent revocationNotification) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.REVOCATION_NOTIFICATION, revocationNotification});
    }

    public void handleRevocationNotificationV2(String walletId, RevocationNotificationEventV2 revocationNotificationV2) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.REVOCATION_NOTIFICATION_V2, revocationNotificationV2});
    }

    public void handleRevocationRegistry(String walletId, IssuerRevRegRecord revocationRegistry) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.REVOCATION_REGISTRY, revocationRegistry});
    }

    public void handleEndorseTransaction(String walletId, EndorseTransactionRecord transaction) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.ENDORSE_TRANSACTION, transaction});
    }

    public void handleProblemReport(String walletId, ProblemReport report) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.PROBLEM_REPORT, report});
    }

    public void handleSettings(String walletId, Settings settings) throws Exception {
        log.debug(LOG_MSG_MULTI, new Object[]{walletId, EventType.SETTINGS, settings});
    }

    public void handleRaw(String walletId, String eventType, String json) {
        if (log.isTraceEnabled()) {
            log.trace(LOG_MSG_MULTI, new Object[]{walletId, eventType, this.parser.prettyJson(json)});
        }
    }

    public static final class DefaultTenantAwareEventHandler
    extends TenantAwareEventHandler {
    }
}

