/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.discover_features.DiscoverFeatureEvent;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueIndyCredentialEvent;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueLDCredentialEvent;
import org.hyperledger.aries.api.message.BasicMessage;
import org.hyperledger.aries.api.message.ProblemReport;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.revocation.RevocationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEventV2;
import org.hyperledger.aries.api.trustping.PingEvent;
import org.hyperledger.aries.webhook.EventParser;
import org.hyperledger.aries.webhook.EventType;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class ReactiveEventHandler
implements IEventHandler {
    private static final Logger log = LoggerFactory.getLogger(ReactiveEventHandler.class);
    private static final int BUFFER_SIZE = 100;
    private final EventParser parser = new EventParser();
    private final Sinks.Many<ConnectionRecord> connectionSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<PresentationExchangeRecord> presExSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<V20PresExRecord> presExV2Sink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<V1CredentialExchange> credExSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<V20CredExRecord> credExV2Sink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<V2IssueIndyCredentialEvent> credIssueIndySink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<V2IssueLDCredentialEvent> credIssueLDSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<BasicMessage> basicMassageSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<PingEvent> pingEventSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<RevocationEvent> issuerRevocationEventSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<EndorseTransactionRecord> endorseTrxSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<ProblemReport> problemReportSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<DiscoverFeatureEvent> discoverFeatureSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<RevocationNotificationEvent> revocationNotificationSink = Sinks.many().multicast().onBackpressureBuffer(100, false);
    private final Sinks.Many<RevocationNotificationEventV2> revocationNotificationSinkV2 = Sinks.many().multicast().onBackpressureBuffer(100, false);

    @Override
    public void handleEvent(String topic, String payload) {
        this.handleEvent(null, topic, payload);
    }

    @Override
    public void handleEvent(String walletId, String topic, String payload) {
        EventType.fromTopic(topic).ifPresent(t -> {
            try {
                switch (t) {
                    case CONNECTIONS: {
                        this.parser.parseValueSave(payload, ConnectionRecord.class, arg_0 -> this.connectionSink.tryEmitNext(arg_0));
                        break;
                    }
                    case PRESENT_PROOF: {
                        this.parser.parsePresentProof(payload).ifPresent(arg_0 -> this.presExSink.tryEmitNext(arg_0));
                        break;
                    }
                    case PRESENT_PROOF_V2: {
                        this.parser.parseValueSave(payload, V20PresExRecord.class, arg_0 -> this.presExV2Sink.tryEmitNext(arg_0));
                        break;
                    }
                    case ISSUE_CREDENTIAL: {
                        this.parser.parseValueSave(payload, V1CredentialExchange.class, arg_0 -> this.credExSink.tryEmitNext(arg_0));
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2: {
                        this.parser.parseValueSave(payload, V20CredExRecord.class, arg_0 -> this.credExV2Sink.tryEmitNext(arg_0));
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_INDY: {
                        this.parser.parseValueSave(payload, V2IssueIndyCredentialEvent.class, arg_0 -> this.credIssueIndySink.tryEmitNext(arg_0));
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_LD_PROOF: {
                        this.parser.parseValueSave(payload, V2IssueLDCredentialEvent.class, arg_0 -> this.credIssueLDSink.tryEmitNext(arg_0));
                        break;
                    }
                    case BASIC_MESSAGES: {
                        this.parser.parseValueSave(payload, BasicMessage.class, arg_0 -> this.basicMassageSink.tryEmitNext(arg_0));
                        break;
                    }
                    case PING: {
                        this.parser.parseValueSave(payload, PingEvent.class, arg_0 -> this.pingEventSink.tryEmitNext(arg_0));
                        break;
                    }
                    case ISSUER_CRED_REV: {
                        this.parser.parseValueSave(payload, RevocationEvent.class, arg_0 -> this.issuerRevocationEventSink.tryEmitNext(arg_0));
                        break;
                    }
                    case ENDORSE_TRANSACTION: {
                        this.parser.parseValueSave(payload, EndorseTransactionRecord.class, arg_0 -> this.endorseTrxSink.tryEmitNext(arg_0));
                        break;
                    }
                    case PROBLEM_REPORT: {
                        this.parser.parseValueSave(payload, ProblemReport.class, arg_0 -> this.problemReportSink.tryEmitNext(arg_0));
                        break;
                    }
                    case DISCOVER_FEATURE: {
                        this.parser.parseValueSave(payload, DiscoverFeatureEvent.class, arg_0 -> this.discoverFeatureSink.tryEmitNext(arg_0));
                        break;
                    }
                    case REVOCATION_NOTIFICATION: {
                        this.parser.parseValueSave(payload, RevocationNotificationEvent.class, arg_0 -> this.revocationNotificationSink.tryEmitNext(arg_0));
                        break;
                    }
                    case REVOCATION_NOTIFICATION_V2: {
                        this.parser.parseValueSave(payload, RevocationNotificationEventV2.class, arg_0 -> this.revocationNotificationSinkV2.tryEmitNext(arg_0));
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.error("Error in reactive event handler:", e);
            }
        });
    }

    public Flux<ConnectionRecord> connection() {
        return this.connectionSink.asFlux();
    }

    public Flux<PresentationExchangeRecord> presentationEx() {
        return this.presExSink.asFlux();
    }

    public Flux<V20PresExRecord> presentationExV2() {
        return this.presExV2Sink.asFlux();
    }

    public Flux<V1CredentialExchange> credentialEx() {
        return this.credExSink.asFlux();
    }

    public Flux<V20CredExRecord> credentialExV2() {
        return this.credExV2Sink.asFlux();
    }

    public Flux<V2IssueIndyCredentialEvent> credentialIssueIndy() {
        return this.credIssueIndySink.asFlux();
    }

    public Flux<V2IssueLDCredentialEvent> credentialIssueLD() {
        return this.credIssueLDSink.asFlux();
    }

    public Flux<BasicMessage> basicMessage() {
        return this.basicMassageSink.asFlux();
    }

    public Flux<PingEvent> ping() {
        return this.pingEventSink.asFlux();
    }

    public Flux<RevocationEvent> issuerRevocation() {
        return this.issuerRevocationEventSink.asFlux();
    }

    public Flux<EndorseTransactionRecord> endorseTrx() {
        return this.endorseTrxSink.asFlux();
    }

    public Flux<ProblemReport> problemReport() {
        return this.problemReportSink.asFlux();
    }

    public Flux<DiscoverFeatureEvent> discoverFeature() {
        return this.discoverFeatureSink.asFlux();
    }

    public Flux<RevocationNotificationEvent> revocationNotification() {
        return this.revocationNotificationSink.asFlux();
    }

    public Flux<RevocationNotificationEventV2> revocationNotificationV2() {
        return this.revocationNotificationSinkV2.asFlux();
    }
}

