/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum EventType {
    BASIC_MESSAGES("basicmessages"),
    CONNECTIONS("connections"),
    DISCOVER_FEATURE("discover_feature"),
    ENDORSE_TRANSACTION("endorse_transaction"),
    ISSUER_CRED_REV("issuer_cred_rev"),
    ISSUE_CREDENTIAL("issue_credential"),
    ISSUE_CREDENTIAL_V2("issue_credential_v2_0"),
    ISSUE_CREDENTIAL_V2_INDY("issue_credential_v2_0_indy"),
    ISSUE_CREDENTIAL_V2_LD_PROOF("issue_credential_v2_0_ld_proof"),
    PING("ping"),
    PRESENT_PROOF("present_proof"),
    PRESENT_PROOF_V2("present_proof_v2_0"),
    PROBLEM_REPORT("problem_report"),
    REVOCATION_NOTIFICATION("revocation-notification"),
    REVOCATION_NOTIFICATION_V2("revocation-notification-v2"),
    REVOCATION_REGISTRY("revocation_registry"),
    SETTINGS("settings");

    private final String topic;

    public boolean topicEquals(String other) {
        return StringUtils.equals((CharSequence)this.topic, (CharSequence)other);
    }

    public String toString() {
        return this.topic;
    }

    public static Optional<EventType> fromTopic(String topic) {
        return Arrays.stream(EventType.values()).filter(e -> StringUtils.equalsIgnoreCase((CharSequence)e.getTopic(), (CharSequence)topic)).findFirst();
    }

    private EventType(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }
}

