/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.config.GsonConfig;
import org.hyperledger.aries.pojo.PojoProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventParser {
    private static final Logger log = LoggerFactory.getLogger(EventParser.class);
    private static final Type IDENTIFIER_TYPE = new TypeToken<Collection<PresentationExchangeRecord.Identifier>>(){}.getType();
    private static final Gson gson = GsonConfig.defaultConfig();
    private final Gson pretty = GsonConfig.prettyPrinter();

    public String prettyJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        JsonElement el = JsonParser.parseString((String)json);
        return this.pretty.toJson(el);
    }

    public <T> Optional<T> parseValueSave(@NonNull String json, @NonNull Class<T> valueType) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        Optional<Object> t = Optional.empty();
        try {
            t = Optional.ofNullable(gson.fromJson(json, valueType));
        }
        catch (JsonSyntaxException e) {
            log.error("Could not format json body", (Throwable)e);
        }
        return t;
    }

    public static <T> Optional<T> parseElement(JsonElement json, @NonNull Class<T> valueType) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        return Optional.ofNullable(gson.fromJson(json, valueType));
    }

    public static <T> Optional<T> parseElement(JsonElement json, @NonNull Type valueType) {
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        return Optional.ofNullable(gson.fromJson(json, valueType));
    }

    public <T> void parseValueSave(@NonNull String json, @NonNull Class<T> valueType, Consumer<T> consumer) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        this.parseValueSave(json, valueType).ifPresent(consumer);
    }

    public Optional<PresentationExchangeRecord> parsePresentProof(String json) {
        Optional<PresentationExchangeRecord> presentation = this.parseValueSave(json, PresentationExchangeRecord.class);
        if (presentation.isPresent()) {
            List<PresentationExchangeRecord.Identifier> identifiers = EventParser.resolveIdentifiers(presentation.get().getPresentation());
            presentation.get().setIdentifiers(identifiers);
        }
        return presentation;
    }

    public static List<PresentationExchangeRecord.Identifier> resolveIdentifiers(JsonObject jo) {
        if (jo != null) {
            JsonElement je = jo.get("identifiers");
            return (List)gson.fromJson(je, IDENTIFIER_TYPE);
        }
        return List.of();
    }

    public static <T> T from(@NonNull String json, @NonNull Class<T> type) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Object result = PojoProcessor.getInstance(type);
        Set<Map.Entry<String, JsonElement>> revealedAttrs = EventParser.getRevealedAttributes(json);
        Set<Map.Entry<String, JsonElement>> revealedAttrGroups = EventParser.aggregateRevealedAttrGroups(json, PojoProcessor.getAttributeGroupName(type));
        Set<Field> fields = PojoProcessor.fields(type);
        AccessController.doPrivileged(() -> {
            for (Field field : fields) {
                String fieldName = PojoProcessor.fieldName(field);
                String fieldValue = EventParser.getValueFor(fieldName, revealedAttrs.isEmpty() ? revealedAttrGroups : revealedAttrs);
                try {
                    field.setAccessible(true);
                    field.set(result, fieldValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.error("Could not set value of field: {} to: {}", new Object[]{fieldName, fieldValue, e});
                }
            }
            return null;
        });
        return result;
    }

    public static Map<String, Object> from(@NonNull String json, @NonNull Set<String> names) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<Map.Entry<String, JsonElement>> revealedAttrs = EventParser.getRevealedAttributes(json);
        Set<Map.Entry<String, JsonElement>> revealedAttrGroups = EventParser.aggregateRevealedAttrGroups(json, null);
        names.forEach(name -> {
            String value = EventParser.getValueFor(name, revealedAttrs.isEmpty() ? revealedAttrGroups : revealedAttrs);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                result.put((String)name, value);
            }
        });
        return result;
    }

    private static String getValueFor(String name, Set<Map.Entry<String, JsonElement>> revealedAttrs) {
        String result = null;
        for (Map.Entry<String, JsonElement> e : revealedAttrs) {
            String k = e.getKey();
            if (!k.equals(name) && (!k.contains(name + "_uuid") || e.getValue() == null)) continue;
            JsonElement raw = e.getValue().getAsJsonObject().get("raw");
            if (raw == null) break;
            result = raw.getAsString();
            break;
        }
        return result;
    }

    public static Set<Map.Entry<String, JsonElement>> getRevealedAttributes(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        JsonElement revealedAttrs = JsonParser.parseString((String)json).getAsJsonObject().get("requested_proof").getAsJsonObject().get("revealed_attrs");
        if (revealedAttrs == null) {
            return Set.of();
        }
        return revealedAttrs.getAsJsonObject().entrySet();
    }

    private static JsonElement getRevealedAttrGroups(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return JsonParser.parseString((String)json).getAsJsonObject().get("requested_proof").getAsJsonObject().get("revealed_attr_groups");
    }

    private static PresentationExchangeRecord.Identifier getIdentifierAtIndex(@NonNull String json, int index) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        JsonObject identifier = JsonParser.parseString((String)json).getAsJsonObject().get("identifiers").getAsJsonArray().get(index).getAsJsonObject();
        return (PresentationExchangeRecord.Identifier)gson.fromJson((JsonElement)identifier, PresentationExchangeRecord.Identifier.class);
    }

    private static Set<Map.Entry<String, JsonElement>> aggregateRevealedAttrGroups(@NonNull String json, String groupName) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        LinkedHashSet<Map.Entry<String, JsonElement>> result = new LinkedHashSet<Map.Entry<String, JsonElement>>();
        JsonElement attr = EventParser.getRevealedAttrGroups(json);
        if (attr == null) {
            return result;
        }
        JsonObject attrGroups = attr.getAsJsonObject();
        Set attrGroupNames = attrGroups.keySet();
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            EventParser.extract(result, attrGroups, groupName);
        } else {
            attrGroupNames.forEach(c -> EventParser.extract(result, attrGroups, c));
        }
        return result;
    }

    private static void extract(Set<Map.Entry<String, JsonElement>> result, JsonObject attrGroup, String groupName) {
        Set attrs = attrGroup.get(groupName).getAsJsonObject().get("values").getAsJsonObject().entrySet();
        attrs.forEach(a -> {
            if (!result.contains(a)) {
                result.add((Map.Entry<String, JsonElement>)a);
            }
        });
    }

    public static Map<String, PresentationExchangeRecord.RevealedAttributeGroup> getValuesByAttributeGroup(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        HashMap<String, PresentationExchangeRecord.RevealedAttributeGroup> result = new HashMap<String, PresentationExchangeRecord.RevealedAttributeGroup>();
        JsonElement groupsJson = EventParser.getRevealedAttrGroups(json);
        if (groupsJson == null) {
            return result;
        }
        JsonObject attrGroups = groupsJson.getAsJsonObject();
        Set attrGroupNames = attrGroups.keySet();
        attrGroupNames.forEach(name -> {
            PresentationExchangeRecord.RevealedAttributeGroup.RevealedAttributeGroupBuilder groupBuilder = PresentationExchangeRecord.RevealedAttributeGroup.builder();
            Set attrs = attrGroups.get(name).getAsJsonObject().get("values").getAsJsonObject().entrySet();
            attrs.forEach(e -> groupBuilder.revealedAttribute((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonObject().get("raw").getAsString()));
            int subProofIndex = attrGroups.get(name).getAsJsonObject().get("sub_proof_index").getAsInt();
            groupBuilder.identifier(EventParser.getIdentifierAtIndex(json, subProofIndex));
            result.put((String)name, groupBuilder.build());
        });
        return result;
    }

    public static Map<String, Object> getValuesByRevealedAttributes(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return EventParser.getRevealedAttributes(json).stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((JsonElement)v.getValue()).getAsJsonObject().get("raw").getAsString()));
    }

    public static Map<String, PresentationExchangeRecord.RevealedAttribute> getValuesByRevealedAttributesFull(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return EventParser.getRevealedAttributes(json).stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (PresentationExchangeRecord.RevealedAttribute)gson.fromJson((JsonElement)v.getValue(), PresentationExchangeRecord.RevealedAttribute.class)));
    }
}

