/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import org.hyperledger.acy_py.generated.model.IssuerRevRegRecord;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.discover_features.DiscoverFeatureEvent;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueIndyCredentialEvent;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueLDCredentialEvent;
import org.hyperledger.aries.api.message.BasicMessage;
import org.hyperledger.aries.api.message.ProblemReport;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.revocation.RevocationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEventV2;
import org.hyperledger.aries.api.settings.Settings;
import org.hyperledger.aries.api.trustping.PingEvent;
import org.hyperledger.aries.webhook.EventParser;
import org.hyperledger.aries.webhook.EventType;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventHandler
implements IEventHandler {
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private static final String LOG_MSG_SINGLE = "topic: {}, payload: {}";
    private final EventParser parser = new EventParser();

    @Override
    public void handleEvent(String topic, String payload) {
        this.handleEvent(null, topic, payload);
    }

    @Override
    public void handleEvent(String walletId, String topic, String payload) {
        this.handleRaw(topic, payload);
        EventType.fromTopic(topic).ifPresent(t -> {
            try {
                switch (t) {
                    case CONNECTIONS: {
                        this.parser.parseValueSave(payload, ConnectionRecord.class, this::handleConnection);
                        break;
                    }
                    case PRESENT_PROOF: {
                        this.parser.parsePresentProof(payload).ifPresent(this::handleProof);
                        break;
                    }
                    case PRESENT_PROOF_V2: {
                        this.parser.parseValueSave(payload, V20PresExRecord.class, this::handleProofV2);
                        break;
                    }
                    case ISSUE_CREDENTIAL: {
                        this.parser.parseValueSave(payload, V1CredentialExchange.class, this::handleCredential);
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2: {
                        this.parser.parseValueSave(payload, V20CredExRecord.class, this::handleCredentialV2);
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_INDY: {
                        this.parser.parseValueSave(payload, V2IssueIndyCredentialEvent.class, this::handleIssueCredentialV2Indy);
                        break;
                    }
                    case ISSUE_CREDENTIAL_V2_LD_PROOF: {
                        this.parser.parseValueSave(payload, V2IssueLDCredentialEvent.class, this::handleIssueCredentialV2LD);
                        break;
                    }
                    case BASIC_MESSAGES: {
                        this.parser.parseValueSave(payload, BasicMessage.class, this::handleBasicMessage);
                        break;
                    }
                    case PING: {
                        this.parser.parseValueSave(payload, PingEvent.class, this::handlePing);
                        break;
                    }
                    case ISSUER_CRED_REV: {
                        this.parser.parseValueSave(payload, RevocationEvent.class, this::handleRevocation);
                        break;
                    }
                    case ENDORSE_TRANSACTION: {
                        this.parser.parseValueSave(payload, EndorseTransactionRecord.class, this::handleEndorseTransaction);
                        break;
                    }
                    case PROBLEM_REPORT: {
                        this.parser.parseValueSave(payload, ProblemReport.class, this::handleProblemReport);
                        break;
                    }
                    case DISCOVER_FEATURE: {
                        this.parser.parseValueSave(payload, DiscoverFeatureEvent.class, this::handleDiscoverFeature);
                        break;
                    }
                    case REVOCATION_NOTIFICATION: {
                        this.parser.parseValueSave(payload, RevocationNotificationEvent.class, this::handleRevocationNotification);
                        break;
                    }
                    case REVOCATION_NOTIFICATION_V2: {
                        this.parser.parseValueSave(payload, RevocationNotificationEventV2.class, this::handleRevocationNotificationV2);
                        break;
                    }
                    case REVOCATION_REGISTRY: {
                        this.parser.parseValueSave(payload, IssuerRevRegRecord.class, this::handleRevocationRegistry);
                        break;
                    }
                    case SETTINGS: {
                        this.parser.parseValueSave(payload, Settings.class, this::handleSettings);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.error("Error in webhook event handler:", e);
            }
        });
    }

    public void handleConnection(ConnectionRecord connection) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.CONNECTIONS, (Object)connection);
    }

    public void handleProof(PresentationExchangeRecord proof) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.PRESENT_PROOF, (Object)proof);
    }

    public void handleProofV2(V20PresExRecord proof) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.PRESENT_PROOF_V2, (Object)proof);
    }

    public void handleCredential(V1CredentialExchange credential) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ISSUE_CREDENTIAL, (Object)credential);
    }

    public void handleCredentialV2(V20CredExRecord v20Credential) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ISSUE_CREDENTIAL_V2, (Object)v20Credential);
    }

    public void handleDiscoverFeature(DiscoverFeatureEvent discoverFeature) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.DISCOVER_FEATURE, (Object)discoverFeature);
    }

    public void handleIssueCredentialV2Indy(V2IssueIndyCredentialEvent credentialInfo) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ISSUE_CREDENTIAL_V2_INDY, (Object)credentialInfo);
    }

    public void handleIssueCredentialV2LD(V2IssueLDCredentialEvent credentialInfo) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ISSUE_CREDENTIAL_V2_LD_PROOF, (Object)credentialInfo);
    }

    public void handleBasicMessage(BasicMessage message) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.BASIC_MESSAGES, (Object)message);
    }

    public void handlePing(PingEvent ping) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.PING, (Object)ping);
    }

    public void handleRevocation(RevocationEvent revocation) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ISSUER_CRED_REV, (Object)revocation);
    }

    public void handleRevocationNotification(RevocationNotificationEvent revocationNotification) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.REVOCATION_NOTIFICATION, (Object)revocationNotification);
    }

    public void handleRevocationNotificationV2(RevocationNotificationEventV2 revocationNotificationV2) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.REVOCATION_NOTIFICATION_V2, (Object)revocationNotificationV2);
    }

    public void handleRevocationRegistry(IssuerRevRegRecord revocationRegistry) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.REVOCATION_REGISTRY, (Object)revocationRegistry);
    }

    public void handleEndorseTransaction(EndorseTransactionRecord transaction) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.ENDORSE_TRANSACTION, (Object)transaction);
    }

    public void handleProblemReport(ProblemReport report) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.PROBLEM_REPORT, (Object)report);
    }

    public void handleSettings(Settings settings) {
        log.debug(LOG_MSG_SINGLE, (Object)EventType.SETTINGS, (Object)settings);
    }

    public void handleRaw(String eventType, String json) {
        if (log.isTraceEnabled()) {
            log.trace(LOG_MSG_SINGLE, (Object)eventType, (Object)this.parser.prettyJson(json));
        }
    }

    public static final class DefaultEventHandler
    extends EventHandler {
    }
}

