/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.webhook;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.config.GsonConfig;
import org.hyperledger.aries.webhook.EventType;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AriesWebSocketListener
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(AriesWebSocketListener.class);
    private final Gson gson = GsonConfig.defaultConfig();
    private final String label;
    private final List<IEventHandler> handler;
    private final List<String> walletIdFilter;
    private final boolean withLabel;

    public AriesWebSocketListener(String label, @NonNull List<IEventHandler> handler, List<String> walletIdFilter) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.label = label;
        this.handler = handler;
        this.withLabel = StringUtils.isNotEmpty((CharSequence)label);
        this.walletIdFilter = walletIdFilter;
    }

    private String appendLabel(String msg) {
        return this.withLabel ? this.label + " " + msg : msg;
    }

    public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
        if (webSocket == null) {
            throw new NullPointerException("webSocket is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        log.debug(this.appendLabel("Open: {}"), (Object)response);
    }

    public void onMessage(@NonNull WebSocket webSocket, @NonNull String message) {
        if (webSocket == null) {
            throw new NullPointerException("webSocket is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        log.trace(this.appendLabel("Event: {}"), (Object)message);
        try {
            String payload;
            JsonObject json = (JsonObject)this.gson.fromJson(message, JsonObject.class);
            String walletId = json.has("wallet_id") ? json.get("wallet_id").getAsString() : null;
            String topic = json.get("topic").getAsString();
            String string = payload = json.has("payload") ? json.get("payload").toString() : "{}";
            if (this.notWsPing(topic, payload) && this.isForWalletId(walletId)) {
                this.handler.forEach(h -> h.handleEvent(walletId, topic, payload));
            }
        }
        catch (JsonSyntaxException ex) {
            log.error("JsonSyntaxException", (Throwable)ex);
        }
    }

    public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable th, Response response) {
        String message;
        if (webSocket == null) {
            throw new NullPointerException("webSocket is marked non-null but is null");
        }
        if (th == null) {
            throw new NullPointerException("th is marked non-null but is null");
        }
        String string = message = response != null ? response.message() : th.getMessage();
        if (!"Socket closed".equals(message)) {
            log.error(String.format("%s Failure: %s", this.label, message), th);
        }
    }

    public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
        if (webSocket == null) {
            throw new NullPointerException("webSocket is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        log.trace(this.appendLabel("Closing: {} {}"), (Object)code, (Object)reason);
    }

    public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
        if (webSocket == null) {
            throw new NullPointerException("webSocket is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        log.debug(this.appendLabel("Closed: {} {}"), (Object)code, (Object)reason);
    }

    private boolean notWsPing(String topic, String payload) {
        return !EventType.PING.topicEquals(topic) || !"{}".equals(payload);
    }

    private boolean isForWalletId(String walletId) {
        return walletId == null || this.walletIdFilter == null || ArrayUtils.contains((Object[])this.walletIdFilter.toArray(), (Object)walletId);
    }

    public static AriesWebSocketListenerBuilder builder() {
        return new AriesWebSocketListenerBuilder();
    }

    public static class AriesWebSocketListenerBuilder {
        private String label;
        private ArrayList<IEventHandler> handler;
        private ArrayList<String> walletIdFilter;

        AriesWebSocketListenerBuilder() {
        }

        public AriesWebSocketListenerBuilder label(String label) {
            this.label = label;
            return this;
        }

        public AriesWebSocketListenerBuilder handler(IEventHandler handler) {
            if (this.handler == null) {
                this.handler = new ArrayList();
            }
            this.handler.add(handler);
            return this;
        }

        public AriesWebSocketListenerBuilder handler(Collection<? extends IEventHandler> handler) {
            if (handler == null) {
                throw new NullPointerException("handler cannot be null");
            }
            if (this.handler == null) {
                this.handler = new ArrayList();
            }
            this.handler.addAll(handler);
            return this;
        }

        public AriesWebSocketListenerBuilder clearHandler() {
            if (this.handler != null) {
                this.handler.clear();
            }
            return this;
        }

        public AriesWebSocketListenerBuilder walletId(String walletId) {
            if (this.walletIdFilter == null) {
                this.walletIdFilter = new ArrayList();
            }
            this.walletIdFilter.add(walletId);
            return this;
        }

        public AriesWebSocketListenerBuilder walletIdFilter(Collection<? extends String> walletIdFilter) {
            if (walletIdFilter == null) {
                throw new NullPointerException("walletIdFilter cannot be null");
            }
            if (this.walletIdFilter == null) {
                this.walletIdFilter = new ArrayList();
            }
            this.walletIdFilter.addAll(walletIdFilter);
            return this;
        }

        public AriesWebSocketListenerBuilder clearWalletIdFilter() {
            if (this.walletIdFilter != null) {
                this.walletIdFilter.clear();
            }
            return this;
        }

        public AriesWebSocketListener build() {
            List<String> walletIdFilter;
            List<IEventHandler> handler;
            switch (this.handler == null ? 0 : this.handler.size()) {
                case 0: {
                    handler = Collections.emptyList();
                    break;
                }
                case 1: {
                    handler = Collections.singletonList(this.handler.get(0));
                    break;
                }
                default: {
                    handler = Collections.unmodifiableList(new ArrayList<IEventHandler>(this.handler));
                }
            }
            switch (this.walletIdFilter == null ? 0 : this.walletIdFilter.size()) {
                case 0: {
                    walletIdFilter = Collections.emptyList();
                    break;
                }
                case 1: {
                    walletIdFilter = Collections.singletonList(this.walletIdFilter.get(0));
                    break;
                }
                default: {
                    walletIdFilter = Collections.unmodifiableList(new ArrayList<String>(this.walletIdFilter));
                }
            }
            return new AriesWebSocketListener(this.label, handler, walletIdFilter);
        }

        public String toString() {
            return "AriesWebSocketListener.AriesWebSocketListenerBuilder(label=" + this.label + ", handler=" + this.handler + ", walletIdFilter=" + this.walletIdFilter + ")";
        }
    }
}

