/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.hyperledger.aries.api.exception.ParsingException;
import org.hyperledger.aries.pojo.AttributeGroupName;
import org.hyperledger.aries.pojo.AttributeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoProcessor {
    private static final Logger log = LoggerFactory.getLogger(PojoProcessor.class);

    @Nonnull
    public static <T> Set<String> fieldNames(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return PojoProcessor.fields(type).stream().map(PojoProcessor::fieldName).collect(Collectors.toSet());
    }

    @Nonnull
    public static <T> Set<Field> fields(@NonNull Class<T> type) {
        Field[] fields;
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        for (Field field : fields = type.getDeclaredFields()) {
            AttributeName an = field.getAnnotation(AttributeName.class);
            if (an != null && an.excluded() || !Modifier.isPrivate(field.getModifiers())) continue;
            result.add(field);
        }
        return result;
    }

    @Nonnull
    public static String fieldName(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        AttributeName an = field.getAnnotation(AttributeName.class);
        String fieldName = an != null ? an.value() : field.getName();
        return fieldName;
    }

    public static String getAttributeGroupName(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String group = null;
        if (type.isAnnotationPresent(AttributeGroupName.class)) {
            group = type.getDeclaredAnnotation(AttributeGroupName.class).value();
        }
        return group;
    }

    @Nonnull
    public static <T> T getInstance(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return (T)AccessController.doPrivileged(() -> {
            Object result;
            try {
                result = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                String msg = "Class: " + type.getName() + " is missing a public default constructor.";
                log.error(msg, (Throwable)e);
                throw new ParsingException(msg);
            }
            return result;
        });
    }
}

