/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.trustping;

import org.hyperledger.aries.api.trustping.PingEventState;

public final class PingEvent {
    private String comment;
    private String connectionId;
    private String threadId;
    private PingEventState state;
    private Boolean responded;

    public static PingEvent of(String threadId, PingEventState state) {
        return PingEvent.builder().threadId(threadId).state(state).build();
    }

    public static PingEvent of(String threadId) {
        return PingEvent.builder().threadId(threadId).build();
    }

    public boolean stateIsResponseReceived() {
        return PingEventState.RESPONSE_RECEIVED.equals((Object)this.state);
    }

    public static PingEventBuilder builder() {
        return new PingEventBuilder();
    }

    public String getComment() {
        return this.comment;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public PingEventState getState() {
        return this.state;
    }

    public Boolean getResponded() {
        return this.responded;
    }

    public PingEvent setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public PingEvent setConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    public PingEvent setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public PingEvent setState(PingEventState state) {
        this.state = state;
        return this;
    }

    public PingEvent setResponded(Boolean responded) {
        this.responded = responded;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PingEvent)) {
            return false;
        }
        PingEvent other = (PingEvent)o;
        Boolean this$responded = this.getResponded();
        Boolean other$responded = other.getResponded();
        if (this$responded == null ? other$responded != null : !((Object)this$responded).equals(other$responded)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$threadId = this.getThreadId();
        String other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
            return false;
        }
        PingEventState this$state = this.getState();
        PingEventState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $responded = this.getResponded();
        result = result * 59 + ($responded == null ? 43 : ((Object)$responded).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
        PingEventState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "PingEvent(comment=" + this.getComment() + ", connectionId=" + this.getConnectionId() + ", threadId=" + this.getThreadId() + ", state=" + this.getState() + ", responded=" + this.getResponded() + ")";
    }

    public PingEvent() {
    }

    public PingEvent(String comment, String connectionId, String threadId, PingEventState state, Boolean responded) {
        this.comment = comment;
        this.connectionId = connectionId;
        this.threadId = threadId;
        this.state = state;
        this.responded = responded;
    }

    public static class PingEventBuilder {
        private String comment;
        private String connectionId;
        private String threadId;
        private PingEventState state;
        private Boolean responded;

        PingEventBuilder() {
        }

        public PingEventBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public PingEventBuilder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public PingEventBuilder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public PingEventBuilder state(PingEventState state) {
            this.state = state;
            return this;
        }

        public PingEventBuilder responded(Boolean responded) {
            this.responded = responded;
            return this;
        }

        public PingEvent build() {
            return new PingEvent(this.comment, this.connectionId, this.threadId, this.state, this.responded);
        }

        public String toString() {
            return "PingEvent.PingEventBuilder(comment=" + this.comment + ", connectionId=" + this.connectionId + ", threadId=" + this.threadId + ", state=" + this.state + ", responded=" + this.responded + ")";
        }
    }
}

