/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConfig {
    private static final Logger log = LoggerFactory.getLogger(AdminConfig.class);
    private static final Gson gson = GsonConfig.defaultConfig();
    public static final Type COLLECTION_TYPE = new TypeToken<Collection<String>>(){}.getType();
    private Map<String, JsonElement> config;

    public <T> Optional<T> getAs(@NonNull String key, @NonNull Type type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        JsonElement value = this.config.get(key);
        if (value != null) {
            try {
                return Optional.ofNullable(gson.fromJson(value, type));
            }
            catch (Exception e) {
                log.error("Could not convert {} to {}", new Object[]{key, type, e});
            }
        }
        return Optional.empty();
    }

    public <T> T getUnwrapped(@NonNull String key, @NonNull Type type) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        JsonElement value = this.config.get(key);
        if (value != null) {
            try {
                return (T)gson.fromJson(value, type);
            }
            catch (Exception e) {
                log.error("Could not convert {} to {}", new Object[]{key, type, e});
            }
        }
        return null;
    }

    public Map<String, JsonElement> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, JsonElement> config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminConfig)) {
            return false;
        }
        AdminConfig other = (AdminConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, JsonElement> this$config = this.getConfig();
        Map<String, JsonElement> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, JsonElement> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    public String toString() {
        return "AdminConfig(config=" + this.getConfig() + ")";
    }
}

