/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.schema;

import java.util.List;
import javax.annotation.Nonnull;

public class SchemaSendRequest {
    @Nonnull
    private List<String> attributes;
    @Nonnull
    private String schemaName;
    @Nonnull
    private String schemaVersion;

    SchemaSendRequest(@Nonnull List<String> attributes, @Nonnull String schemaName, @Nonnull String schemaVersion) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (schemaVersion == null) {
            throw new NullPointerException("schemaVersion is marked non-null but is null");
        }
        this.attributes = attributes;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
    }

    public static SchemaSendRequestBuilder builder() {
        return new SchemaSendRequestBuilder();
    }

    @Nonnull
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nonnull
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setAttributes(@Nonnull List<String> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.attributes = attributes;
    }

    public void setSchemaName(@Nonnull String schemaName) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(@Nonnull String schemaVersion) {
        if (schemaVersion == null) {
            throw new NullPointerException("schemaVersion is marked non-null but is null");
        }
        this.schemaVersion = schemaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaSendRequest)) {
            return false;
        }
        SchemaSendRequest other = (SchemaSendRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaVersion = this.getSchemaVersion();
        String other$schemaVersion = other.getSchemaVersion();
        return !(this$schemaVersion == null ? other$schemaVersion != null : !this$schemaVersion.equals(other$schemaVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaSendRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaVersion = this.getSchemaVersion();
        result = result * 59 + ($schemaVersion == null ? 43 : $schemaVersion.hashCode());
        return result;
    }

    public String toString() {
        return "SchemaSendRequest(attributes=" + this.getAttributes() + ", schemaName=" + this.getSchemaName() + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    public static class SchemaSendRequestBuilder {
        private List<String> attributes;
        private String schemaName;
        private String schemaVersion;

        SchemaSendRequestBuilder() {
        }

        public SchemaSendRequestBuilder attributes(@Nonnull List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SchemaSendRequestBuilder schemaName(@Nonnull String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public SchemaSendRequestBuilder schemaVersion(@Nonnull String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public SchemaSendRequest build() {
            return new SchemaSendRequest(this.attributes, this.schemaName, this.schemaVersion);
        }

        public String toString() {
            return "SchemaSendRequest.SchemaSendRequestBuilder(attributes=" + this.attributes + ", schemaName=" + this.schemaName + ", schemaVersion=" + this.schemaVersion + ")";
        }
    }
}

