/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.revocation;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class RevocationNotificationBase {
    RevocationInfo expressionToRevocationInfo(@NonNull String expression, @NonNull Integer expLength) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        if (expLength == null) {
            throw new NullPointerException("expLength is marked non-null but is null");
        }
        RevocationInfo.RevocationInfoBuilder b = RevocationInfo.builder();
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            String[] parts = expression.split("::");
            if (parts.length != expLength) {
                throw new IllegalArgumentException("Not a valid revocation notification");
            }
            b.revRegId(parts[expLength - 2]);
            b.credRevId(parts[expLength - 1]);
        }
        return b.build();
    }

    public static final class RevocationInfo {
        private String revRegId;
        private String credRevId;

        RevocationInfo(String revRegId, String credRevId) {
            this.revRegId = revRegId;
            this.credRevId = credRevId;
        }

        public static RevocationInfoBuilder builder() {
            return new RevocationInfoBuilder();
        }

        public String getRevRegId() {
            return this.revRegId;
        }

        public String getCredRevId() {
            return this.credRevId;
        }

        public void setRevRegId(String revRegId) {
            this.revRegId = revRegId;
        }

        public void setCredRevId(String credRevId) {
            this.credRevId = credRevId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevocationInfo)) {
                return false;
            }
            RevocationInfo other = (RevocationInfo)o;
            String this$revRegId = this.getRevRegId();
            String other$revRegId = other.getRevRegId();
            if (this$revRegId == null ? other$revRegId != null : !this$revRegId.equals(other$revRegId)) {
                return false;
            }
            String this$credRevId = this.getCredRevId();
            String other$credRevId = other.getCredRevId();
            return !(this$credRevId == null ? other$credRevId != null : !this$credRevId.equals(other$credRevId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $revRegId = this.getRevRegId();
            result = result * 59 + ($revRegId == null ? 43 : $revRegId.hashCode());
            String $credRevId = this.getCredRevId();
            result = result * 59 + ($credRevId == null ? 43 : $credRevId.hashCode());
            return result;
        }

        public String toString() {
            return "RevocationNotificationBase.RevocationInfo(revRegId=" + this.getRevRegId() + ", credRevId=" + this.getCredRevId() + ")";
        }

        public static class RevocationInfoBuilder {
            private String revRegId;
            private String credRevId;

            RevocationInfoBuilder() {
            }

            public RevocationInfoBuilder revRegId(String revRegId) {
                this.revRegId = revRegId;
                return this;
            }

            public RevocationInfoBuilder credRevId(String credRevId) {
                this.credRevId = credRevId;
                return this;
            }

            public RevocationInfo build() {
                return new RevocationInfo(this.revRegId, this.credRevId);
            }

            public String toString() {
                return "RevocationNotificationBase.RevocationInfo.RevocationInfoBuilder(revRegId=" + this.revRegId + ", credRevId=" + this.credRevId + ")";
            }
        }
    }
}

