/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.resolver;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

@JsonPropertyOrder(value={"context", "id"})
public class DIDDocument {
    public static final String ENDPOINT_TYPE_DID_COMM = "did-communication";
    public static final String ENDPOINT_TYPE_PROFILE = "profile";
    @JsonProperty(value="@context")
    @SerializedName(value="@context")
    private List<String> context = List.of("https://www.w3.org/ns/did/v1");
    private String id;
    @SerializedName(value="alsoKnownAs")
    private List<String> alsoKnownAs;
    private String controller;
    @SerializedName(value="verificationMethod")
    private List<VerificationMethod> verificationMethod;
    private List<Object> authentication;
    @SerializedName(value="assertionMethod")
    private List<Object> assertionMethod;
    @SerializedName(value="keyAgreement")
    private List<Object> keyAgreement;
    @SerializedName(value="capabilityInvocation")
    private List<Object> capabilityInvocation;
    @SerializedName(value="capabilityDelegation")
    private List<Object> capabilityDelegation;
    private List<Service> service;

    public List<Service> getService() {
        if (this.service == null) {
            return List.of();
        }
        return this.service;
    }

    public Optional<String> findPublicProfileUrl() {
        return this.findUrlByType(ENDPOINT_TYPE_PROFILE);
    }

    public Optional<String> findAriesEndpointUrl() {
        return this.findUrlByType(ENDPOINT_TYPE_DID_COMM);
    }

    private Optional<String> findUrlByType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getService().stream().filter(s -> StringUtils.equals((CharSequence)type, (CharSequence)s.getType())).findFirst().map(Service::getServiceEndpoint);
    }

    public boolean hasProfileEndpoint() {
        return this.getService().stream().anyMatch(s -> StringUtils.equals((CharSequence)ENDPOINT_TYPE_PROFILE, (CharSequence)s.getType()));
    }

    public boolean hasAriesEndpoint() {
        return this.getService().stream().anyMatch(s -> StringUtils.equals((CharSequence)ENDPOINT_TYPE_DID_COMM, (CharSequence)s.getType()));
    }

    public static DIDDocumentBuilder builder() {
        return new DIDDocumentBuilder();
    }

    public List<String> getContext() {
        return this.context;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getAlsoKnownAs() {
        return this.alsoKnownAs;
    }

    public String getController() {
        return this.controller;
    }

    public List<VerificationMethod> getVerificationMethod() {
        return this.verificationMethod;
    }

    public List<Object> getAuthentication() {
        return this.authentication;
    }

    public List<Object> getAssertionMethod() {
        return this.assertionMethod;
    }

    public List<Object> getKeyAgreement() {
        return this.keyAgreement;
    }

    public List<Object> getCapabilityInvocation() {
        return this.capabilityInvocation;
    }

    public List<Object> getCapabilityDelegation() {
        return this.capabilityDelegation;
    }

    @JsonProperty(value="@context")
    public void setContext(List<String> context) {
        this.context = context;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlsoKnownAs(List<String> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public void setVerificationMethod(List<VerificationMethod> verificationMethod) {
        this.verificationMethod = verificationMethod;
    }

    public void setAuthentication(List<Object> authentication) {
        this.authentication = authentication;
    }

    public void setAssertionMethod(List<Object> assertionMethod) {
        this.assertionMethod = assertionMethod;
    }

    public void setKeyAgreement(List<Object> keyAgreement) {
        this.keyAgreement = keyAgreement;
    }

    public void setCapabilityInvocation(List<Object> capabilityInvocation) {
        this.capabilityInvocation = capabilityInvocation;
    }

    public void setCapabilityDelegation(List<Object> capabilityDelegation) {
        this.capabilityDelegation = capabilityDelegation;
    }

    public void setService(List<Service> service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DIDDocument)) {
            return false;
        }
        DIDDocument other = (DIDDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$context = this.getContext();
        List<String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$alsoKnownAs = this.getAlsoKnownAs();
        List<String> other$alsoKnownAs = other.getAlsoKnownAs();
        if (this$alsoKnownAs == null ? other$alsoKnownAs != null : !((Object)this$alsoKnownAs).equals(other$alsoKnownAs)) {
            return false;
        }
        String this$controller = this.getController();
        String other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
            return false;
        }
        List<VerificationMethod> this$verificationMethod = this.getVerificationMethod();
        List<VerificationMethod> other$verificationMethod = other.getVerificationMethod();
        if (this$verificationMethod == null ? other$verificationMethod != null : !((Object)this$verificationMethod).equals(other$verificationMethod)) {
            return false;
        }
        List<Object> this$authentication = this.getAuthentication();
        List<Object> other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        List<Object> this$assertionMethod = this.getAssertionMethod();
        List<Object> other$assertionMethod = other.getAssertionMethod();
        if (this$assertionMethod == null ? other$assertionMethod != null : !((Object)this$assertionMethod).equals(other$assertionMethod)) {
            return false;
        }
        List<Object> this$keyAgreement = this.getKeyAgreement();
        List<Object> other$keyAgreement = other.getKeyAgreement();
        if (this$keyAgreement == null ? other$keyAgreement != null : !((Object)this$keyAgreement).equals(other$keyAgreement)) {
            return false;
        }
        List<Object> this$capabilityInvocation = this.getCapabilityInvocation();
        List<Object> other$capabilityInvocation = other.getCapabilityInvocation();
        if (this$capabilityInvocation == null ? other$capabilityInvocation != null : !((Object)this$capabilityInvocation).equals(other$capabilityInvocation)) {
            return false;
        }
        List<Object> this$capabilityDelegation = this.getCapabilityDelegation();
        List<Object> other$capabilityDelegation = other.getCapabilityDelegation();
        if (this$capabilityDelegation == null ? other$capabilityDelegation != null : !((Object)this$capabilityDelegation).equals(other$capabilityDelegation)) {
            return false;
        }
        List<Service> this$service = this.getService();
        List<Service> other$service = other.getService();
        return !(this$service == null ? other$service != null : !((Object)this$service).equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DIDDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $alsoKnownAs = this.getAlsoKnownAs();
        result = result * 59 + ($alsoKnownAs == null ? 43 : ((Object)$alsoKnownAs).hashCode());
        String $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
        List<VerificationMethod> $verificationMethod = this.getVerificationMethod();
        result = result * 59 + ($verificationMethod == null ? 43 : ((Object)$verificationMethod).hashCode());
        List<Object> $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        List<Object> $assertionMethod = this.getAssertionMethod();
        result = result * 59 + ($assertionMethod == null ? 43 : ((Object)$assertionMethod).hashCode());
        List<Object> $keyAgreement = this.getKeyAgreement();
        result = result * 59 + ($keyAgreement == null ? 43 : ((Object)$keyAgreement).hashCode());
        List<Object> $capabilityInvocation = this.getCapabilityInvocation();
        result = result * 59 + ($capabilityInvocation == null ? 43 : ((Object)$capabilityInvocation).hashCode());
        List<Object> $capabilityDelegation = this.getCapabilityDelegation();
        result = result * 59 + ($capabilityDelegation == null ? 43 : ((Object)$capabilityDelegation).hashCode());
        List<Service> $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
        return result;
    }

    public String toString() {
        return "DIDDocument(context=" + this.getContext() + ", id=" + this.getId() + ", alsoKnownAs=" + this.getAlsoKnownAs() + ", controller=" + this.getController() + ", verificationMethod=" + this.getVerificationMethod() + ", authentication=" + this.getAuthentication() + ", assertionMethod=" + this.getAssertionMethod() + ", keyAgreement=" + this.getKeyAgreement() + ", capabilityInvocation=" + this.getCapabilityInvocation() + ", capabilityDelegation=" + this.getCapabilityDelegation() + ", service=" + this.getService() + ")";
    }

    public DIDDocument() {
    }

    public DIDDocument(List<String> context, String id, List<String> alsoKnownAs, String controller, List<VerificationMethod> verificationMethod, List<Object> authentication, List<Object> assertionMethod, List<Object> keyAgreement, List<Object> capabilityInvocation, List<Object> capabilityDelegation, List<Service> service) {
        this.context = context;
        this.id = id;
        this.alsoKnownAs = alsoKnownAs;
        this.controller = controller;
        this.verificationMethod = verificationMethod;
        this.authentication = authentication;
        this.assertionMethod = assertionMethod;
        this.keyAgreement = keyAgreement;
        this.capabilityInvocation = capabilityInvocation;
        this.capabilityDelegation = capabilityDelegation;
        this.service = service;
    }

    public static class DIDDocumentBuilder {
        private List<String> context;
        private String id;
        private List<String> alsoKnownAs;
        private String controller;
        private List<VerificationMethod> verificationMethod;
        private List<Object> authentication;
        private List<Object> assertionMethod;
        private List<Object> keyAgreement;
        private List<Object> capabilityInvocation;
        private List<Object> capabilityDelegation;
        private List<Service> service;

        DIDDocumentBuilder() {
        }

        @JsonProperty(value="@context")
        public DIDDocumentBuilder context(List<String> context) {
            this.context = context;
            return this;
        }

        public DIDDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DIDDocumentBuilder alsoKnownAs(List<String> alsoKnownAs) {
            this.alsoKnownAs = alsoKnownAs;
            return this;
        }

        public DIDDocumentBuilder controller(String controller) {
            this.controller = controller;
            return this;
        }

        public DIDDocumentBuilder verificationMethod(List<VerificationMethod> verificationMethod) {
            this.verificationMethod = verificationMethod;
            return this;
        }

        public DIDDocumentBuilder authentication(List<Object> authentication) {
            this.authentication = authentication;
            return this;
        }

        public DIDDocumentBuilder assertionMethod(List<Object> assertionMethod) {
            this.assertionMethod = assertionMethod;
            return this;
        }

        public DIDDocumentBuilder keyAgreement(List<Object> keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public DIDDocumentBuilder capabilityInvocation(List<Object> capabilityInvocation) {
            this.capabilityInvocation = capabilityInvocation;
            return this;
        }

        public DIDDocumentBuilder capabilityDelegation(List<Object> capabilityDelegation) {
            this.capabilityDelegation = capabilityDelegation;
            return this;
        }

        public DIDDocumentBuilder service(List<Service> service) {
            this.service = service;
            return this;
        }

        public DIDDocument build() {
            return new DIDDocument(this.context, this.id, this.alsoKnownAs, this.controller, this.verificationMethod, this.authentication, this.assertionMethod, this.keyAgreement, this.capabilityInvocation, this.capabilityDelegation, this.service);
        }

        public String toString() {
            return "DIDDocument.DIDDocumentBuilder(context=" + this.context + ", id=" + this.id + ", alsoKnownAs=" + this.alsoKnownAs + ", controller=" + this.controller + ", verificationMethod=" + this.verificationMethod + ", authentication=" + this.authentication + ", assertionMethod=" + this.assertionMethod + ", keyAgreement=" + this.keyAgreement + ", capabilityInvocation=" + this.capabilityInvocation + ", capabilityDelegation=" + this.capabilityDelegation + ", service=" + this.service + ")";
        }
    }

    public static final class Service {
        private String id;
        private String type;
        @SerializedName(value="serviceEndpoint")
        private String serviceEndpoint;
        @SerializedName(value="recipientKeys")
        private List<String> recipientKeys;
        @SerializedName(value="routingKeys")
        private List<String> routingKeys;
        private Integer priority;

        public static ServiceBuilder builder() {
            return new ServiceBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public List<String> getRecipientKeys() {
            return this.recipientKeys;
        }

        public List<String> getRoutingKeys() {
            return this.routingKeys;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public void setRecipientKeys(List<String> recipientKeys) {
            this.recipientKeys = recipientKeys;
        }

        public void setRoutingKeys(List<String> routingKeys) {
            this.routingKeys = routingKeys;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$serviceEndpoint = this.getServiceEndpoint();
            String other$serviceEndpoint = other.getServiceEndpoint();
            if (this$serviceEndpoint == null ? other$serviceEndpoint != null : !this$serviceEndpoint.equals(other$serviceEndpoint)) {
                return false;
            }
            List<String> this$recipientKeys = this.getRecipientKeys();
            List<String> other$recipientKeys = other.getRecipientKeys();
            if (this$recipientKeys == null ? other$recipientKeys != null : !((Object)this$recipientKeys).equals(other$recipientKeys)) {
                return false;
            }
            List<String> this$routingKeys = this.getRoutingKeys();
            List<String> other$routingKeys = other.getRoutingKeys();
            return !(this$routingKeys == null ? other$routingKeys != null : !((Object)this$routingKeys).equals(other$routingKeys));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $serviceEndpoint = this.getServiceEndpoint();
            result = result * 59 + ($serviceEndpoint == null ? 43 : $serviceEndpoint.hashCode());
            List<String> $recipientKeys = this.getRecipientKeys();
            result = result * 59 + ($recipientKeys == null ? 43 : ((Object)$recipientKeys).hashCode());
            List<String> $routingKeys = this.getRoutingKeys();
            result = result * 59 + ($routingKeys == null ? 43 : ((Object)$routingKeys).hashCode());
            return result;
        }

        public String toString() {
            return "DIDDocument.Service(id=" + this.getId() + ", type=" + this.getType() + ", serviceEndpoint=" + this.getServiceEndpoint() + ", recipientKeys=" + this.getRecipientKeys() + ", routingKeys=" + this.getRoutingKeys() + ", priority=" + this.getPriority() + ")";
        }

        public Service() {
        }

        public Service(String id, String type, String serviceEndpoint, List<String> recipientKeys, List<String> routingKeys, Integer priority) {
            this.id = id;
            this.type = type;
            this.serviceEndpoint = serviceEndpoint;
            this.recipientKeys = recipientKeys;
            this.routingKeys = routingKeys;
            this.priority = priority;
        }

        public static class ServiceBuilder {
            private String id;
            private String type;
            private String serviceEndpoint;
            private List<String> recipientKeys;
            private List<String> routingKeys;
            private Integer priority;

            ServiceBuilder() {
            }

            public ServiceBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ServiceBuilder type(String type) {
                this.type = type;
                return this;
            }

            public ServiceBuilder serviceEndpoint(String serviceEndpoint) {
                this.serviceEndpoint = serviceEndpoint;
                return this;
            }

            public ServiceBuilder recipientKeys(List<String> recipientKeys) {
                this.recipientKeys = recipientKeys;
                return this;
            }

            public ServiceBuilder routingKeys(List<String> routingKeys) {
                this.routingKeys = routingKeys;
                return this;
            }

            public ServiceBuilder priority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public Service build() {
                return new Service(this.id, this.type, this.serviceEndpoint, this.recipientKeys, this.routingKeys, this.priority);
            }

            public String toString() {
                return "DIDDocument.Service.ServiceBuilder(id=" + this.id + ", type=" + this.type + ", serviceEndpoint=" + this.serviceEndpoint + ", recipientKeys=" + this.recipientKeys + ", routingKeys=" + this.routingKeys + ", priority=" + this.priority + ")";
            }
        }
    }

    public static final class VerificationMethod {
        private String id;
        private String type;
        private String controller;
        @SerializedName(value="publicKeyBase58")
        private String publicKeyBase58;

        public static VerificationMethodBuilder builder() {
            return new VerificationMethodBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getController() {
            return this.controller;
        }

        public String getPublicKeyBase58() {
            return this.publicKeyBase58;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setController(String controller) {
            this.controller = controller;
        }

        public void setPublicKeyBase58(String publicKeyBase58) {
            this.publicKeyBase58 = publicKeyBase58;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationMethod)) {
                return false;
            }
            VerificationMethod other = (VerificationMethod)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$controller = this.getController();
            String other$controller = other.getController();
            if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
                return false;
            }
            String this$publicKeyBase58 = this.getPublicKeyBase58();
            String other$publicKeyBase58 = other.getPublicKeyBase58();
            return !(this$publicKeyBase58 == null ? other$publicKeyBase58 != null : !this$publicKeyBase58.equals(other$publicKeyBase58));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $controller = this.getController();
            result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
            String $publicKeyBase58 = this.getPublicKeyBase58();
            result = result * 59 + ($publicKeyBase58 == null ? 43 : $publicKeyBase58.hashCode());
            return result;
        }

        public String toString() {
            return "DIDDocument.VerificationMethod(id=" + this.getId() + ", type=" + this.getType() + ", controller=" + this.getController() + ", publicKeyBase58=" + this.getPublicKeyBase58() + ")";
        }

        public VerificationMethod() {
        }

        public VerificationMethod(String id, String type, String controller, String publicKeyBase58) {
            this.id = id;
            this.type = type;
            this.controller = controller;
            this.publicKeyBase58 = publicKeyBase58;
        }

        public static class VerificationMethodBuilder {
            private String id;
            private String type;
            private String controller;
            private String publicKeyBase58;

            VerificationMethodBuilder() {
            }

            public VerificationMethodBuilder id(String id) {
                this.id = id;
                return this;
            }

            public VerificationMethodBuilder type(String type) {
                this.type = type;
                return this;
            }

            public VerificationMethodBuilder controller(String controller) {
                this.controller = controller;
                return this;
            }

            public VerificationMethodBuilder publicKeyBase58(String publicKeyBase58) {
                this.publicKeyBase58 = publicKeyBase58;
                return this;
            }

            public VerificationMethod build() {
                return new VerificationMethod(this.id, this.type, this.controller, this.publicKeyBase58);
            }

            public String toString() {
                return "DIDDocument.VerificationMethod.VerificationMethodBuilder(id=" + this.id + ", type=" + this.type + ", controller=" + this.controller + ", publicKeyBase58=" + this.publicKeyBase58 + ")";
            }
        }
    }
}

