/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof_v2;

import java.util.List;
import java.util.UUID;
import org.hyperledger.acy_py.generated.model.DIFHolder;
import org.hyperledger.acy_py.generated.model.DIFOptions;
import org.hyperledger.acy_py.generated.model.SubmissionRequirements;
import org.hyperledger.aries.api.jsonld.ProofType;
import org.hyperledger.aries.api.present_proof_v2.DIFField;

public class V2DIFProofRequest {
    private DIFOptions options;
    private PresentationDefinition presentationDefinition;

    public static V2DIFProofRequestBuilder builder() {
        return new V2DIFProofRequestBuilder();
    }

    public DIFOptions getOptions() {
        return this.options;
    }

    public PresentationDefinition getPresentationDefinition() {
        return this.presentationDefinition;
    }

    public void setOptions(DIFOptions options) {
        this.options = options;
    }

    public void setPresentationDefinition(PresentationDefinition presentationDefinition) {
        this.presentationDefinition = presentationDefinition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V2DIFProofRequest)) {
            return false;
        }
        V2DIFProofRequest other = (V2DIFProofRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DIFOptions this$options = this.getOptions();
        DIFOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        PresentationDefinition this$presentationDefinition = this.getPresentationDefinition();
        PresentationDefinition other$presentationDefinition = other.getPresentationDefinition();
        return !(this$presentationDefinition == null ? other$presentationDefinition != null : !((Object)this$presentationDefinition).equals(other$presentationDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V2DIFProofRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DIFOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        PresentationDefinition $presentationDefinition = this.getPresentationDefinition();
        result = result * 59 + ($presentationDefinition == null ? 43 : ((Object)$presentationDefinition).hashCode());
        return result;
    }

    public String toString() {
        return "V2DIFProofRequest(options=" + this.getOptions() + ", presentationDefinition=" + this.getPresentationDefinition() + ")";
    }

    public V2DIFProofRequest(DIFOptions options, PresentationDefinition presentationDefinition) {
        this.options = options;
        this.presentationDefinition = presentationDefinition;
    }

    public V2DIFProofRequest() {
    }

    public static class V2DIFProofRequestBuilder {
        private DIFOptions options;
        private PresentationDefinition presentationDefinition;

        V2DIFProofRequestBuilder() {
        }

        public V2DIFProofRequestBuilder options(DIFOptions options) {
            this.options = options;
            return this;
        }

        public V2DIFProofRequestBuilder presentationDefinition(PresentationDefinition presentationDefinition) {
            this.presentationDefinition = presentationDefinition;
            return this;
        }

        public V2DIFProofRequest build() {
            return new V2DIFProofRequest(this.options, this.presentationDefinition);
        }

        public String toString() {
            return "V2DIFProofRequest.V2DIFProofRequestBuilder(options=" + this.options + ", presentationDefinition=" + this.presentationDefinition + ")";
        }
    }

    public static class PresentationDefinition {
        private ClaimFormat format;
        private UUID id;
        private List<InputDescriptors> inputDescriptors;
        private String name;
        private String purpose;
        private List<SubmissionRequirements> submissionRequirements;

        public static PresentationDefinitionBuilder builder() {
            return new PresentationDefinitionBuilder();
        }

        public ClaimFormat getFormat() {
            return this.format;
        }

        public UUID getId() {
            return this.id;
        }

        public List<InputDescriptors> getInputDescriptors() {
            return this.inputDescriptors;
        }

        public String getName() {
            return this.name;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public List<SubmissionRequirements> getSubmissionRequirements() {
            return this.submissionRequirements;
        }

        public void setFormat(ClaimFormat format) {
            this.format = format;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public void setInputDescriptors(List<InputDescriptors> inputDescriptors) {
            this.inputDescriptors = inputDescriptors;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPurpose(String purpose) {
            this.purpose = purpose;
        }

        public void setSubmissionRequirements(List<SubmissionRequirements> submissionRequirements) {
            this.submissionRequirements = submissionRequirements;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PresentationDefinition)) {
                return false;
            }
            PresentationDefinition other = (PresentationDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClaimFormat this$format = this.getFormat();
            ClaimFormat other$format = other.getFormat();
            if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            List<InputDescriptors> this$inputDescriptors = this.getInputDescriptors();
            List<InputDescriptors> other$inputDescriptors = other.getInputDescriptors();
            if (this$inputDescriptors == null ? other$inputDescriptors != null : !((Object)this$inputDescriptors).equals(other$inputDescriptors)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$purpose = this.getPurpose();
            String other$purpose = other.getPurpose();
            if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
                return false;
            }
            List<SubmissionRequirements> this$submissionRequirements = this.getSubmissionRequirements();
            List<SubmissionRequirements> other$submissionRequirements = other.getSubmissionRequirements();
            return !(this$submissionRequirements == null ? other$submissionRequirements != null : !((Object)this$submissionRequirements).equals(other$submissionRequirements));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PresentationDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClaimFormat $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            List<InputDescriptors> $inputDescriptors = this.getInputDescriptors();
            result = result * 59 + ($inputDescriptors == null ? 43 : ((Object)$inputDescriptors).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $purpose = this.getPurpose();
            result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
            List<SubmissionRequirements> $submissionRequirements = this.getSubmissionRequirements();
            result = result * 59 + ($submissionRequirements == null ? 43 : ((Object)$submissionRequirements).hashCode());
            return result;
        }

        public String toString() {
            return "V2DIFProofRequest.PresentationDefinition(format=" + this.getFormat() + ", id=" + this.getId() + ", inputDescriptors=" + this.getInputDescriptors() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", submissionRequirements=" + this.getSubmissionRequirements() + ")";
        }

        public PresentationDefinition(ClaimFormat format, UUID id, List<InputDescriptors> inputDescriptors, String name, String purpose, List<SubmissionRequirements> submissionRequirements) {
            this.format = format;
            this.id = id;
            this.inputDescriptors = inputDescriptors;
            this.name = name;
            this.purpose = purpose;
            this.submissionRequirements = submissionRequirements;
        }

        public PresentationDefinition() {
        }

        public static class PresentationDefinitionBuilder {
            private ClaimFormat format;
            private UUID id;
            private List<InputDescriptors> inputDescriptors;
            private String name;
            private String purpose;
            private List<SubmissionRequirements> submissionRequirements;

            PresentationDefinitionBuilder() {
            }

            public PresentationDefinitionBuilder format(ClaimFormat format) {
                this.format = format;
                return this;
            }

            public PresentationDefinitionBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            public PresentationDefinitionBuilder inputDescriptors(List<InputDescriptors> inputDescriptors) {
                this.inputDescriptors = inputDescriptors;
                return this;
            }

            public PresentationDefinitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PresentationDefinitionBuilder purpose(String purpose) {
                this.purpose = purpose;
                return this;
            }

            public PresentationDefinitionBuilder submissionRequirements(List<SubmissionRequirements> submissionRequirements) {
                this.submissionRequirements = submissionRequirements;
                return this;
            }

            public PresentationDefinition build() {
                return new PresentationDefinition(this.format, this.id, this.inputDescriptors, this.name, this.purpose, this.submissionRequirements);
            }

            public String toString() {
                return "V2DIFProofRequest.PresentationDefinition.PresentationDefinitionBuilder(format=" + this.format + ", id=" + this.id + ", inputDescriptors=" + this.inputDescriptors + ", name=" + this.name + ", purpose=" + this.purpose + ", submissionRequirements=" + this.submissionRequirements + ")";
            }
        }

        public static class Constraints {
            private List<DIFField> fields;
            private List<DIFHolder> isHolder;
            private SubjectEnum limitDisclosure;
            private StatusEnum statusActive;
            private StatusEnum statusRevoked;
            private StatusEnum statusSuspended;
            private SubjectEnum subjectIsIssuer;

            public static ConstraintsBuilder builder() {
                return new ConstraintsBuilder();
            }

            public List<DIFField> getFields() {
                return this.fields;
            }

            public List<DIFHolder> getIsHolder() {
                return this.isHolder;
            }

            public SubjectEnum getLimitDisclosure() {
                return this.limitDisclosure;
            }

            public StatusEnum getStatusActive() {
                return this.statusActive;
            }

            public StatusEnum getStatusRevoked() {
                return this.statusRevoked;
            }

            public StatusEnum getStatusSuspended() {
                return this.statusSuspended;
            }

            public SubjectEnum getSubjectIsIssuer() {
                return this.subjectIsIssuer;
            }

            public void setFields(List<DIFField> fields) {
                this.fields = fields;
            }

            public void setIsHolder(List<DIFHolder> isHolder) {
                this.isHolder = isHolder;
            }

            public void setLimitDisclosure(SubjectEnum limitDisclosure) {
                this.limitDisclosure = limitDisclosure;
            }

            public void setStatusActive(StatusEnum statusActive) {
                this.statusActive = statusActive;
            }

            public void setStatusRevoked(StatusEnum statusRevoked) {
                this.statusRevoked = statusRevoked;
            }

            public void setStatusSuspended(StatusEnum statusSuspended) {
                this.statusSuspended = statusSuspended;
            }

            public void setSubjectIsIssuer(SubjectEnum subjectIsIssuer) {
                this.subjectIsIssuer = subjectIsIssuer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Constraints)) {
                    return false;
                }
                Constraints other = (Constraints)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<DIFField> this$fields = this.getFields();
                List<DIFField> other$fields = other.getFields();
                if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                    return false;
                }
                List<DIFHolder> this$isHolder = this.getIsHolder();
                List<DIFHolder> other$isHolder = other.getIsHolder();
                if (this$isHolder == null ? other$isHolder != null : !((Object)this$isHolder).equals(other$isHolder)) {
                    return false;
                }
                SubjectEnum this$limitDisclosure = this.getLimitDisclosure();
                SubjectEnum other$limitDisclosure = other.getLimitDisclosure();
                if (this$limitDisclosure == null ? other$limitDisclosure != null : !((Object)((Object)this$limitDisclosure)).equals((Object)other$limitDisclosure)) {
                    return false;
                }
                StatusEnum this$statusActive = this.getStatusActive();
                StatusEnum other$statusActive = other.getStatusActive();
                if (this$statusActive == null ? other$statusActive != null : !((Object)((Object)this$statusActive)).equals((Object)other$statusActive)) {
                    return false;
                }
                StatusEnum this$statusRevoked = this.getStatusRevoked();
                StatusEnum other$statusRevoked = other.getStatusRevoked();
                if (this$statusRevoked == null ? other$statusRevoked != null : !((Object)((Object)this$statusRevoked)).equals((Object)other$statusRevoked)) {
                    return false;
                }
                StatusEnum this$statusSuspended = this.getStatusSuspended();
                StatusEnum other$statusSuspended = other.getStatusSuspended();
                if (this$statusSuspended == null ? other$statusSuspended != null : !((Object)((Object)this$statusSuspended)).equals((Object)other$statusSuspended)) {
                    return false;
                }
                SubjectEnum this$subjectIsIssuer = this.getSubjectIsIssuer();
                SubjectEnum other$subjectIsIssuer = other.getSubjectIsIssuer();
                return !(this$subjectIsIssuer == null ? other$subjectIsIssuer != null : !((Object)((Object)this$subjectIsIssuer)).equals((Object)other$subjectIsIssuer));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Constraints;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<DIFField> $fields = this.getFields();
                result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
                List<DIFHolder> $isHolder = this.getIsHolder();
                result = result * 59 + ($isHolder == null ? 43 : ((Object)$isHolder).hashCode());
                SubjectEnum $limitDisclosure = this.getLimitDisclosure();
                result = result * 59 + ($limitDisclosure == null ? 43 : ((Object)((Object)$limitDisclosure)).hashCode());
                StatusEnum $statusActive = this.getStatusActive();
                result = result * 59 + ($statusActive == null ? 43 : ((Object)((Object)$statusActive)).hashCode());
                StatusEnum $statusRevoked = this.getStatusRevoked();
                result = result * 59 + ($statusRevoked == null ? 43 : ((Object)((Object)$statusRevoked)).hashCode());
                StatusEnum $statusSuspended = this.getStatusSuspended();
                result = result * 59 + ($statusSuspended == null ? 43 : ((Object)((Object)$statusSuspended)).hashCode());
                SubjectEnum $subjectIsIssuer = this.getSubjectIsIssuer();
                result = result * 59 + ($subjectIsIssuer == null ? 43 : ((Object)((Object)$subjectIsIssuer)).hashCode());
                return result;
            }

            public String toString() {
                return "V2DIFProofRequest.PresentationDefinition.Constraints(fields=" + this.getFields() + ", isHolder=" + this.getIsHolder() + ", limitDisclosure=" + this.getLimitDisclosure() + ", statusActive=" + this.getStatusActive() + ", statusRevoked=" + this.getStatusRevoked() + ", statusSuspended=" + this.getStatusSuspended() + ", subjectIsIssuer=" + this.getSubjectIsIssuer() + ")";
            }

            public Constraints(List<DIFField> fields, List<DIFHolder> isHolder, SubjectEnum limitDisclosure, StatusEnum statusActive, StatusEnum statusRevoked, StatusEnum statusSuspended, SubjectEnum subjectIsIssuer) {
                this.fields = fields;
                this.isHolder = isHolder;
                this.limitDisclosure = limitDisclosure;
                this.statusActive = statusActive;
                this.statusRevoked = statusRevoked;
                this.statusSuspended = statusSuspended;
                this.subjectIsIssuer = subjectIsIssuer;
            }

            public Constraints() {
            }

            public static class ConstraintsBuilder {
                private List<DIFField> fields;
                private List<DIFHolder> isHolder;
                private SubjectEnum limitDisclosure;
                private StatusEnum statusActive;
                private StatusEnum statusRevoked;
                private StatusEnum statusSuspended;
                private SubjectEnum subjectIsIssuer;

                ConstraintsBuilder() {
                }

                public ConstraintsBuilder fields(List<DIFField> fields) {
                    this.fields = fields;
                    return this;
                }

                public ConstraintsBuilder isHolder(List<DIFHolder> isHolder) {
                    this.isHolder = isHolder;
                    return this;
                }

                public ConstraintsBuilder limitDisclosure(SubjectEnum limitDisclosure) {
                    this.limitDisclosure = limitDisclosure;
                    return this;
                }

                public ConstraintsBuilder statusActive(StatusEnum statusActive) {
                    this.statusActive = statusActive;
                    return this;
                }

                public ConstraintsBuilder statusRevoked(StatusEnum statusRevoked) {
                    this.statusRevoked = statusRevoked;
                    return this;
                }

                public ConstraintsBuilder statusSuspended(StatusEnum statusSuspended) {
                    this.statusSuspended = statusSuspended;
                    return this;
                }

                public ConstraintsBuilder subjectIsIssuer(SubjectEnum subjectIsIssuer) {
                    this.subjectIsIssuer = subjectIsIssuer;
                    return this;
                }

                public Constraints build() {
                    return new Constraints(this.fields, this.isHolder, this.limitDisclosure, this.statusActive, this.statusRevoked, this.statusSuspended, this.subjectIsIssuer);
                }

                public String toString() {
                    return "V2DIFProofRequest.PresentationDefinition.Constraints.ConstraintsBuilder(fields=" + this.fields + ", isHolder=" + this.isHolder + ", limitDisclosure=" + this.limitDisclosure + ", statusActive=" + this.statusActive + ", statusRevoked=" + this.statusRevoked + ", statusSuspended=" + this.statusSuspended + ", subjectIsIssuer=" + this.subjectIsIssuer + ")";
                }
            }

            public static enum SubjectEnum {
                REQUIRED,
                PREFERRED;

            }

            public static enum StatusEnum {
                REQUIRED,
                ALLOWED,
                DISALLOWED;

            }
        }

        public static class InputDescriptors {
            private Constraints constraints;
            private List<String> group;
            private String id;
            private Object metadata;
            private String name;
            private String purpose;
            private List<SchemaInputDescriptorUri> schema;

            public static InputDescriptorsBuilder builder() {
                return new InputDescriptorsBuilder();
            }

            public Constraints getConstraints() {
                return this.constraints;
            }

            public List<String> getGroup() {
                return this.group;
            }

            public String getId() {
                return this.id;
            }

            public Object getMetadata() {
                return this.metadata;
            }

            public String getName() {
                return this.name;
            }

            public String getPurpose() {
                return this.purpose;
            }

            public List<SchemaInputDescriptorUri> getSchema() {
                return this.schema;
            }

            public void setConstraints(Constraints constraints) {
                this.constraints = constraints;
            }

            public void setGroup(List<String> group) {
                this.group = group;
            }

            public void setId(String id) {
                this.id = id;
            }

            public void setMetadata(Object metadata) {
                this.metadata = metadata;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setPurpose(String purpose) {
                this.purpose = purpose;
            }

            public void setSchema(List<SchemaInputDescriptorUri> schema) {
                this.schema = schema;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InputDescriptors)) {
                    return false;
                }
                InputDescriptors other = (InputDescriptors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Constraints this$constraints = this.getConstraints();
                Constraints other$constraints = other.getConstraints();
                if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
                    return false;
                }
                List<String> this$group = this.getGroup();
                List<String> other$group = other.getGroup();
                if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                Object this$metadata = this.getMetadata();
                Object other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$purpose = this.getPurpose();
                String other$purpose = other.getPurpose();
                if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
                    return false;
                }
                List<SchemaInputDescriptorUri> this$schema = this.getSchema();
                List<SchemaInputDescriptorUri> other$schema = other.getSchema();
                return !(this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema));
            }

            protected boolean canEqual(Object other) {
                return other instanceof InputDescriptors;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Constraints $constraints = this.getConstraints();
                result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
                List<String> $group = this.getGroup();
                result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                Object $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $purpose = this.getPurpose();
                result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
                List<SchemaInputDescriptorUri> $schema = this.getSchema();
                result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
                return result;
            }

            public String toString() {
                return "V2DIFProofRequest.PresentationDefinition.InputDescriptors(constraints=" + this.getConstraints() + ", group=" + this.getGroup() + ", id=" + this.getId() + ", metadata=" + this.getMetadata() + ", name=" + this.getName() + ", purpose=" + this.getPurpose() + ", schema=" + this.getSchema() + ")";
            }

            public InputDescriptors(Constraints constraints, List<String> group, String id, Object metadata, String name, String purpose, List<SchemaInputDescriptorUri> schema) {
                this.constraints = constraints;
                this.group = group;
                this.id = id;
                this.metadata = metadata;
                this.name = name;
                this.purpose = purpose;
                this.schema = schema;
            }

            public InputDescriptors() {
            }

            public static class InputDescriptorsBuilder {
                private Constraints constraints;
                private List<String> group;
                private String id;
                private Object metadata;
                private String name;
                private String purpose;
                private List<SchemaInputDescriptorUri> schema;

                InputDescriptorsBuilder() {
                }

                public InputDescriptorsBuilder constraints(Constraints constraints) {
                    this.constraints = constraints;
                    return this;
                }

                public InputDescriptorsBuilder group(List<String> group) {
                    this.group = group;
                    return this;
                }

                public InputDescriptorsBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                public InputDescriptorsBuilder metadata(Object metadata) {
                    this.metadata = metadata;
                    return this;
                }

                public InputDescriptorsBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                public InputDescriptorsBuilder purpose(String purpose) {
                    this.purpose = purpose;
                    return this;
                }

                public InputDescriptorsBuilder schema(List<SchemaInputDescriptorUri> schema) {
                    this.schema = schema;
                    return this;
                }

                public InputDescriptors build() {
                    return new InputDescriptors(this.constraints, this.group, this.id, this.metadata, this.name, this.purpose, this.schema);
                }

                public String toString() {
                    return "V2DIFProofRequest.PresentationDefinition.InputDescriptors.InputDescriptorsBuilder(constraints=" + this.constraints + ", group=" + this.group + ", id=" + this.id + ", metadata=" + this.metadata + ", name=" + this.name + ", purpose=" + this.purpose + ", schema=" + this.schema + ")";
                }
            }

            public static class SchemaInputDescriptorUri {
                private String uri;

                public static SchemaInputDescriptorUriBuilder builder() {
                    return new SchemaInputDescriptorUriBuilder();
                }

                public String getUri() {
                    return this.uri;
                }

                public void setUri(String uri) {
                    this.uri = uri;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SchemaInputDescriptorUri)) {
                        return false;
                    }
                    SchemaInputDescriptorUri other = (SchemaInputDescriptorUri)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$uri = this.getUri();
                    String other$uri = other.getUri();
                    return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof SchemaInputDescriptorUri;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $uri = this.getUri();
                    result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
                    return result;
                }

                public String toString() {
                    return "V2DIFProofRequest.PresentationDefinition.InputDescriptors.SchemaInputDescriptorUri(uri=" + this.getUri() + ")";
                }

                public SchemaInputDescriptorUri(String uri) {
                    this.uri = uri;
                }

                public SchemaInputDescriptorUri() {
                }

                public static class SchemaInputDescriptorUriBuilder {
                    private String uri;

                    SchemaInputDescriptorUriBuilder() {
                    }

                    public SchemaInputDescriptorUriBuilder uri(String uri) {
                        this.uri = uri;
                        return this;
                    }

                    public SchemaInputDescriptorUri build() {
                        return new SchemaInputDescriptorUri(this.uri);
                    }

                    public String toString() {
                        return "V2DIFProofRequest.PresentationDefinition.InputDescriptors.SchemaInputDescriptorUri.SchemaInputDescriptorUriBuilder(uri=" + this.uri + ")";
                    }
                }
            }
        }

        public static class ClaimFormat {
            private Object jwt;
            private Object jwtVc;
            private Object jwtVp;
            private Object ldp;
            private Object ldpVc;
            private LdpVp ldpVp;

            public static ClaimFormatBuilder builder() {
                return new ClaimFormatBuilder();
            }

            public Object getJwt() {
                return this.jwt;
            }

            public Object getJwtVc() {
                return this.jwtVc;
            }

            public Object getJwtVp() {
                return this.jwtVp;
            }

            public Object getLdp() {
                return this.ldp;
            }

            public Object getLdpVc() {
                return this.ldpVc;
            }

            public LdpVp getLdpVp() {
                return this.ldpVp;
            }

            public void setJwt(Object jwt) {
                this.jwt = jwt;
            }

            public void setJwtVc(Object jwtVc) {
                this.jwtVc = jwtVc;
            }

            public void setJwtVp(Object jwtVp) {
                this.jwtVp = jwtVp;
            }

            public void setLdp(Object ldp) {
                this.ldp = ldp;
            }

            public void setLdpVc(Object ldpVc) {
                this.ldpVc = ldpVc;
            }

            public void setLdpVp(LdpVp ldpVp) {
                this.ldpVp = ldpVp;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClaimFormat)) {
                    return false;
                }
                ClaimFormat other = (ClaimFormat)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$jwt = this.getJwt();
                Object other$jwt = other.getJwt();
                if (this$jwt == null ? other$jwt != null : !this$jwt.equals(other$jwt)) {
                    return false;
                }
                Object this$jwtVc = this.getJwtVc();
                Object other$jwtVc = other.getJwtVc();
                if (this$jwtVc == null ? other$jwtVc != null : !this$jwtVc.equals(other$jwtVc)) {
                    return false;
                }
                Object this$jwtVp = this.getJwtVp();
                Object other$jwtVp = other.getJwtVp();
                if (this$jwtVp == null ? other$jwtVp != null : !this$jwtVp.equals(other$jwtVp)) {
                    return false;
                }
                Object this$ldp = this.getLdp();
                Object other$ldp = other.getLdp();
                if (this$ldp == null ? other$ldp != null : !this$ldp.equals(other$ldp)) {
                    return false;
                }
                Object this$ldpVc = this.getLdpVc();
                Object other$ldpVc = other.getLdpVc();
                if (this$ldpVc == null ? other$ldpVc != null : !this$ldpVc.equals(other$ldpVc)) {
                    return false;
                }
                LdpVp this$ldpVp = this.getLdpVp();
                LdpVp other$ldpVp = other.getLdpVp();
                return !(this$ldpVp == null ? other$ldpVp != null : !((Object)this$ldpVp).equals(other$ldpVp));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ClaimFormat;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $jwt = this.getJwt();
                result = result * 59 + ($jwt == null ? 43 : $jwt.hashCode());
                Object $jwtVc = this.getJwtVc();
                result = result * 59 + ($jwtVc == null ? 43 : $jwtVc.hashCode());
                Object $jwtVp = this.getJwtVp();
                result = result * 59 + ($jwtVp == null ? 43 : $jwtVp.hashCode());
                Object $ldp = this.getLdp();
                result = result * 59 + ($ldp == null ? 43 : $ldp.hashCode());
                Object $ldpVc = this.getLdpVc();
                result = result * 59 + ($ldpVc == null ? 43 : $ldpVc.hashCode());
                LdpVp $ldpVp = this.getLdpVp();
                result = result * 59 + ($ldpVp == null ? 43 : ((Object)$ldpVp).hashCode());
                return result;
            }

            public String toString() {
                return "V2DIFProofRequest.PresentationDefinition.ClaimFormat(jwt=" + this.getJwt() + ", jwtVc=" + this.getJwtVc() + ", jwtVp=" + this.getJwtVp() + ", ldp=" + this.getLdp() + ", ldpVc=" + this.getLdpVc() + ", ldpVp=" + this.getLdpVp() + ")";
            }

            public ClaimFormat(Object jwt, Object jwtVc, Object jwtVp, Object ldp, Object ldpVc, LdpVp ldpVp) {
                this.jwt = jwt;
                this.jwtVc = jwtVc;
                this.jwtVp = jwtVp;
                this.ldp = ldp;
                this.ldpVc = ldpVc;
                this.ldpVp = ldpVp;
            }

            public ClaimFormat() {
            }

            public static class ClaimFormatBuilder {
                private Object jwt;
                private Object jwtVc;
                private Object jwtVp;
                private Object ldp;
                private Object ldpVc;
                private LdpVp ldpVp;

                ClaimFormatBuilder() {
                }

                public ClaimFormatBuilder jwt(Object jwt) {
                    this.jwt = jwt;
                    return this;
                }

                public ClaimFormatBuilder jwtVc(Object jwtVc) {
                    this.jwtVc = jwtVc;
                    return this;
                }

                public ClaimFormatBuilder jwtVp(Object jwtVp) {
                    this.jwtVp = jwtVp;
                    return this;
                }

                public ClaimFormatBuilder ldp(Object ldp) {
                    this.ldp = ldp;
                    return this;
                }

                public ClaimFormatBuilder ldpVc(Object ldpVc) {
                    this.ldpVc = ldpVc;
                    return this;
                }

                public ClaimFormatBuilder ldpVp(LdpVp ldpVp) {
                    this.ldpVp = ldpVp;
                    return this;
                }

                public ClaimFormat build() {
                    return new ClaimFormat(this.jwt, this.jwtVc, this.jwtVp, this.ldp, this.ldpVc, this.ldpVp);
                }

                public String toString() {
                    return "V2DIFProofRequest.PresentationDefinition.ClaimFormat.ClaimFormatBuilder(jwt=" + this.jwt + ", jwtVc=" + this.jwtVc + ", jwtVp=" + this.jwtVp + ", ldp=" + this.ldp + ", ldpVc=" + this.ldpVc + ", ldpVp=" + this.ldpVp + ")";
                }
            }

            private static class LdpVp {
                List<ProofType> proofType;

                public static LdpVpBuilder builder() {
                    return new LdpVpBuilder();
                }

                public List<ProofType> getProofType() {
                    return this.proofType;
                }

                public void setProofType(List<ProofType> proofType) {
                    this.proofType = proofType;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LdpVp)) {
                        return false;
                    }
                    LdpVp other = (LdpVp)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<ProofType> this$proofType = this.getProofType();
                    List<ProofType> other$proofType = other.getProofType();
                    return !(this$proofType == null ? other$proofType != null : !((Object)this$proofType).equals(other$proofType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof LdpVp;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<ProofType> $proofType = this.getProofType();
                    result = result * 59 + ($proofType == null ? 43 : ((Object)$proofType).hashCode());
                    return result;
                }

                public String toString() {
                    return "V2DIFProofRequest.PresentationDefinition.ClaimFormat.LdpVp(proofType=" + this.getProofType() + ")";
                }

                public LdpVp(List<ProofType> proofType) {
                    this.proofType = proofType;
                }

                public LdpVp() {
                }

                public static class LdpVpBuilder {
                    private List<ProofType> proofType;

                    LdpVpBuilder() {
                    }

                    public LdpVpBuilder proofType(List<ProofType> proofType) {
                        this.proofType = proofType;
                        return this;
                    }

                    public LdpVp build() {
                        return new LdpVp(this.proofType);
                    }

                    public String toString() {
                        return "V2DIFProofRequest.PresentationDefinition.ClaimFormat.LdpVp.LdpVpBuilder(proofType=" + this.proofType + ")";
                    }
                }
            }
        }
    }
}

