/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof_v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.api.jsonld.VerifiablePresentation;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.PresentationFormat;
import org.hyperledger.aries.config.GsonConfig;
import org.hyperledger.aries.webhook.EventParser;

public class V20PresExRecordByFormat {
    private JsonObject presProposal;
    private JsonObject presRequest;
    private JsonObject pres;

    public boolean isIndy() {
        return this.getByFormat(PresentationFormat.INDY, this.presRequest) != null;
    }

    public boolean isDif() {
        return this.getByFormat(PresentationFormat.DIF, this.presProposal) != null || this.getByFormat(PresentationFormat.DIF, this.presRequest) != null || this.getByFormat(PresentationFormat.DIF, this.pres) != null;
    }

    public <T> Optional<T> resolveDifPresentationProposal(Type type) {
        JsonElement dif = this.getByFormat(PresentationFormat.DIF, this.presProposal);
        return EventParser.parseElement(dif, type);
    }

    public Optional<PresentProofRequest.ProofRequest> resolveIndyPresentationRequest() {
        JsonElement indy = this.getByFormat(PresentationFormat.INDY, this.presRequest);
        return EventParser.parseElement(indy, PresentProofRequest.ProofRequest.class);
    }

    public <T> Optional<T> resolveDifPresentationRequest(Type type) {
        JsonElement dif = this.getByFormat(PresentationFormat.DIF, this.presRequest);
        return EventParser.parseElement(dif, type);
    }

    public JsonObject resolveIndyPresentation() {
        JsonElement indy = this.getByFormat(PresentationFormat.INDY, this.pres);
        return indy != null ? indy.getAsJsonObject() : null;
    }

    public VerifiablePresentation<VerifiableCredential> resolveDifPresentation() {
        JsonElement dif = this.getByFormat(PresentationFormat.DIF, this.pres);
        return (VerifiablePresentation)GsonConfig.defaultConfig().fromJson(dif, VerifiablePresentation.VERIFIABLE_CREDENTIAL_TYPE);
    }

    public List<PresentationExchangeRecord.Identifier> resolveIndyIdentifiers() {
        JsonElement indy = this.getByFormat(PresentationFormat.INDY, this.pres);
        return EventParser.resolveIdentifiers(indy != null ? indy.getAsJsonObject() : null);
    }

    private JsonElement getByFormat(PresentationFormat f, JsonObject o) {
        if (o != null) {
            return o.get(f.getValue());
        }
        return null;
    }

    public static V20PresExRecordByFormatBuilder builder() {
        return new V20PresExRecordByFormatBuilder();
    }

    public JsonObject getPresProposal() {
        return this.presProposal;
    }

    public JsonObject getPresRequest() {
        return this.presRequest;
    }

    public JsonObject getPres() {
        return this.pres;
    }

    public void setPresProposal(JsonObject presProposal) {
        this.presProposal = presProposal;
    }

    public void setPresRequest(JsonObject presRequest) {
        this.presRequest = presRequest;
    }

    public void setPres(JsonObject pres) {
        this.pres = pres;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V20PresExRecordByFormat)) {
            return false;
        }
        V20PresExRecordByFormat other = (V20PresExRecordByFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonObject this$presProposal = this.getPresProposal();
        JsonObject other$presProposal = other.getPresProposal();
        if (this$presProposal == null ? other$presProposal != null : !this$presProposal.equals(other$presProposal)) {
            return false;
        }
        JsonObject this$presRequest = this.getPresRequest();
        JsonObject other$presRequest = other.getPresRequest();
        if (this$presRequest == null ? other$presRequest != null : !this$presRequest.equals(other$presRequest)) {
            return false;
        }
        JsonObject this$pres = this.getPres();
        JsonObject other$pres = other.getPres();
        return !(this$pres == null ? other$pres != null : !this$pres.equals(other$pres));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V20PresExRecordByFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonObject $presProposal = this.getPresProposal();
        result = result * 59 + ($presProposal == null ? 43 : $presProposal.hashCode());
        JsonObject $presRequest = this.getPresRequest();
        result = result * 59 + ($presRequest == null ? 43 : $presRequest.hashCode());
        JsonObject $pres = this.getPres();
        result = result * 59 + ($pres == null ? 43 : $pres.hashCode());
        return result;
    }

    public String toString() {
        return "V20PresExRecordByFormat(presProposal=" + this.getPresProposal() + ", presRequest=" + this.getPresRequest() + ", pres=" + this.getPres() + ")";
    }

    public V20PresExRecordByFormat(JsonObject presProposal, JsonObject presRequest, JsonObject pres) {
        this.presProposal = presProposal;
        this.presRequest = presRequest;
        this.pres = pres;
    }

    public V20PresExRecordByFormat() {
    }

    public static class V20PresExRecordByFormatBuilder {
        private JsonObject presProposal;
        private JsonObject presRequest;
        private JsonObject pres;

        V20PresExRecordByFormatBuilder() {
        }

        public V20PresExRecordByFormatBuilder presProposal(JsonObject presProposal) {
            this.presProposal = presProposal;
            return this;
        }

        public V20PresExRecordByFormatBuilder presRequest(JsonObject presRequest) {
            this.presRequest = presRequest;
            return this;
        }

        public V20PresExRecordByFormatBuilder pres(JsonObject pres) {
            this.pres = pres;
            return this;
        }

        public V20PresExRecordByFormat build() {
            return new V20PresExRecordByFormat(this.presProposal, this.presRequest, this.pres);
        }

        public String toString() {
            return "V20PresExRecordByFormat.V20PresExRecordByFormatBuilder(presProposal=" + this.presProposal + ", presRequest=" + this.presRequest + ", pres=" + this.pres + ")";
        }
    }
}

