/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof_v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.hyperledger.acy_py.generated.model.V20Pres;
import org.hyperledger.acy_py.generated.model.V20PresProposal;
import org.hyperledger.acy_py.generated.model.V20PresRequest;
import org.hyperledger.aries.api.ExchangeVersion;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.api.jsonld.VerifiablePresentation;
import org.hyperledger.aries.api.present_proof.BasePresExRecord;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecordByFormat;
import org.hyperledger.aries.api.present_proof_v2.V20PresProposalByFormat;
import org.hyperledger.aries.api.present_proof_v2.V2DIFProofRequest;

public class V20PresExRecord
extends BasePresExRecord {
    private V20PresProposal presProposal;
    private V20PresRequest presRequest;
    private V20Pres pres;
    private V20PresExRecordByFormat byFormat;

    public boolean isIndy() {
        return this.byFormat != null && this.byFormat.isIndy();
    }

    public boolean isDif() {
        return this.byFormat != null && this.byFormat.isDif();
    }

    @Override
    public boolean versionIsV1() {
        return false;
    }

    @Override
    @JsonIgnore
    public ExchangeVersion getVersion() {
        return ExchangeVersion.V2;
    }

    public V20PresProposalByFormat.DIFProofProposal resolveDifPresentationProposal() {
        if (this.byFormat != null) {
            Optional<Object> res = this.byFormat.resolveDifPresentationProposal((Type)((Object)V20PresProposalByFormat.DIFProofProposal.class));
            return res.orElse(null);
        }
        return null;
    }

    public PresentProofRequest.ProofRequest resolveIndyPresentationRequest() {
        if (this.byFormat != null) {
            return this.byFormat.resolveIndyPresentationRequest().orElse(null);
        }
        return null;
    }

    public V2DIFProofRequest resolveDifPresentationRequest() {
        if (this.byFormat != null) {
            Optional<Object> res = this.byFormat.resolveDifPresentationRequest((Type)((Object)V2DIFProofRequest.class));
            return res.orElse(null);
        }
        return null;
    }

    public JsonObject resolveIndyPresentation() {
        if (this.byFormat != null) {
            return this.byFormat.resolveIndyPresentation();
        }
        return null;
    }

    public VerifiablePresentation<VerifiableCredential> resolveDifPresentation() {
        if (this.byFormat != null) {
            return this.byFormat.resolveDifPresentation();
        }
        return null;
    }

    public List<PresentationExchangeRecord.Identifier> resolveIndyIdentifiers() {
        if (this.byFormat != null) {
            return this.byFormat.resolveIndyIdentifiers();
        }
        return List.of();
    }

    protected V20PresExRecord(V20PresExRecordBuilder<?, ?> b) {
        super(b);
        this.presProposal = b.presProposal;
        this.presRequest = b.presRequest;
        this.pres = b.pres;
        this.byFormat = b.byFormat;
    }

    public static V20PresExRecordBuilder<?, ?> builder() {
        return new V20PresExRecordBuilderImpl();
    }

    public V20PresProposal getPresProposal() {
        return this.presProposal;
    }

    public V20PresRequest getPresRequest() {
        return this.presRequest;
    }

    public V20Pres getPres() {
        return this.pres;
    }

    public V20PresExRecordByFormat getByFormat() {
        return this.byFormat;
    }

    public void setPresProposal(V20PresProposal presProposal) {
        this.presProposal = presProposal;
    }

    public void setPresRequest(V20PresRequest presRequest) {
        this.presRequest = presRequest;
    }

    public void setPres(V20Pres pres) {
        this.pres = pres;
    }

    public void setByFormat(V20PresExRecordByFormat byFormat) {
        this.byFormat = byFormat;
    }

    public V20PresExRecord(V20PresProposal presProposal, V20PresRequest presRequest, V20Pres pres, V20PresExRecordByFormat byFormat) {
        this.presProposal = presProposal;
        this.presRequest = presRequest;
        this.pres = pres;
        this.byFormat = byFormat;
    }

    public V20PresExRecord() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V20PresExRecord)) {
            return false;
        }
        V20PresExRecord other = (V20PresExRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V20PresProposal this$presProposal = this.getPresProposal();
        V20PresProposal other$presProposal = other.getPresProposal();
        if (this$presProposal == null ? other$presProposal != null : !((Object)this$presProposal).equals(other$presProposal)) {
            return false;
        }
        V20PresRequest this$presRequest = this.getPresRequest();
        V20PresRequest other$presRequest = other.getPresRequest();
        if (this$presRequest == null ? other$presRequest != null : !((Object)this$presRequest).equals(other$presRequest)) {
            return false;
        }
        V20Pres this$pres = this.getPres();
        V20Pres other$pres = other.getPres();
        if (this$pres == null ? other$pres != null : !((Object)this$pres).equals(other$pres)) {
            return false;
        }
        V20PresExRecordByFormat this$byFormat = this.getByFormat();
        V20PresExRecordByFormat other$byFormat = other.getByFormat();
        return !(this$byFormat == null ? other$byFormat != null : !((Object)this$byFormat).equals(other$byFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof V20PresExRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        V20PresProposal $presProposal = this.getPresProposal();
        result = result * 59 + ($presProposal == null ? 43 : ((Object)$presProposal).hashCode());
        V20PresRequest $presRequest = this.getPresRequest();
        result = result * 59 + ($presRequest == null ? 43 : ((Object)$presRequest).hashCode());
        V20Pres $pres = this.getPres();
        result = result * 59 + ($pres == null ? 43 : ((Object)$pres).hashCode());
        V20PresExRecordByFormat $byFormat = this.getByFormat();
        result = result * 59 + ($byFormat == null ? 43 : ((Object)$byFormat).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "V20PresExRecord(super=" + super.toString() + ", presProposal=" + this.getPresProposal() + ", presRequest=" + this.getPresRequest() + ", pres=" + this.getPres() + ", byFormat=" + this.getByFormat() + ")";
    }

    private static final class V20PresExRecordBuilderImpl
    extends V20PresExRecordBuilder<V20PresExRecord, V20PresExRecordBuilderImpl> {
        private V20PresExRecordBuilderImpl() {
        }

        @Override
        protected V20PresExRecordBuilderImpl self() {
            return this;
        }

        @Override
        public V20PresExRecord build() {
            return new V20PresExRecord(this);
        }
    }

    public static abstract class V20PresExRecordBuilder<C extends V20PresExRecord, B extends V20PresExRecordBuilder<C, B>>
    extends BasePresExRecord.BasePresExRecordBuilder<C, B> {
        private V20PresProposal presProposal;
        private V20PresRequest presRequest;
        private V20Pres pres;
        private V20PresExRecordByFormat byFormat;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B presProposal(V20PresProposal presProposal) {
            this.presProposal = presProposal;
            return (B)this.self();
        }

        public B presRequest(V20PresRequest presRequest) {
            this.presRequest = presRequest;
            return (B)this.self();
        }

        public B pres(V20Pres pres) {
            this.pres = pres;
            return (B)this.self();
        }

        public B byFormat(V20PresExRecordByFormat byFormat) {
            this.byFormat = byFormat;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "V20PresExRecord.V20PresExRecordBuilder(super=" + super.toString() + ", presProposal=" + this.presProposal + ", presRequest=" + this.presRequest + ", pres=" + this.pres + ", byFormat=" + this.byFormat + ")";
        }
    }
}

