/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.DIDEndpoint;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof.ProofRequestPresentation;
import org.hyperledger.aries.config.GsonConfig;

public class ProofRequestPresentationBuilder {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final Gson gson = GsonConfig.defaultNoEscaping();
    private final AriesClient acaPy;

    public ProofRequestPresentationBuilder(AriesClient acaPy) {
        this.acaPy = acaPy;
    }

    public Optional<BuiltPresentationRequest> buildRequest(PresentProofRequest presentProofRequest) throws IOException {
        Optional<PresentationExchangeRecord> exchangeRecord;
        Optional<BuiltPresentationRequest> result = Optional.empty();
        String agentVerkey = "";
        String agentURI = "";
        Optional<DID> walletDidPublic = this.acaPy.walletDidPublic();
        if (walletDidPublic.isPresent()) {
            agentVerkey = walletDidPublic.get().getVerkey();
            String agentPublicDid = walletDidPublic.get().getDid();
            Optional<DIDEndpoint> agentEndpoint = this.acaPy.walletGetDidEndpoint(agentPublicDid);
            if (agentEndpoint.isPresent()) {
                agentURI = agentEndpoint.get().getEndpoint();
            }
        }
        if ((exchangeRecord = this.acaPy.presentProofCreateRequest(presentProofRequest)).isPresent()) {
            String requestJson = this.gson.toJson((Object)exchangeRecord.get().getPresentationRequest());
            byte[] proofRequestBase64 = Base64.getEncoder().encode(requestJson.getBytes(UTF_8));
            ProofRequestPresentation envelope = new ProofRequestPresentation(agentURI, agentVerkey, exchangeRecord.get().getThreadId(), new String(proofRequestBase64, UTF_8));
            byte[] envelopeBase64 = Base64.getEncoder().encode(this.gson.toJson((Object)envelope).getBytes(UTF_8));
            result = Optional.of(BuiltPresentationRequest.builder().presentationExchangeRecord(exchangeRecord.get()).envelopeBase64(new String(envelopeBase64, UTF_8)).build());
        }
        return result;
    }

    public static final class BuiltPresentationRequest {
        private String envelopeBase64;
        private PresentationExchangeRecord presentationExchangeRecord;

        BuiltPresentationRequest(String envelopeBase64, PresentationExchangeRecord presentationExchangeRecord) {
            this.envelopeBase64 = envelopeBase64;
            this.presentationExchangeRecord = presentationExchangeRecord;
        }

        public static BuiltPresentationRequestBuilder builder() {
            return new BuiltPresentationRequestBuilder();
        }

        public String getEnvelopeBase64() {
            return this.envelopeBase64;
        }

        public PresentationExchangeRecord getPresentationExchangeRecord() {
            return this.presentationExchangeRecord;
        }

        public void setEnvelopeBase64(String envelopeBase64) {
            this.envelopeBase64 = envelopeBase64;
        }

        public void setPresentationExchangeRecord(PresentationExchangeRecord presentationExchangeRecord) {
            this.presentationExchangeRecord = presentationExchangeRecord;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuiltPresentationRequest)) {
                return false;
            }
            BuiltPresentationRequest other = (BuiltPresentationRequest)o;
            String this$envelopeBase64 = this.getEnvelopeBase64();
            String other$envelopeBase64 = other.getEnvelopeBase64();
            if (this$envelopeBase64 == null ? other$envelopeBase64 != null : !this$envelopeBase64.equals(other$envelopeBase64)) {
                return false;
            }
            PresentationExchangeRecord this$presentationExchangeRecord = this.getPresentationExchangeRecord();
            PresentationExchangeRecord other$presentationExchangeRecord = other.getPresentationExchangeRecord();
            return !(this$presentationExchangeRecord == null ? other$presentationExchangeRecord != null : !((Object)this$presentationExchangeRecord).equals(other$presentationExchangeRecord));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $envelopeBase64 = this.getEnvelopeBase64();
            result = result * 59 + ($envelopeBase64 == null ? 43 : $envelopeBase64.hashCode());
            PresentationExchangeRecord $presentationExchangeRecord = this.getPresentationExchangeRecord();
            result = result * 59 + ($presentationExchangeRecord == null ? 43 : ((Object)$presentationExchangeRecord).hashCode());
            return result;
        }

        public String toString() {
            return "ProofRequestPresentationBuilder.BuiltPresentationRequest(envelopeBase64=" + this.getEnvelopeBase64() + ", presentationExchangeRecord=" + this.getPresentationExchangeRecord() + ")";
        }

        public static class BuiltPresentationRequestBuilder {
            private String envelopeBase64;
            private PresentationExchangeRecord presentationExchangeRecord;

            BuiltPresentationRequestBuilder() {
            }

            public BuiltPresentationRequestBuilder envelopeBase64(String envelopeBase64) {
                this.envelopeBase64 = envelopeBase64;
                return this;
            }

            public BuiltPresentationRequestBuilder presentationExchangeRecord(PresentationExchangeRecord presentationExchangeRecord) {
                this.presentationExchangeRecord = presentationExchangeRecord;
                return this;
            }

            public BuiltPresentationRequest build() {
                return new BuiltPresentationRequest(this.envelopeBase64, this.presentationExchangeRecord);
            }

            public String toString() {
                return "ProofRequestPresentationBuilder.BuiltPresentationRequest.BuiltPresentationRequestBuilder(envelopeBase64=" + this.envelopeBase64 + ", presentationExchangeRecord=" + this.presentationExchangeRecord + ")";
            }
        }
    }
}

