/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ProofRequestPresentation {
    @SerializedName(value="@id")
    private String id;
    @SerializedName(value="@type")
    private String type = "https://didcomm.org/present-proof/1.0/request-presentation";
    private String comment = "";
    @SerializedName(value="~service")
    private ServiceDecorator service;
    @SerializedName(value="request_presentations~attach")
    private List<PresentationAttachment> request;
    @SerializedName(value="~thread")
    private Thread thread;

    public ProofRequestPresentation(String ariesUri, String verkey, String threadId, String proofRequest) {
        this.id = threadId;
        this.service = new ServiceDecorator(ariesUri, verkey);
        this.request = List.of(new PresentationAttachment(proofRequest));
        this.thread = new Thread(threadId);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public ServiceDecorator getService() {
        return this.service;
    }

    public List<PresentationAttachment> getRequest() {
        return this.request;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setService(ServiceDecorator service) {
        this.service = service;
    }

    public void setRequest(List<PresentationAttachment> request) {
        this.request = request;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProofRequestPresentation)) {
            return false;
        }
        ProofRequestPresentation other = (ProofRequestPresentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        ServiceDecorator this$service = this.getService();
        ServiceDecorator other$service = other.getService();
        if (this$service == null ? other$service != null : !((Object)this$service).equals(other$service)) {
            return false;
        }
        List<PresentationAttachment> this$request = this.getRequest();
        List<PresentationAttachment> other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        Thread this$thread = this.getThread();
        Thread other$thread = other.getThread();
        return !(this$thread == null ? other$thread != null : !((Object)this$thread).equals(other$thread));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProofRequestPresentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        ServiceDecorator $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
        List<PresentationAttachment> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        Thread $thread = this.getThread();
        result = result * 59 + ($thread == null ? 43 : ((Object)$thread).hashCode());
        return result;
    }

    public String toString() {
        return "ProofRequestPresentation(id=" + this.getId() + ", type=" + this.getType() + ", comment=" + this.getComment() + ", service=" + this.getService() + ", request=" + this.getRequest() + ", thread=" + this.getThread() + ")";
    }

    public static class Thread {
        private String thid;
        private Integer senderOrder = 0;
        private Object receivedOrders;

        public Thread(String thid) {
            this.thid = thid;
        }

        public String getThid() {
            return this.thid;
        }

        public Integer getSenderOrder() {
            return this.senderOrder;
        }

        public Object getReceivedOrders() {
            return this.receivedOrders;
        }

        public void setThid(String thid) {
            this.thid = thid;
        }

        public void setSenderOrder(Integer senderOrder) {
            this.senderOrder = senderOrder;
        }

        public void setReceivedOrders(Object receivedOrders) {
            this.receivedOrders = receivedOrders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Thread)) {
                return false;
            }
            Thread other = (Thread)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$senderOrder = this.getSenderOrder();
            Integer other$senderOrder = other.getSenderOrder();
            if (this$senderOrder == null ? other$senderOrder != null : !((Object)this$senderOrder).equals(other$senderOrder)) {
                return false;
            }
            String this$thid = this.getThid();
            String other$thid = other.getThid();
            if (this$thid == null ? other$thid != null : !this$thid.equals(other$thid)) {
                return false;
            }
            Object this$receivedOrders = this.getReceivedOrders();
            Object other$receivedOrders = other.getReceivedOrders();
            return !(this$receivedOrders == null ? other$receivedOrders != null : !this$receivedOrders.equals(other$receivedOrders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Thread;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $senderOrder = this.getSenderOrder();
            result = result * 59 + ($senderOrder == null ? 43 : ((Object)$senderOrder).hashCode());
            String $thid = this.getThid();
            result = result * 59 + ($thid == null ? 43 : $thid.hashCode());
            Object $receivedOrders = this.getReceivedOrders();
            result = result * 59 + ($receivedOrders == null ? 43 : $receivedOrders.hashCode());
            return result;
        }

        public String toString() {
            return "ProofRequestPresentation.Thread(thid=" + this.getThid() + ", senderOrder=" + this.getSenderOrder() + ", receivedOrders=" + this.getReceivedOrders() + ")";
        }
    }

    public static class ServiceDecorator {
        @SerializedName(value="recipientKeys")
        private List<String> recipientKeys;
        @SerializedName(value="routingKeys")
        private List<String> routingKeys = List.of();
        @SerializedName(value="serviceEndpoint")
        private String serviceEndpoint;

        public ServiceDecorator(String ariesUri, String verkey) {
            this.serviceEndpoint = ariesUri;
            this.recipientKeys = List.of(verkey);
        }

        public static ServiceDecoratorBuilder builder() {
            return new ServiceDecoratorBuilder();
        }

        public List<String> getRecipientKeys() {
            return this.recipientKeys;
        }

        public List<String> getRoutingKeys() {
            return this.routingKeys;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public void setRecipientKeys(List<String> recipientKeys) {
            this.recipientKeys = recipientKeys;
        }

        public void setRoutingKeys(List<String> routingKeys) {
            this.routingKeys = routingKeys;
        }

        public void setServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceDecorator)) {
                return false;
            }
            ServiceDecorator other = (ServiceDecorator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$recipientKeys = this.getRecipientKeys();
            List<String> other$recipientKeys = other.getRecipientKeys();
            if (this$recipientKeys == null ? other$recipientKeys != null : !((Object)this$recipientKeys).equals(other$recipientKeys)) {
                return false;
            }
            List<String> this$routingKeys = this.getRoutingKeys();
            List<String> other$routingKeys = other.getRoutingKeys();
            if (this$routingKeys == null ? other$routingKeys != null : !((Object)this$routingKeys).equals(other$routingKeys)) {
                return false;
            }
            String this$serviceEndpoint = this.getServiceEndpoint();
            String other$serviceEndpoint = other.getServiceEndpoint();
            return !(this$serviceEndpoint == null ? other$serviceEndpoint != null : !this$serviceEndpoint.equals(other$serviceEndpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceDecorator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $recipientKeys = this.getRecipientKeys();
            result = result * 59 + ($recipientKeys == null ? 43 : ((Object)$recipientKeys).hashCode());
            List<String> $routingKeys = this.getRoutingKeys();
            result = result * 59 + ($routingKeys == null ? 43 : ((Object)$routingKeys).hashCode());
            String $serviceEndpoint = this.getServiceEndpoint();
            result = result * 59 + ($serviceEndpoint == null ? 43 : $serviceEndpoint.hashCode());
            return result;
        }

        public String toString() {
            return "ProofRequestPresentation.ServiceDecorator(recipientKeys=" + this.getRecipientKeys() + ", routingKeys=" + this.getRoutingKeys() + ", serviceEndpoint=" + this.getServiceEndpoint() + ")";
        }

        public ServiceDecorator() {
        }

        public ServiceDecorator(List<String> recipientKeys, List<String> routingKeys, String serviceEndpoint) {
            this.recipientKeys = recipientKeys;
            this.routingKeys = routingKeys;
            this.serviceEndpoint = serviceEndpoint;
        }

        public static class ServiceDecoratorBuilder {
            private List<String> recipientKeys;
            private List<String> routingKeys;
            private String serviceEndpoint;

            ServiceDecoratorBuilder() {
            }

            public ServiceDecoratorBuilder recipientKeys(List<String> recipientKeys) {
                this.recipientKeys = recipientKeys;
                return this;
            }

            public ServiceDecoratorBuilder routingKeys(List<String> routingKeys) {
                this.routingKeys = routingKeys;
                return this;
            }

            public ServiceDecoratorBuilder serviceEndpoint(String serviceEndpoint) {
                this.serviceEndpoint = serviceEndpoint;
                return this;
            }

            public ServiceDecorator build() {
                return new ServiceDecorator(this.recipientKeys, this.routingKeys, this.serviceEndpoint);
            }

            public String toString() {
                return "ProofRequestPresentation.ServiceDecorator.ServiceDecoratorBuilder(recipientKeys=" + this.recipientKeys + ", routingKeys=" + this.routingKeys + ", serviceEndpoint=" + this.serviceEndpoint + ")";
            }
        }
    }

    public static class PresentationAttachment {
        @SerializedName(value="@id")
        private String id = "libindy-request-presentation-0";
        @SerializedName(value="mime-type")
        private String mimeType = "application/json";
        private Map<String, String> data;

        public PresentationAttachment(String proofRequest) {
            this.data = Map.of("base64", proofRequest);
        }

        public String getId() {
            return this.id;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PresentationAttachment)) {
                return false;
            }
            PresentationAttachment other = (PresentationAttachment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Map<String, String> this$data = this.getData();
            Map<String, String> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PresentationAttachment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Map<String, String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "ProofRequestPresentation.PresentationAttachment(id=" + this.getId() + ", mimeType=" + this.getMimeType() + ", data=" + this.getData() + ")";
        }
    }
}

