/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.api.AcaPyRequestFilter;

public class PresentationRequestCredentialsFilter
implements AcaPyRequestFilter {
    private String count;
    private String extraQuery;
    private List<String> referent;
    private String start;

    @Override
    public HttpUrl.Builder buildParams(@NonNull HttpUrl.Builder b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.count)) {
            b.addQueryParameter("count", this.count);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.extraQuery)) {
            b.addQueryParameter("extra_query", this.extraQuery);
        }
        if (this.referent != null && this.referent.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.referent.stream().iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            b.addQueryParameter("referent", sb.toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.start)) {
            b.addQueryParameter("start", this.start);
        }
        return b;
    }

    PresentationRequestCredentialsFilter(String count, String extraQuery, List<String> referent, String start) {
        this.count = count;
        this.extraQuery = extraQuery;
        this.referent = referent;
        this.start = start;
    }

    public static PresentationRequestCredentialsFilterBuilder builder() {
        return new PresentationRequestCredentialsFilterBuilder();
    }

    public String getCount() {
        return this.count;
    }

    public String getExtraQuery() {
        return this.extraQuery;
    }

    public List<String> getReferent() {
        return this.referent;
    }

    public String getStart() {
        return this.start;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public void setExtraQuery(String extraQuery) {
        this.extraQuery = extraQuery;
    }

    public void setReferent(List<String> referent) {
        this.referent = referent;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresentationRequestCredentialsFilter)) {
            return false;
        }
        PresentationRequestCredentialsFilter other = (PresentationRequestCredentialsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$count = this.getCount();
        String other$count = other.getCount();
        if (this$count == null ? other$count != null : !this$count.equals(other$count)) {
            return false;
        }
        String this$extraQuery = this.getExtraQuery();
        String other$extraQuery = other.getExtraQuery();
        if (this$extraQuery == null ? other$extraQuery != null : !this$extraQuery.equals(other$extraQuery)) {
            return false;
        }
        List<String> this$referent = this.getReferent();
        List<String> other$referent = other.getReferent();
        if (this$referent == null ? other$referent != null : !((Object)this$referent).equals(other$referent)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        return !(this$start == null ? other$start != null : !this$start.equals(other$start));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PresentationRequestCredentialsFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : $count.hashCode());
        String $extraQuery = this.getExtraQuery();
        result = result * 59 + ($extraQuery == null ? 43 : $extraQuery.hashCode());
        List<String> $referent = this.getReferent();
        result = result * 59 + ($referent == null ? 43 : ((Object)$referent).hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        return result;
    }

    public String toString() {
        return "PresentationRequestCredentialsFilter(count=" + this.getCount() + ", extraQuery=" + this.getExtraQuery() + ", referent=" + this.getReferent() + ", start=" + this.getStart() + ")";
    }

    public static class PresentationRequestCredentialsFilterBuilder {
        private String count;
        private String extraQuery;
        private List<String> referent;
        private String start;

        PresentationRequestCredentialsFilterBuilder() {
        }

        public PresentationRequestCredentialsFilterBuilder count(String count) {
            this.count = count;
            return this;
        }

        public PresentationRequestCredentialsFilterBuilder extraQuery(String extraQuery) {
            this.extraQuery = extraQuery;
            return this;
        }

        public PresentationRequestCredentialsFilterBuilder referent(List<String> referent) {
            this.referent = referent;
            return this;
        }

        public PresentationRequestCredentialsFilterBuilder start(String start) {
            this.start = start;
            return this;
        }

        public PresentationRequestCredentialsFilter build() {
            return new PresentationRequestCredentialsFilter(this.count, this.extraQuery, this.referent, this.start);
        }

        public String toString() {
            return "PresentationRequestCredentialsFilter.PresentationRequestCredentialsFilterBuilder(count=" + this.count + ", extraQuery=" + this.extraQuery + ", referent=" + this.referent + ", start=" + this.start + ")";
        }
    }
}

