/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof.PresentationRequest;
import org.hyperledger.aries.api.present_proof.PresentationRequestCredentials;
import org.jetbrains.annotations.NotNull;

public class PresentationRequestBuilder {
    public static Optional<PresentationRequest> acceptAll(@NonNull PresentationExchangeRecord presentationExchange, @NonNull List<PresentationRequestCredentials> matchingCredentials) {
        if (presentationExchange == null) {
            throw new NullPointerException("presentationExchange is marked non-null but is null");
        }
        if (matchingCredentials == null) {
            throw new NullPointerException("matchingCredentials is marked non-null but is null");
        }
        Optional<PresentationRequest> result = Optional.empty();
        Map<String, PresentationRequest.IndyRequestedCredsRequestedAttr> requestedAttributes = PresentationRequestBuilder.buildRequestedAttributes(presentationExchange, matchingCredentials);
        Map<String, PresentationRequest.IndyRequestedCredsRequestedPred> requestedPredicates = PresentationRequestBuilder.buildRequestedPredicates(presentationExchange, matchingCredentials);
        if (!requestedAttributes.isEmpty() || !requestedPredicates.isEmpty()) {
            result = Optional.of(PresentationRequest.builder().requestedAttributes(requestedAttributes).requestedPredicates(requestedPredicates).build());
        }
        return result;
    }

    private static Map<String, PresentationRequest.IndyRequestedCredsRequestedAttr> buildRequestedAttributes(@NonNull PresentationExchangeRecord presentationExchange, @NonNull List<PresentationRequestCredentials> matchingCredentials) {
        if (presentationExchange == null) {
            throw new NullPointerException("presentationExchange is marked non-null but is null");
        }
        if (matchingCredentials == null) {
            throw new NullPointerException("matchingCredentials is marked non-null but is null");
        }
        LinkedHashMap<String, PresentationRequest.IndyRequestedCredsRequestedAttr> result = new LinkedHashMap<String, PresentationRequest.IndyRequestedCredsRequestedAttr>();
        PresentProofRequest.ProofRequest presentationRequest = presentationExchange.getPresentationRequest();
        if (presentationRequest != null && presentationRequest.getRequestedAttributes() != null) {
            Set<String> requestedReferents = presentationRequest.getRequestedAttributes().keySet();
            requestedReferents.forEach(ref -> PresentationRequestBuilder.matchReferent(matchingCredentials, ref).ifPresent(match -> result.put((String)ref, PresentationRequest.IndyRequestedCredsRequestedAttr.builder().credId((String)match).revealed(Boolean.TRUE).build())));
        }
        return result;
    }

    private static Map<String, PresentationRequest.IndyRequestedCredsRequestedPred> buildRequestedPredicates(@NonNull PresentationExchangeRecord presentationExchange, @NonNull List<PresentationRequestCredentials> matchingCredentials) {
        if (presentationExchange == null) {
            throw new NullPointerException("presentationExchange is marked non-null but is null");
        }
        if (matchingCredentials == null) {
            throw new NullPointerException("matchingCredentials is marked non-null but is null");
        }
        LinkedHashMap<String, PresentationRequest.IndyRequestedCredsRequestedPred> result = new LinkedHashMap<String, PresentationRequest.IndyRequestedCredsRequestedPred>();
        PresentProofRequest.ProofRequest presentationRequest = presentationExchange.getPresentationRequest();
        if (presentationRequest != null && presentationRequest.getRequestedPredicates() != null) {
            Set<String> requestedReferents = presentationRequest.getRequestedPredicates().keySet();
            requestedReferents.forEach(ref -> PresentationRequestBuilder.matchReferent(matchingCredentials, ref).ifPresent(match -> result.put((String)ref, PresentationRequest.IndyRequestedCredsRequestedPred.builder().credId((String)match).build())));
        }
        return result;
    }

    private static Optional<String> matchReferent(@NotNull List<PresentationRequestCredentials> matchingCredentials, String ref) {
        return matchingCredentials.stream().filter(cred -> cred.getPresentationReferents().contains(ref)).map(PresentationRequestCredentials::getCredentialInfo).map(PresentationRequestCredentials.CredentialInfo::getReferent).findFirst();
    }
}

