/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.hyperledger.aries.api.ExchangeVersion;
import org.hyperledger.aries.api.present_proof.BasePresExRecord;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.serializer.JsonObjectDeserializer;
import org.hyperledger.aries.api.serializer.JsonObjectSerializer;
import org.hyperledger.aries.webhook.EventParser;

public class PresentationExchangeRecord
extends BasePresExRecord {
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject presentationProposalDict;
    private PresentProofRequest.ProofRequest presentationRequest;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject presentationRequestDict;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject presentation;
    private List<Identifier> identifiers;
    private transient ExchangeVersion version;

    public boolean hasCredentialDefinitionId(@NonNull String credentialDefinitionId) {
        if (credentialDefinitionId == null) {
            throw new NullPointerException("credentialDefinitionId is marked non-null but is null");
        }
        if (this.identifiers != null) {
            return this.identifiers.stream().anyMatch(i -> credentialDefinitionId.equals(i.getCredentialDefinitionId()));
        }
        return false;
    }

    public boolean hasSchemaId(@NonNull String schemaId) {
        if (schemaId == null) {
            throw new NullPointerException("schemaId is marked non-null but is null");
        }
        if (this.identifiers != null) {
            return this.identifiers.stream().anyMatch(i -> schemaId.equals(i.getSchemaId()));
        }
        return false;
    }

    public JsonObject getPresentation() {
        if (this.presentation == null) {
            return new JsonObject();
        }
        return this.presentation;
    }

    public <T> T from(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return EventParser.from(this.presentation.toString(), type);
    }

    public Map<String, Object> from(@NonNull Set<String> names) {
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return EventParser.from(this.presentation.toString(), names);
    }

    public Map<String, RevealedAttributeGroup> findRevealedAttributeGroups() {
        return EventParser.getValuesByAttributeGroup(this.presentation.toString());
    }

    public Map<String, Object> findRevealedAttributes() {
        return EventParser.getValuesByRevealedAttributes(this.presentation.toString());
    }

    public Map<String, RevealedAttribute> findRevealedAttributedFull() {
        return EventParser.getValuesByRevealedAttributesFull(this.presentation.toString());
    }

    @Override
    @JsonIgnore
    public ExchangeVersion getVersion() {
        return this.version == null ? ExchangeVersion.V1 : this.version;
    }

    protected PresentationExchangeRecord(PresentationExchangeRecordBuilder<?, ?> b) {
        super(b);
        this.presentationProposalDict = b.presentationProposalDict;
        this.presentationRequest = b.presentationRequest;
        this.presentationRequestDict = b.presentationRequestDict;
        this.presentation = b.presentation;
        this.identifiers = b.identifiers;
        this.version = b.version;
    }

    public static PresentationExchangeRecordBuilder<?, ?> builder() {
        return new PresentationExchangeRecordBuilderImpl();
    }

    public JsonObject getPresentationProposalDict() {
        return this.presentationProposalDict;
    }

    public PresentProofRequest.ProofRequest getPresentationRequest() {
        return this.presentationRequest;
    }

    public JsonObject getPresentationRequestDict() {
        return this.presentationRequestDict;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonDeserialize(using=JsonObjectDeserializer.class)
    public void setPresentationProposalDict(JsonObject presentationProposalDict) {
        this.presentationProposalDict = presentationProposalDict;
    }

    public void setPresentationRequest(PresentProofRequest.ProofRequest presentationRequest) {
        this.presentationRequest = presentationRequest;
    }

    @JsonDeserialize(using=JsonObjectDeserializer.class)
    public void setPresentationRequestDict(JsonObject presentationRequestDict) {
        this.presentationRequestDict = presentationRequestDict;
    }

    @JsonDeserialize(using=JsonObjectDeserializer.class)
    public void setPresentation(JsonObject presentation) {
        this.presentation = presentation;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void setVersion(ExchangeVersion version) {
        this.version = version;
    }

    public PresentationExchangeRecord() {
    }

    public PresentationExchangeRecord(JsonObject presentationProposalDict, PresentProofRequest.ProofRequest presentationRequest, JsonObject presentationRequestDict, JsonObject presentation, List<Identifier> identifiers, ExchangeVersion version) {
        this.presentationProposalDict = presentationProposalDict;
        this.presentationRequest = presentationRequest;
        this.presentationRequestDict = presentationRequestDict;
        this.presentation = presentation;
        this.identifiers = identifiers;
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresentationExchangeRecord)) {
            return false;
        }
        PresentationExchangeRecord other = (PresentationExchangeRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonObject this$presentationProposalDict = this.getPresentationProposalDict();
        JsonObject other$presentationProposalDict = other.getPresentationProposalDict();
        if (this$presentationProposalDict == null ? other$presentationProposalDict != null : !this$presentationProposalDict.equals(other$presentationProposalDict)) {
            return false;
        }
        PresentProofRequest.ProofRequest this$presentationRequest = this.getPresentationRequest();
        PresentProofRequest.ProofRequest other$presentationRequest = other.getPresentationRequest();
        if (this$presentationRequest == null ? other$presentationRequest != null : !((Object)this$presentationRequest).equals(other$presentationRequest)) {
            return false;
        }
        JsonObject this$presentationRequestDict = this.getPresentationRequestDict();
        JsonObject other$presentationRequestDict = other.getPresentationRequestDict();
        if (this$presentationRequestDict == null ? other$presentationRequestDict != null : !this$presentationRequestDict.equals(other$presentationRequestDict)) {
            return false;
        }
        JsonObject this$presentation = this.getPresentation();
        JsonObject other$presentation = other.getPresentation();
        if (this$presentation == null ? other$presentation != null : !this$presentation.equals(other$presentation)) {
            return false;
        }
        List<Identifier> this$identifiers = this.getIdentifiers();
        List<Identifier> other$identifiers = other.getIdentifiers();
        return !(this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PresentationExchangeRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JsonObject $presentationProposalDict = this.getPresentationProposalDict();
        result = result * 59 + ($presentationProposalDict == null ? 43 : $presentationProposalDict.hashCode());
        PresentProofRequest.ProofRequest $presentationRequest = this.getPresentationRequest();
        result = result * 59 + ($presentationRequest == null ? 43 : ((Object)$presentationRequest).hashCode());
        JsonObject $presentationRequestDict = this.getPresentationRequestDict();
        result = result * 59 + ($presentationRequestDict == null ? 43 : $presentationRequestDict.hashCode());
        JsonObject $presentation = this.getPresentation();
        result = result * 59 + ($presentation == null ? 43 : $presentation.hashCode());
        List<Identifier> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PresentationExchangeRecord(super=" + super.toString() + ", presentationProposalDict=" + this.getPresentationProposalDict() + ", presentationRequest=" + this.getPresentationRequest() + ", presentationRequestDict=" + this.getPresentationRequestDict() + ", presentation=" + this.getPresentation() + ", identifiers=" + this.getIdentifiers() + ", version=" + this.getVersion() + ")";
    }

    private static final class PresentationExchangeRecordBuilderImpl
    extends PresentationExchangeRecordBuilder<PresentationExchangeRecord, PresentationExchangeRecordBuilderImpl> {
        private PresentationExchangeRecordBuilderImpl() {
        }

        @Override
        protected PresentationExchangeRecordBuilderImpl self() {
            return this;
        }

        @Override
        public PresentationExchangeRecord build() {
            return new PresentationExchangeRecord(this);
        }
    }

    public static abstract class PresentationExchangeRecordBuilder<C extends PresentationExchangeRecord, B extends PresentationExchangeRecordBuilder<C, B>>
    extends BasePresExRecord.BasePresExRecordBuilder<C, B> {
        private JsonObject presentationProposalDict;
        private PresentProofRequest.ProofRequest presentationRequest;
        private JsonObject presentationRequestDict;
        private JsonObject presentation;
        private List<Identifier> identifiers;
        private ExchangeVersion version;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonDeserialize(using=JsonObjectDeserializer.class)
        public B presentationProposalDict(JsonObject presentationProposalDict) {
            this.presentationProposalDict = presentationProposalDict;
            return (B)this.self();
        }

        public B presentationRequest(PresentProofRequest.ProofRequest presentationRequest) {
            this.presentationRequest = presentationRequest;
            return (B)this.self();
        }

        @JsonDeserialize(using=JsonObjectDeserializer.class)
        public B presentationRequestDict(JsonObject presentationRequestDict) {
            this.presentationRequestDict = presentationRequestDict;
            return (B)this.self();
        }

        @JsonDeserialize(using=JsonObjectDeserializer.class)
        public B presentation(JsonObject presentation) {
            this.presentation = presentation;
            return (B)this.self();
        }

        public B identifiers(List<Identifier> identifiers) {
            this.identifiers = identifiers;
            return (B)this.self();
        }

        public B version(ExchangeVersion version) {
            this.version = version;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PresentationExchangeRecord.PresentationExchangeRecordBuilder(super=" + super.toString() + ", presentationProposalDict=" + this.presentationProposalDict + ", presentationRequest=" + this.presentationRequest + ", presentationRequestDict=" + this.presentationRequestDict + ", presentation=" + this.presentation + ", identifiers=" + this.identifiers + ", version=" + this.version + ")";
        }
    }

    public static class RevealedAttribute {
        private Integer subProofIndex;
        private String raw;
        private String encoded;

        public static RevealedAttributeBuilder builder() {
            return new RevealedAttributeBuilder();
        }

        public Integer getSubProofIndex() {
            return this.subProofIndex;
        }

        public String getRaw() {
            return this.raw;
        }

        public String getEncoded() {
            return this.encoded;
        }

        public void setSubProofIndex(Integer subProofIndex) {
            this.subProofIndex = subProofIndex;
        }

        public void setRaw(String raw) {
            this.raw = raw;
        }

        public void setEncoded(String encoded) {
            this.encoded = encoded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevealedAttribute)) {
                return false;
            }
            RevealedAttribute other = (RevealedAttribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$subProofIndex = this.getSubProofIndex();
            Integer other$subProofIndex = other.getSubProofIndex();
            if (this$subProofIndex == null ? other$subProofIndex != null : !((Object)this$subProofIndex).equals(other$subProofIndex)) {
                return false;
            }
            String this$raw = this.getRaw();
            String other$raw = other.getRaw();
            if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
                return false;
            }
            String this$encoded = this.getEncoded();
            String other$encoded = other.getEncoded();
            return !(this$encoded == null ? other$encoded != null : !this$encoded.equals(other$encoded));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RevealedAttribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $subProofIndex = this.getSubProofIndex();
            result = result * 59 + ($subProofIndex == null ? 43 : ((Object)$subProofIndex).hashCode());
            String $raw = this.getRaw();
            result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
            String $encoded = this.getEncoded();
            result = result * 59 + ($encoded == null ? 43 : $encoded.hashCode());
            return result;
        }

        public String toString() {
            return "PresentationExchangeRecord.RevealedAttribute(subProofIndex=" + this.getSubProofIndex() + ", raw=" + this.getRaw() + ", encoded=" + this.getEncoded() + ")";
        }

        public RevealedAttribute() {
        }

        public RevealedAttribute(Integer subProofIndex, String raw, String encoded) {
            this.subProofIndex = subProofIndex;
            this.raw = raw;
            this.encoded = encoded;
        }

        public static class RevealedAttributeBuilder {
            private Integer subProofIndex;
            private String raw;
            private String encoded;

            RevealedAttributeBuilder() {
            }

            public RevealedAttributeBuilder subProofIndex(Integer subProofIndex) {
                this.subProofIndex = subProofIndex;
                return this;
            }

            public RevealedAttributeBuilder raw(String raw) {
                this.raw = raw;
                return this;
            }

            public RevealedAttributeBuilder encoded(String encoded) {
                this.encoded = encoded;
                return this;
            }

            public RevealedAttribute build() {
                return new RevealedAttribute(this.subProofIndex, this.raw, this.encoded);
            }

            public String toString() {
                return "PresentationExchangeRecord.RevealedAttribute.RevealedAttributeBuilder(subProofIndex=" + this.subProofIndex + ", raw=" + this.raw + ", encoded=" + this.encoded + ")";
            }
        }
    }

    public static class RevealedAttributeGroup {
        private Map<String, String> revealedAttributes;
        private Identifier identifier;

        public static RevealedAttributeGroupBuilder builder() {
            return new RevealedAttributeGroupBuilder();
        }

        public Map<String, String> getRevealedAttributes() {
            return this.revealedAttributes;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public void setRevealedAttributes(Map<String, String> revealedAttributes) {
            this.revealedAttributes = revealedAttributes;
        }

        public void setIdentifier(Identifier identifier) {
            this.identifier = identifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevealedAttributeGroup)) {
                return false;
            }
            RevealedAttributeGroup other = (RevealedAttributeGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$revealedAttributes = this.getRevealedAttributes();
            Map<String, String> other$revealedAttributes = other.getRevealedAttributes();
            if (this$revealedAttributes == null ? other$revealedAttributes != null : !((Object)this$revealedAttributes).equals(other$revealedAttributes)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RevealedAttributeGroup;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $revealedAttributes = this.getRevealedAttributes();
            result = result * 59 + ($revealedAttributes == null ? 43 : ((Object)$revealedAttributes).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
            return result;
        }

        public String toString() {
            return "PresentationExchangeRecord.RevealedAttributeGroup(revealedAttributes=" + this.getRevealedAttributes() + ", identifier=" + this.getIdentifier() + ")";
        }

        public RevealedAttributeGroup() {
        }

        public RevealedAttributeGroup(Map<String, String> revealedAttributes, Identifier identifier) {
            this.revealedAttributes = revealedAttributes;
            this.identifier = identifier;
        }

        public static class RevealedAttributeGroupBuilder {
            private ArrayList<String> revealedAttributes$key;
            private ArrayList<String> revealedAttributes$value;
            private Identifier identifier;

            RevealedAttributeGroupBuilder() {
            }

            public RevealedAttributeGroupBuilder revealedAttribute(String revealedAttributeKey, String revealedAttributeValue) {
                if (this.revealedAttributes$key == null) {
                    this.revealedAttributes$key = new ArrayList();
                    this.revealedAttributes$value = new ArrayList();
                }
                this.revealedAttributes$key.add(revealedAttributeKey);
                this.revealedAttributes$value.add(revealedAttributeValue);
                return this;
            }

            public RevealedAttributeGroupBuilder revealedAttributes(Map<? extends String, ? extends String> revealedAttributes) {
                if (revealedAttributes == null) {
                    throw new NullPointerException("revealedAttributes cannot be null");
                }
                if (this.revealedAttributes$key == null) {
                    this.revealedAttributes$key = new ArrayList();
                    this.revealedAttributes$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends String> $lombokEntry : revealedAttributes.entrySet()) {
                    this.revealedAttributes$key.add($lombokEntry.getKey());
                    this.revealedAttributes$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public RevealedAttributeGroupBuilder clearRevealedAttributes() {
                if (this.revealedAttributes$key != null) {
                    this.revealedAttributes$key.clear();
                    this.revealedAttributes$value.clear();
                }
                return this;
            }

            public RevealedAttributeGroupBuilder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public RevealedAttributeGroup build() {
                Map<String, String> revealedAttributes;
                switch (this.revealedAttributes$key == null ? 0 : this.revealedAttributes$key.size()) {
                    case 0: {
                        revealedAttributes = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        revealedAttributes = Collections.singletonMap(this.revealedAttributes$key.get(0), this.revealedAttributes$value.get(0));
                        break;
                    }
                    default: {
                        revealedAttributes = new LinkedHashMap<String, String>(this.revealedAttributes$key.size() < 0x40000000 ? 1 + this.revealedAttributes$key.size() + (this.revealedAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.revealedAttributes$key.size(); ++$i) {
                            revealedAttributes.put(this.revealedAttributes$key.get($i), this.revealedAttributes$value.get($i));
                        }
                        revealedAttributes = Collections.unmodifiableMap(revealedAttributes);
                    }
                }
                return new RevealedAttributeGroup(revealedAttributes, this.identifier);
            }

            public String toString() {
                return "PresentationExchangeRecord.RevealedAttributeGroup.RevealedAttributeGroupBuilder(revealedAttributes$key=" + this.revealedAttributes$key + ", revealedAttributes$value=" + this.revealedAttributes$value + ", identifier=" + this.identifier + ")";
            }
        }
    }

    public static class Identifier {
        private String schemaId;
        @SerializedName(value="cred_def_id", alternate={"credential_definition_id"})
        private String credentialDefinitionId;
        private String revRegId;
        private String timestamp;

        public static IdentifierBuilder builder() {
            return new IdentifierBuilder();
        }

        public String getSchemaId() {
            return this.schemaId;
        }

        public String getCredentialDefinitionId() {
            return this.credentialDefinitionId;
        }

        public String getRevRegId() {
            return this.revRegId;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        public void setCredentialDefinitionId(String credentialDefinitionId) {
            this.credentialDefinitionId = credentialDefinitionId;
        }

        public void setRevRegId(String revRegId) {
            this.revRegId = revRegId;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$schemaId = this.getSchemaId();
            String other$schemaId = other.getSchemaId();
            if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                return false;
            }
            String this$credentialDefinitionId = this.getCredentialDefinitionId();
            String other$credentialDefinitionId = other.getCredentialDefinitionId();
            if (this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId)) {
                return false;
            }
            String this$revRegId = this.getRevRegId();
            String other$revRegId = other.getRevRegId();
            if (this$revRegId == null ? other$revRegId != null : !this$revRegId.equals(other$revRegId)) {
                return false;
            }
            String this$timestamp = this.getTimestamp();
            String other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Identifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $schemaId = this.getSchemaId();
            result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
            String $credentialDefinitionId = this.getCredentialDefinitionId();
            result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
            String $revRegId = this.getRevRegId();
            result = result * 59 + ($revRegId == null ? 43 : $revRegId.hashCode());
            String $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
            return result;
        }

        public String toString() {
            return "PresentationExchangeRecord.Identifier(schemaId=" + this.getSchemaId() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ", revRegId=" + this.getRevRegId() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public Identifier() {
        }

        public Identifier(String schemaId, String credentialDefinitionId, String revRegId, String timestamp) {
            this.schemaId = schemaId;
            this.credentialDefinitionId = credentialDefinitionId;
            this.revRegId = revRegId;
            this.timestamp = timestamp;
        }

        public static class IdentifierBuilder {
            private String schemaId;
            private String credentialDefinitionId;
            private String revRegId;
            private String timestamp;

            IdentifierBuilder() {
            }

            public IdentifierBuilder schemaId(String schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            public IdentifierBuilder credentialDefinitionId(String credentialDefinitionId) {
                this.credentialDefinitionId = credentialDefinitionId;
                return this;
            }

            public IdentifierBuilder revRegId(String revRegId) {
                this.revRegId = revRegId;
                return this;
            }

            public IdentifierBuilder timestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Identifier build() {
                return new Identifier(this.schemaId, this.credentialDefinitionId, this.revRegId, this.timestamp);
            }

            public String toString() {
                return "PresentationExchangeRecord.Identifier.IdentifierBuilder(schemaId=" + this.schemaId + ", credentialDefinitionId=" + this.credentialDefinitionId + ", revRegId=" + this.revRegId + ", timestamp=" + this.timestamp + ")";
            }
        }
    }
}

