/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.pojo.PojoProcessor;
import org.jetbrains.annotations.NotNull;

public class PresentProofRequestHelper {
    public static PresentProofRequest buildForEachAttribute(String connectionId, @NonNull Set<String> attributes, @NonNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (restrictions == null) {
            throw new NullPointerException("restrictions is marked non-null but is null");
        }
        LinkedHashMap attr = new LinkedHashMap();
        attributes.forEach(name -> attr.put(name, PresentProofRequest.ProofRequest.ProofRequestedAttributes.builder().name((String)name).restrictions(restrictions.stream().map(PresentProofRequest.ProofRequest.ProofRestrictions::toJsonObject).collect(Collectors.toList())).build()));
        return PresentProofRequest.builder().proofRequest(PresentProofRequest.ProofRequest.builder().requestedAttributes(attr).build()).connectionId(connectionId).build();
    }

    public static PresentProofRequest buildForEachAttribute(String connectionId, @NonNull Set<String> attributes, PresentProofRequest.ProofRequest.ProofRestrictions restrictions) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForEachAttribute(connectionId, attributes, restrictions != null ? List.of(restrictions) : List.of());
    }

    public static <T> PresentProofRequest buildForEachAttribute(String connectionId, @NonNull Class<T> attributes, @Nullable List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForEachAttribute(connectionId, PojoProcessor.fieldNames(attributes), restrictions != null ? restrictions : List.of());
    }

    public static <T> PresentProofRequest buildForEachAttribute(String connectionId, @NonNull Class<T> attributes, @Nullable PresentProofRequest.ProofRequest.ProofRestrictions restrictions) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForEachAttribute(connectionId, PojoProcessor.fieldNames(attributes), restrictions);
    }

    public static PresentProofRequest buildForAllAttributes(String connectionId, @NonNull Set<String> attributes, @NonNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (restrictions == null) {
            throw new NullPointerException("restrictions is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForAllAttributes(connectionId, null, attributes, restrictions, null);
    }

    public static PresentProofRequest buildForAllAttributes(String connectionId, String attributeGroupName, @NonNull Set<String> attributes, @NonNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions, PresentProofRequest.ProofRequest.ProofNonRevoked nonRevoked) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (restrictions == null) {
            throw new NullPointerException("restrictions is marked non-null but is null");
        }
        PresentProofRequest.ProofRequest.ProofRequestedAttributes attr = PresentProofRequestHelper.buildAttributeForAll(attributes, restrictions, nonRevoked);
        return PresentProofRequestHelper.buildProofRequest(connectionId, Map.of(StringUtils.isEmpty((CharSequence)attributeGroupName) ? "attribute_group_0" : attributeGroupName, attr));
    }

    public static <T> PresentProofRequest buildForAllAttributes(String connectionId, @NonNull Class<T> type, @NonNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (restrictions == null) {
            throw new NullPointerException("restrictions is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForAllAttributes(connectionId, PojoProcessor.getAttributeGroupName(type), PojoProcessor.fieldNames(type), restrictions, null);
    }

    public static <T> PresentProofRequest buildForAllAttributes(String connectionId, @NonNull Class<T> type, @NonNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions, PresentProofRequest.ProofRequest.ProofNonRevoked nonRevoked) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (restrictions == null) {
            throw new NullPointerException("restrictions is marked non-null but is null");
        }
        return PresentProofRequestHelper.buildForAllAttributes(connectionId, PojoProcessor.getAttributeGroupName(type), PojoProcessor.fieldNames(type), restrictions, nonRevoked);
    }

    public static PresentProofRequest.ProofRequest.ProofRequestedAttributes buildAttributeForAll(@NotNull Set<String> attributes, @NotNull List<PresentProofRequest.ProofRequest.ProofRestrictions> restrictions, PresentProofRequest.ProofRequest.ProofNonRevoked nonRevoked) {
        return PresentProofRequest.ProofRequest.ProofRequestedAttributes.builder().names(List.copyOf(attributes)).nonRevoked(nonRevoked).restrictions(restrictions.size() > 0 ? (Collection)restrictions.stream().map(PresentProofRequest.ProofRequest.ProofRestrictions::toJsonObject).collect(Collectors.toList()) : List.of(PresentProofRequest.ProofRequest.ProofRestrictions.builder().build().toJsonObject())).build();
    }

    public static PresentProofRequest buildProofRequest(String connectionId, @NonNull Map<String, PresentProofRequest.ProofRequest.ProofRequestedAttributes> attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs is marked non-null but is null");
        }
        return PresentProofRequest.builder().proofRequest(PresentProofRequest.ProofRequest.builder().requestedAttributes(attrs).build()).connectionId(connectionId).build();
    }
}

