/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.hyperledger.acy_py.generated.model.IndyProofReqPredSpec;
import org.hyperledger.aries.api.serializer.JsonObjectArrayDeserializer;
import org.hyperledger.aries.api.serializer.JsonObjectArraySerializer;
import org.hyperledger.aries.config.GsonConfig;

public class PresentProofRequest {
    private Boolean autoVerify;
    private String comment;
    private String connectionId;
    @NonNull
    private ProofRequest proofRequest;
    private Boolean trace;

    public static PresentProofRequestBuilder builder() {
        return new PresentProofRequestBuilder();
    }

    public Boolean getAutoVerify() {
        return this.autoVerify;
    }

    public String getComment() {
        return this.comment;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @NonNull
    public ProofRequest getProofRequest() {
        return this.proofRequest;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public void setAutoVerify(Boolean autoVerify) {
        this.autoVerify = autoVerify;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setProofRequest(@NonNull ProofRequest proofRequest) {
        if (proofRequest == null) {
            throw new NullPointerException("proofRequest is marked non-null but is null");
        }
        this.proofRequest = proofRequest;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresentProofRequest)) {
            return false;
        }
        PresentProofRequest other = (PresentProofRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoVerify = this.getAutoVerify();
        Boolean other$autoVerify = other.getAutoVerify();
        if (this$autoVerify == null ? other$autoVerify != null : !((Object)this$autoVerify).equals(other$autoVerify)) {
            return false;
        }
        Boolean this$trace = this.getTrace();
        Boolean other$trace = other.getTrace();
        if (this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        ProofRequest this$proofRequest = this.getProofRequest();
        ProofRequest other$proofRequest = other.getProofRequest();
        return !(this$proofRequest == null ? other$proofRequest != null : !((Object)this$proofRequest).equals(other$proofRequest));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PresentProofRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoVerify = this.getAutoVerify();
        result = result * 59 + ($autoVerify == null ? 43 : ((Object)$autoVerify).hashCode());
        Boolean $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        ProofRequest $proofRequest = this.getProofRequest();
        result = result * 59 + ($proofRequest == null ? 43 : ((Object)$proofRequest).hashCode());
        return result;
    }

    public String toString() {
        return "PresentProofRequest(autoVerify=" + this.getAutoVerify() + ", comment=" + this.getComment() + ", connectionId=" + this.getConnectionId() + ", proofRequest=" + this.getProofRequest() + ", trace=" + this.getTrace() + ")";
    }

    public PresentProofRequest() {
    }

    public PresentProofRequest(Boolean autoVerify, String comment, String connectionId, @NonNull ProofRequest proofRequest, Boolean trace) {
        if (proofRequest == null) {
            throw new NullPointerException("proofRequest is marked non-null but is null");
        }
        this.autoVerify = autoVerify;
        this.comment = comment;
        this.connectionId = connectionId;
        this.proofRequest = proofRequest;
        this.trace = trace;
    }

    public static class PresentProofRequestBuilder {
        private Boolean autoVerify;
        private String comment;
        private String connectionId;
        private ProofRequest proofRequest;
        private Boolean trace;

        PresentProofRequestBuilder() {
        }

        public PresentProofRequestBuilder autoVerify(Boolean autoVerify) {
            this.autoVerify = autoVerify;
            return this;
        }

        public PresentProofRequestBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public PresentProofRequestBuilder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public PresentProofRequestBuilder proofRequest(@NonNull ProofRequest proofRequest) {
            if (proofRequest == null) {
                throw new NullPointerException("proofRequest is marked non-null but is null");
            }
            this.proofRequest = proofRequest;
            return this;
        }

        public PresentProofRequestBuilder trace(Boolean trace) {
            this.trace = trace;
            return this;
        }

        public PresentProofRequest build() {
            return new PresentProofRequest(this.autoVerify, this.comment, this.connectionId, this.proofRequest, this.trace);
        }

        public String toString() {
            return "PresentProofRequest.PresentProofRequestBuilder(autoVerify=" + this.autoVerify + ", comment=" + this.comment + ", connectionId=" + this.connectionId + ", proofRequest=" + this.proofRequest + ", trace=" + this.trace + ")";
        }
    }

    public static class ProofRequest {
        private String name;
        private String version;
        private String nonce;
        private ProofNonRevoked nonRevoked;
        private Map<String, ProofRequestedAttributes> requestedAttributes;
        private Map<String, ProofRequestedPredicates> requestedPredicates;

        private static String $default$name() {
            return "Proof request";
        }

        private static String $default$version() {
            return "1.0";
        }

        public static ProofRequestBuilder builder() {
            return new ProofRequestBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getNonce() {
            return this.nonce;
        }

        public ProofNonRevoked getNonRevoked() {
            return this.nonRevoked;
        }

        public Map<String, ProofRequestedAttributes> getRequestedAttributes() {
            return this.requestedAttributes;
        }

        public Map<String, ProofRequestedPredicates> getRequestedPredicates() {
            return this.requestedPredicates;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public void setNonRevoked(ProofNonRevoked nonRevoked) {
            this.nonRevoked = nonRevoked;
        }

        public void setRequestedAttributes(Map<String, ProofRequestedAttributes> requestedAttributes) {
            this.requestedAttributes = requestedAttributes;
        }

        public void setRequestedPredicates(Map<String, ProofRequestedPredicates> requestedPredicates) {
            this.requestedPredicates = requestedPredicates;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProofRequest)) {
                return false;
            }
            ProofRequest other = (ProofRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            ProofNonRevoked this$nonRevoked = this.getNonRevoked();
            ProofNonRevoked other$nonRevoked = other.getNonRevoked();
            if (this$nonRevoked == null ? other$nonRevoked != null : !((Object)this$nonRevoked).equals(other$nonRevoked)) {
                return false;
            }
            Map<String, ProofRequestedAttributes> this$requestedAttributes = this.getRequestedAttributes();
            Map<String, ProofRequestedAttributes> other$requestedAttributes = other.getRequestedAttributes();
            if (this$requestedAttributes == null ? other$requestedAttributes != null : !((Object)this$requestedAttributes).equals(other$requestedAttributes)) {
                return false;
            }
            Map<String, ProofRequestedPredicates> this$requestedPredicates = this.getRequestedPredicates();
            Map<String, ProofRequestedPredicates> other$requestedPredicates = other.getRequestedPredicates();
            return !(this$requestedPredicates == null ? other$requestedPredicates != null : !((Object)this$requestedPredicates).equals(other$requestedPredicates));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProofRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            ProofNonRevoked $nonRevoked = this.getNonRevoked();
            result = result * 59 + ($nonRevoked == null ? 43 : ((Object)$nonRevoked).hashCode());
            Map<String, ProofRequestedAttributes> $requestedAttributes = this.getRequestedAttributes();
            result = result * 59 + ($requestedAttributes == null ? 43 : ((Object)$requestedAttributes).hashCode());
            Map<String, ProofRequestedPredicates> $requestedPredicates = this.getRequestedPredicates();
            result = result * 59 + ($requestedPredicates == null ? 43 : ((Object)$requestedPredicates).hashCode());
            return result;
        }

        public String toString() {
            return "PresentProofRequest.ProofRequest(name=" + this.getName() + ", version=" + this.getVersion() + ", nonce=" + this.getNonce() + ", nonRevoked=" + this.getNonRevoked() + ", requestedAttributes=" + this.getRequestedAttributes() + ", requestedPredicates=" + this.getRequestedPredicates() + ")";
        }

        public ProofRequest() {
            this.name = ProofRequest.$default$name();
            this.version = ProofRequest.$default$version();
        }

        public ProofRequest(String name, String version, String nonce, ProofNonRevoked nonRevoked, Map<String, ProofRequestedAttributes> requestedAttributes, Map<String, ProofRequestedPredicates> requestedPredicates) {
            this.name = name;
            this.version = version;
            this.nonce = nonce;
            this.nonRevoked = nonRevoked;
            this.requestedAttributes = requestedAttributes;
            this.requestedPredicates = requestedPredicates;
        }

        public static class ProofRequestBuilder {
            private boolean name$set;
            private String name$value;
            private boolean version$set;
            private String version$value;
            private String nonce;
            private ProofNonRevoked nonRevoked;
            private ArrayList<String> requestedAttributes$key;
            private ArrayList<ProofRequestedAttributes> requestedAttributes$value;
            private ArrayList<String> requestedPredicates$key;
            private ArrayList<ProofRequestedPredicates> requestedPredicates$value;

            ProofRequestBuilder() {
            }

            public ProofRequestBuilder name(String name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            public ProofRequestBuilder version(String version) {
                this.version$value = version;
                this.version$set = true;
                return this;
            }

            public ProofRequestBuilder nonce(String nonce) {
                this.nonce = nonce;
                return this;
            }

            public ProofRequestBuilder nonRevoked(ProofNonRevoked nonRevoked) {
                this.nonRevoked = nonRevoked;
                return this;
            }

            public ProofRequestBuilder requestedAttribute(String requestedAttributeKey, ProofRequestedAttributes requestedAttributeValue) {
                if (this.requestedAttributes$key == null) {
                    this.requestedAttributes$key = new ArrayList();
                    this.requestedAttributes$value = new ArrayList();
                }
                this.requestedAttributes$key.add(requestedAttributeKey);
                this.requestedAttributes$value.add(requestedAttributeValue);
                return this;
            }

            public ProofRequestBuilder requestedAttributes(Map<? extends String, ? extends ProofRequestedAttributes> requestedAttributes) {
                if (requestedAttributes == null) {
                    throw new NullPointerException("requestedAttributes cannot be null");
                }
                if (this.requestedAttributes$key == null) {
                    this.requestedAttributes$key = new ArrayList();
                    this.requestedAttributes$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ProofRequestedAttributes> $lombokEntry : requestedAttributes.entrySet()) {
                    this.requestedAttributes$key.add($lombokEntry.getKey());
                    this.requestedAttributes$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ProofRequestBuilder clearRequestedAttributes() {
                if (this.requestedAttributes$key != null) {
                    this.requestedAttributes$key.clear();
                    this.requestedAttributes$value.clear();
                }
                return this;
            }

            public ProofRequestBuilder requestedPredicate(String requestedPredicateKey, ProofRequestedPredicates requestedPredicateValue) {
                if (this.requestedPredicates$key == null) {
                    this.requestedPredicates$key = new ArrayList();
                    this.requestedPredicates$value = new ArrayList();
                }
                this.requestedPredicates$key.add(requestedPredicateKey);
                this.requestedPredicates$value.add(requestedPredicateValue);
                return this;
            }

            public ProofRequestBuilder requestedPredicates(Map<? extends String, ? extends ProofRequestedPredicates> requestedPredicates) {
                if (requestedPredicates == null) {
                    throw new NullPointerException("requestedPredicates cannot be null");
                }
                if (this.requestedPredicates$key == null) {
                    this.requestedPredicates$key = new ArrayList();
                    this.requestedPredicates$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ProofRequestedPredicates> $lombokEntry : requestedPredicates.entrySet()) {
                    this.requestedPredicates$key.add($lombokEntry.getKey());
                    this.requestedPredicates$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ProofRequestBuilder clearRequestedPredicates() {
                if (this.requestedPredicates$key != null) {
                    this.requestedPredicates$key.clear();
                    this.requestedPredicates$value.clear();
                }
                return this;
            }

            public ProofRequest build() {
                Map<String, ProofRequestedPredicates> requestedPredicates;
                Map<Object, Object> requestedAttributes;
                switch (this.requestedAttributes$key == null ? 0 : this.requestedAttributes$key.size()) {
                    case 0: {
                        requestedAttributes = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        requestedAttributes = Collections.singletonMap(this.requestedAttributes$key.get(0), this.requestedAttributes$value.get(0));
                        break;
                    }
                    default: {
                        requestedAttributes = new LinkedHashMap(this.requestedAttributes$key.size() < 0x40000000 ? 1 + this.requestedAttributes$key.size() + (this.requestedAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.requestedAttributes$key.size(); ++$i) {
                            requestedAttributes.put(this.requestedAttributes$key.get($i), this.requestedAttributes$value.get($i));
                        }
                        requestedAttributes = Collections.unmodifiableMap(requestedAttributes);
                    }
                }
                switch (this.requestedPredicates$key == null ? 0 : this.requestedPredicates$key.size()) {
                    case 0: {
                        requestedPredicates = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        requestedPredicates = Collections.singletonMap(this.requestedPredicates$key.get(0), this.requestedPredicates$value.get(0));
                        break;
                    }
                    default: {
                        requestedPredicates = new LinkedHashMap(this.requestedPredicates$key.size() < 0x40000000 ? 1 + this.requestedPredicates$key.size() + (this.requestedPredicates$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.requestedPredicates$key.size(); ++$i) {
                            requestedPredicates.put(this.requestedPredicates$key.get($i), this.requestedPredicates$value.get($i));
                        }
                        requestedPredicates = Collections.unmodifiableMap(requestedPredicates);
                    }
                }
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = ProofRequest.$default$name();
                }
                String version$value = this.version$value;
                if (!this.version$set) {
                    version$value = ProofRequest.$default$version();
                }
                return new ProofRequest(name$value, version$value, this.nonce, this.nonRevoked, requestedAttributes, requestedPredicates);
            }

            public String toString() {
                return "PresentProofRequest.ProofRequest.ProofRequestBuilder(name$value=" + this.name$value + ", version$value=" + this.version$value + ", nonce=" + this.nonce + ", nonRevoked=" + this.nonRevoked + ", requestedAttributes$key=" + this.requestedAttributes$key + ", requestedAttributes$value=" + this.requestedAttributes$value + ", requestedPredicates$key=" + this.requestedPredicates$key + ", requestedPredicates$value=" + this.requestedPredicates$value + ")";
            }
        }

        public static class ProofRestrictions {
            private String schemaId;
            private String schemaName;
            private String schemaVersion;
            private String schemaIssuerDid;
            @SerializedName(value="cred_def_id", alternate={"credential_definition_id"})
            private String credentialDefinitionId;
            private String issuerDid;
            private transient Map<String, String> genericRestrictions;

            public JsonObject toJsonObject() {
                JsonObject result = GsonConfig.defaultConfig().toJsonTree((Object)this).getAsJsonObject();
                return this.flattenGenericRestrictions(result);
            }

            public static ProofRestrictions fromJsonObject(@NonNull JsonObject json) {
                if (json == null) {
                    throw new NullPointerException("json is marked non-null but is null");
                }
                ProofRestrictions result = (ProofRestrictions)GsonConfig.defaultConfig().fromJson((JsonElement)json, ProofRestrictions.class);
                json.keySet().stream().filter(key -> key.startsWith("attr::")).findFirst().ifPresent(key -> result.setGenericRestrictions(Map.of(key, json.get(key).getAsString())));
                return result;
            }

            @NonNull
            private JsonObject flattenGenericRestrictions(@NonNull JsonObject result) {
                if (result == null) {
                    throw new NullPointerException("result is marked non-null but is null");
                }
                this.genericRestrictions.forEach((k, v) -> result.add(k, (JsonElement)new JsonPrimitive(v)));
                return result;
            }

            public static ProofRestrictionsBuilder builder() {
                return new ProofRestrictionsBuilder();
            }

            public String getSchemaId() {
                return this.schemaId;
            }

            public String getSchemaName() {
                return this.schemaName;
            }

            public String getSchemaVersion() {
                return this.schemaVersion;
            }

            public String getSchemaIssuerDid() {
                return this.schemaIssuerDid;
            }

            public String getCredentialDefinitionId() {
                return this.credentialDefinitionId;
            }

            public String getIssuerDid() {
                return this.issuerDid;
            }

            public Map<String, String> getGenericRestrictions() {
                return this.genericRestrictions;
            }

            public void setSchemaId(String schemaId) {
                this.schemaId = schemaId;
            }

            public void setSchemaName(String schemaName) {
                this.schemaName = schemaName;
            }

            public void setSchemaVersion(String schemaVersion) {
                this.schemaVersion = schemaVersion;
            }

            public void setSchemaIssuerDid(String schemaIssuerDid) {
                this.schemaIssuerDid = schemaIssuerDid;
            }

            public void setCredentialDefinitionId(String credentialDefinitionId) {
                this.credentialDefinitionId = credentialDefinitionId;
            }

            public void setIssuerDid(String issuerDid) {
                this.issuerDid = issuerDid;
            }

            public void setGenericRestrictions(Map<String, String> genericRestrictions) {
                this.genericRestrictions = genericRestrictions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProofRestrictions)) {
                    return false;
                }
                ProofRestrictions other = (ProofRestrictions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$schemaId = this.getSchemaId();
                String other$schemaId = other.getSchemaId();
                if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                    return false;
                }
                String this$schemaName = this.getSchemaName();
                String other$schemaName = other.getSchemaName();
                if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
                    return false;
                }
                String this$schemaVersion = this.getSchemaVersion();
                String other$schemaVersion = other.getSchemaVersion();
                if (this$schemaVersion == null ? other$schemaVersion != null : !this$schemaVersion.equals(other$schemaVersion)) {
                    return false;
                }
                String this$schemaIssuerDid = this.getSchemaIssuerDid();
                String other$schemaIssuerDid = other.getSchemaIssuerDid();
                if (this$schemaIssuerDid == null ? other$schemaIssuerDid != null : !this$schemaIssuerDid.equals(other$schemaIssuerDid)) {
                    return false;
                }
                String this$credentialDefinitionId = this.getCredentialDefinitionId();
                String other$credentialDefinitionId = other.getCredentialDefinitionId();
                if (this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId)) {
                    return false;
                }
                String this$issuerDid = this.getIssuerDid();
                String other$issuerDid = other.getIssuerDid();
                return !(this$issuerDid == null ? other$issuerDid != null : !this$issuerDid.equals(other$issuerDid));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ProofRestrictions;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $schemaId = this.getSchemaId();
                result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
                String $schemaName = this.getSchemaName();
                result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
                String $schemaVersion = this.getSchemaVersion();
                result = result * 59 + ($schemaVersion == null ? 43 : $schemaVersion.hashCode());
                String $schemaIssuerDid = this.getSchemaIssuerDid();
                result = result * 59 + ($schemaIssuerDid == null ? 43 : $schemaIssuerDid.hashCode());
                String $credentialDefinitionId = this.getCredentialDefinitionId();
                result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
                String $issuerDid = this.getIssuerDid();
                result = result * 59 + ($issuerDid == null ? 43 : $issuerDid.hashCode());
                return result;
            }

            public String toString() {
                return "PresentProofRequest.ProofRequest.ProofRestrictions(schemaId=" + this.getSchemaId() + ", schemaName=" + this.getSchemaName() + ", schemaVersion=" + this.getSchemaVersion() + ", schemaIssuerDid=" + this.getSchemaIssuerDid() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ", issuerDid=" + this.getIssuerDid() + ", genericRestrictions=" + this.getGenericRestrictions() + ")";
            }

            public ProofRestrictions() {
            }

            public ProofRestrictions(String schemaId, String schemaName, String schemaVersion, String schemaIssuerDid, String credentialDefinitionId, String issuerDid, Map<String, String> genericRestrictions) {
                this.schemaId = schemaId;
                this.schemaName = schemaName;
                this.schemaVersion = schemaVersion;
                this.schemaIssuerDid = schemaIssuerDid;
                this.credentialDefinitionId = credentialDefinitionId;
                this.issuerDid = issuerDid;
                this.genericRestrictions = genericRestrictions;
            }

            public static class ProofRestrictionsBuilder {
                private String schemaId;
                private String schemaName;
                private String schemaVersion;
                private String schemaIssuerDid;
                private String credentialDefinitionId;
                private String issuerDid;
                private ArrayList<String> genericRestrictions$key;
                private ArrayList<String> genericRestrictions$value;

                public ProofRestrictionsBuilder addAttributeValueRestriction(@NonNull String name, @NonNull String value) {
                    if (name == null) {
                        throw new NullPointerException("name is marked non-null but is null");
                    }
                    if (value == null) {
                        throw new NullPointerException("value is marked non-null but is null");
                    }
                    this.genericRestriction("attr::" + name + "::value", value);
                    return this;
                }

                ProofRestrictionsBuilder() {
                }

                public ProofRestrictionsBuilder schemaId(String schemaId) {
                    this.schemaId = schemaId;
                    return this;
                }

                public ProofRestrictionsBuilder schemaName(String schemaName) {
                    this.schemaName = schemaName;
                    return this;
                }

                public ProofRestrictionsBuilder schemaVersion(String schemaVersion) {
                    this.schemaVersion = schemaVersion;
                    return this;
                }

                public ProofRestrictionsBuilder schemaIssuerDid(String schemaIssuerDid) {
                    this.schemaIssuerDid = schemaIssuerDid;
                    return this;
                }

                public ProofRestrictionsBuilder credentialDefinitionId(String credentialDefinitionId) {
                    this.credentialDefinitionId = credentialDefinitionId;
                    return this;
                }

                public ProofRestrictionsBuilder issuerDid(String issuerDid) {
                    this.issuerDid = issuerDid;
                    return this;
                }

                public ProofRestrictionsBuilder genericRestriction(String genericRestrictionKey, String genericRestrictionValue) {
                    if (this.genericRestrictions$key == null) {
                        this.genericRestrictions$key = new ArrayList();
                        this.genericRestrictions$value = new ArrayList();
                    }
                    this.genericRestrictions$key.add(genericRestrictionKey);
                    this.genericRestrictions$value.add(genericRestrictionValue);
                    return this;
                }

                public ProofRestrictionsBuilder genericRestrictions(Map<? extends String, ? extends String> genericRestrictions) {
                    if (genericRestrictions == null) {
                        throw new NullPointerException("genericRestrictions cannot be null");
                    }
                    if (this.genericRestrictions$key == null) {
                        this.genericRestrictions$key = new ArrayList();
                        this.genericRestrictions$value = new ArrayList();
                    }
                    for (Map.Entry<? extends String, ? extends String> $lombokEntry : genericRestrictions.entrySet()) {
                        this.genericRestrictions$key.add($lombokEntry.getKey());
                        this.genericRestrictions$value.add($lombokEntry.getValue());
                    }
                    return this;
                }

                public ProofRestrictionsBuilder clearGenericRestrictions() {
                    if (this.genericRestrictions$key != null) {
                        this.genericRestrictions$key.clear();
                        this.genericRestrictions$value.clear();
                    }
                    return this;
                }

                public ProofRestrictions build() {
                    Map<String, String> genericRestrictions;
                    switch (this.genericRestrictions$key == null ? 0 : this.genericRestrictions$key.size()) {
                        case 0: {
                            genericRestrictions = Collections.emptyMap();
                            break;
                        }
                        case 1: {
                            genericRestrictions = Collections.singletonMap(this.genericRestrictions$key.get(0), this.genericRestrictions$value.get(0));
                            break;
                        }
                        default: {
                            genericRestrictions = new LinkedHashMap(this.genericRestrictions$key.size() < 0x40000000 ? 1 + this.genericRestrictions$key.size() + (this.genericRestrictions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                            for (int $i = 0; $i < this.genericRestrictions$key.size(); ++$i) {
                                genericRestrictions.put(this.genericRestrictions$key.get($i), this.genericRestrictions$value.get($i));
                            }
                            genericRestrictions = Collections.unmodifiableMap(genericRestrictions);
                        }
                    }
                    return new ProofRestrictions(this.schemaId, this.schemaName, this.schemaVersion, this.schemaIssuerDid, this.credentialDefinitionId, this.issuerDid, genericRestrictions);
                }

                public String toString() {
                    return "PresentProofRequest.ProofRequest.ProofRestrictions.ProofRestrictionsBuilder(schemaId=" + this.schemaId + ", schemaName=" + this.schemaName + ", schemaVersion=" + this.schemaVersion + ", schemaIssuerDid=" + this.schemaIssuerDid + ", credentialDefinitionId=" + this.credentialDefinitionId + ", issuerDid=" + this.issuerDid + ", genericRestrictions$key=" + this.genericRestrictions$key + ", genericRestrictions$value=" + this.genericRestrictions$value + ")";
                }
            }
        }

        public static class ProofNonRevoked {
            private Long from;
            private Long to;

            public boolean isSet() {
                return this.from != null || this.to != null;
            }

            public static ProofNonRevokedBuilder builder() {
                return new ProofNonRevokedBuilder();
            }

            public Long getFrom() {
                return this.from;
            }

            public Long getTo() {
                return this.to;
            }

            public void setFrom(Long from) {
                this.from = from;
            }

            public void setTo(Long to) {
                this.to = to;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProofNonRevoked)) {
                    return false;
                }
                ProofNonRevoked other = (ProofNonRevoked)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$from = this.getFrom();
                Long other$from = other.getFrom();
                if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                    return false;
                }
                Long this$to = this.getTo();
                Long other$to = other.getTo();
                return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ProofNonRevoked;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $from = this.getFrom();
                result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
                Long $to = this.getTo();
                result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
                return result;
            }

            public String toString() {
                return "PresentProofRequest.ProofRequest.ProofNonRevoked(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
            }

            public ProofNonRevoked() {
            }

            public ProofNonRevoked(Long from, Long to) {
                this.from = from;
                this.to = to;
            }

            public static class ProofNonRevokedBuilder {
                private Long from;
                private Long to;

                ProofNonRevokedBuilder() {
                }

                public ProofNonRevokedBuilder from(Long from) {
                    this.from = from;
                    return this;
                }

                public ProofNonRevokedBuilder to(Long to) {
                    this.to = to;
                    return this;
                }

                public ProofNonRevoked build() {
                    return new ProofNonRevoked(this.from, this.to);
                }

                public String toString() {
                    return "PresentProofRequest.ProofRequest.ProofNonRevoked.ProofNonRevokedBuilder(from=" + this.from + ", to=" + this.to + ")";
                }
            }
        }

        public static class ProofRequestedPredicates {
            private String name;
            private ProofNonRevoked nonRevoked;
            private IndyProofReqPredSpec.PTypeEnum pType;
            private Integer pValue;
            @JsonSerialize(using=JsonObjectArraySerializer.class)
            @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
            private List<JsonObject> restrictions;

            public static ProofRequestedPredicatesBuilder builder() {
                return new ProofRequestedPredicatesBuilder();
            }

            public String getName() {
                return this.name;
            }

            public ProofNonRevoked getNonRevoked() {
                return this.nonRevoked;
            }

            public IndyProofReqPredSpec.PTypeEnum getPType() {
                return this.pType;
            }

            public Integer getPValue() {
                return this.pValue;
            }

            public List<JsonObject> getRestrictions() {
                return this.restrictions;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setNonRevoked(ProofNonRevoked nonRevoked) {
                this.nonRevoked = nonRevoked;
            }

            public void setPType(IndyProofReqPredSpec.PTypeEnum pType) {
                this.pType = pType;
            }

            public void setPValue(Integer pValue) {
                this.pValue = pValue;
            }

            @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
            public void setRestrictions(List<JsonObject> restrictions) {
                this.restrictions = restrictions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProofRequestedPredicates)) {
                    return false;
                }
                ProofRequestedPredicates other = (ProofRequestedPredicates)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$pValue = this.getPValue();
                Integer other$pValue = other.getPValue();
                if (this$pValue == null ? other$pValue != null : !((Object)this$pValue).equals(other$pValue)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                ProofNonRevoked this$nonRevoked = this.getNonRevoked();
                ProofNonRevoked other$nonRevoked = other.getNonRevoked();
                if (this$nonRevoked == null ? other$nonRevoked != null : !((Object)this$nonRevoked).equals(other$nonRevoked)) {
                    return false;
                }
                IndyProofReqPredSpec.PTypeEnum this$pType = this.getPType();
                IndyProofReqPredSpec.PTypeEnum other$pType = other.getPType();
                if (this$pType == null ? other$pType != null : !((Object)((Object)this$pType)).equals((Object)other$pType)) {
                    return false;
                }
                List<JsonObject> this$restrictions = this.getRestrictions();
                List<JsonObject> other$restrictions = other.getRestrictions();
                return !(this$restrictions == null ? other$restrictions != null : !((Object)this$restrictions).equals(other$restrictions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ProofRequestedPredicates;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $pValue = this.getPValue();
                result = result * 59 + ($pValue == null ? 43 : ((Object)$pValue).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                ProofNonRevoked $nonRevoked = this.getNonRevoked();
                result = result * 59 + ($nonRevoked == null ? 43 : ((Object)$nonRevoked).hashCode());
                IndyProofReqPredSpec.PTypeEnum $pType = this.getPType();
                result = result * 59 + ($pType == null ? 43 : ((Object)((Object)$pType)).hashCode());
                List<JsonObject> $restrictions = this.getRestrictions();
                result = result * 59 + ($restrictions == null ? 43 : ((Object)$restrictions).hashCode());
                return result;
            }

            public String toString() {
                return "PresentProofRequest.ProofRequest.ProofRequestedPredicates(name=" + this.getName() + ", nonRevoked=" + this.getNonRevoked() + ", pType=" + this.getPType() + ", pValue=" + this.getPValue() + ", restrictions=" + this.getRestrictions() + ")";
            }

            public ProofRequestedPredicates() {
            }

            public ProofRequestedPredicates(String name, ProofNonRevoked nonRevoked, IndyProofReqPredSpec.PTypeEnum pType, Integer pValue, List<JsonObject> restrictions) {
                this.name = name;
                this.nonRevoked = nonRevoked;
                this.pType = pType;
                this.pValue = pValue;
                this.restrictions = restrictions;
            }

            public static class ProofRequestedPredicatesBuilder {
                private String name;
                private ProofNonRevoked nonRevoked;
                private IndyProofReqPredSpec.PTypeEnum pType;
                private Integer pValue;
                private ArrayList<JsonObject> restrictions;

                ProofRequestedPredicatesBuilder() {
                }

                public ProofRequestedPredicatesBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                public ProofRequestedPredicatesBuilder nonRevoked(ProofNonRevoked nonRevoked) {
                    this.nonRevoked = nonRevoked;
                    return this;
                }

                public ProofRequestedPredicatesBuilder pType(IndyProofReqPredSpec.PTypeEnum pType) {
                    this.pType = pType;
                    return this;
                }

                public ProofRequestedPredicatesBuilder pValue(Integer pValue) {
                    this.pValue = pValue;
                    return this;
                }

                public ProofRequestedPredicatesBuilder restriction(JsonObject restriction) {
                    if (this.restrictions == null) {
                        this.restrictions = new ArrayList();
                    }
                    this.restrictions.add(restriction);
                    return this;
                }

                @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
                public ProofRequestedPredicatesBuilder restrictions(Collection<? extends JsonObject> restrictions) {
                    if (restrictions == null) {
                        throw new NullPointerException("restrictions cannot be null");
                    }
                    if (this.restrictions == null) {
                        this.restrictions = new ArrayList();
                    }
                    this.restrictions.addAll(restrictions);
                    return this;
                }

                public ProofRequestedPredicatesBuilder clearRestrictions() {
                    if (this.restrictions != null) {
                        this.restrictions.clear();
                    }
                    return this;
                }

                public ProofRequestedPredicates build() {
                    List<JsonObject> restrictions;
                    switch (this.restrictions == null ? 0 : this.restrictions.size()) {
                        case 0: {
                            restrictions = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            restrictions = Collections.singletonList(this.restrictions.get(0));
                            break;
                        }
                        default: {
                            restrictions = Collections.unmodifiableList(new ArrayList<JsonObject>(this.restrictions));
                        }
                    }
                    return new ProofRequestedPredicates(this.name, this.nonRevoked, this.pType, this.pValue, restrictions);
                }

                public String toString() {
                    return "PresentProofRequest.ProofRequest.ProofRequestedPredicates.ProofRequestedPredicatesBuilder(name=" + this.name + ", nonRevoked=" + this.nonRevoked + ", pType=" + this.pType + ", pValue=" + this.pValue + ", restrictions=" + this.restrictions + ")";
                }
            }
        }

        public static class ProofRequestedAttributes {
            private String name;
            private List<String> names;
            private ProofNonRevoked nonRevoked;
            @JsonSerialize(using=JsonObjectArraySerializer.class)
            @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
            private List<JsonObject> restrictions;

            public static ProofRequestedAttributesBuilder builder() {
                return new ProofRequestedAttributesBuilder();
            }

            public String getName() {
                return this.name;
            }

            public List<String> getNames() {
                return this.names;
            }

            public ProofNonRevoked getNonRevoked() {
                return this.nonRevoked;
            }

            public List<JsonObject> getRestrictions() {
                return this.restrictions;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setNames(List<String> names) {
                this.names = names;
            }

            public void setNonRevoked(ProofNonRevoked nonRevoked) {
                this.nonRevoked = nonRevoked;
            }

            @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
            public void setRestrictions(List<JsonObject> restrictions) {
                this.restrictions = restrictions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ProofRequestedAttributes)) {
                    return false;
                }
                ProofRequestedAttributes other = (ProofRequestedAttributes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                List<String> this$names = this.getNames();
                List<String> other$names = other.getNames();
                if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
                    return false;
                }
                ProofNonRevoked this$nonRevoked = this.getNonRevoked();
                ProofNonRevoked other$nonRevoked = other.getNonRevoked();
                if (this$nonRevoked == null ? other$nonRevoked != null : !((Object)this$nonRevoked).equals(other$nonRevoked)) {
                    return false;
                }
                List<JsonObject> this$restrictions = this.getRestrictions();
                List<JsonObject> other$restrictions = other.getRestrictions();
                return !(this$restrictions == null ? other$restrictions != null : !((Object)this$restrictions).equals(other$restrictions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ProofRequestedAttributes;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                List<String> $names = this.getNames();
                result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
                ProofNonRevoked $nonRevoked = this.getNonRevoked();
                result = result * 59 + ($nonRevoked == null ? 43 : ((Object)$nonRevoked).hashCode());
                List<JsonObject> $restrictions = this.getRestrictions();
                result = result * 59 + ($restrictions == null ? 43 : ((Object)$restrictions).hashCode());
                return result;
            }

            public String toString() {
                return "PresentProofRequest.ProofRequest.ProofRequestedAttributes(name=" + this.getName() + ", names=" + this.getNames() + ", nonRevoked=" + this.getNonRevoked() + ", restrictions=" + this.getRestrictions() + ")";
            }

            public ProofRequestedAttributes() {
            }

            public ProofRequestedAttributes(String name, List<String> names, ProofNonRevoked nonRevoked, List<JsonObject> restrictions) {
                this.name = name;
                this.names = names;
                this.nonRevoked = nonRevoked;
                this.restrictions = restrictions;
            }

            public static class ProofRequestedAttributesBuilder {
                private String name;
                private List<String> names;
                private ProofNonRevoked nonRevoked;
                private ArrayList<JsonObject> restrictions;

                ProofRequestedAttributesBuilder() {
                }

                public ProofRequestedAttributesBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                public ProofRequestedAttributesBuilder names(List<String> names) {
                    this.names = names;
                    return this;
                }

                public ProofRequestedAttributesBuilder nonRevoked(ProofNonRevoked nonRevoked) {
                    this.nonRevoked = nonRevoked;
                    return this;
                }

                public ProofRequestedAttributesBuilder restriction(JsonObject restriction) {
                    if (this.restrictions == null) {
                        this.restrictions = new ArrayList();
                    }
                    this.restrictions.add(restriction);
                    return this;
                }

                @JsonDeserialize(using=JsonObjectArrayDeserializer.class)
                public ProofRequestedAttributesBuilder restrictions(Collection<? extends JsonObject> restrictions) {
                    if (restrictions == null) {
                        throw new NullPointerException("restrictions cannot be null");
                    }
                    if (this.restrictions == null) {
                        this.restrictions = new ArrayList();
                    }
                    this.restrictions.addAll(restrictions);
                    return this;
                }

                public ProofRequestedAttributesBuilder clearRestrictions() {
                    if (this.restrictions != null) {
                        this.restrictions.clear();
                    }
                    return this;
                }

                public ProofRequestedAttributes build() {
                    List<JsonObject> restrictions;
                    switch (this.restrictions == null ? 0 : this.restrictions.size()) {
                        case 0: {
                            restrictions = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            restrictions = Collections.singletonList(this.restrictions.get(0));
                            break;
                        }
                        default: {
                            restrictions = Collections.unmodifiableList(new ArrayList<JsonObject>(this.restrictions));
                        }
                    }
                    return new ProofRequestedAttributes(this.name, this.names, this.nonRevoked, restrictions);
                }

                public String toString() {
                    return "PresentProofRequest.ProofRequest.ProofRequestedAttributes.ProofRequestedAttributesBuilder(name=" + this.name + ", names=" + this.names + ", nonRevoked=" + this.nonRevoked + ", restrictions=" + this.restrictions + ")";
                }
            }
        }
    }
}

