/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.hyperledger.aries.api.credentials.Credential;
import org.hyperledger.aries.api.present_proof.PresentProofProposal;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof_v2.V20PresProposalByFormat;
import org.hyperledger.aries.api.present_proof_v2.V20PresProposalRequest;

public class PresentProofProposalBuilder {
    public static PresentProofProposal fromCredential(@NonNull String connectionId, @NonNull Credential cred) {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (cred == null) {
            throw new NullPointerException("cred is marked non-null but is null");
        }
        Map<String, String> attrs = cred.getAttrs();
        ArrayList<PresentProofProposal.PresentationPreview.PresAttrSpec> presAttr = new ArrayList<PresentProofProposal.PresentationPreview.PresAttrSpec>();
        attrs.forEach((k, v) -> presAttr.add(PresentProofProposal.PresentationPreview.PresAttrSpec.builder().name((String)k).value((String)v).credentialDefinitionId(cred.getCredentialDefinitionId()).referent(cred.getReferent()).build()));
        return PresentProofProposal.builder().autoPresent(Boolean.TRUE).presentationProposal(PresentProofProposal.PresentationPreview.builder().attributes(presAttr).build()).connectionId(connectionId).build();
    }

    public static V20PresProposalRequest v2IndyFromCredential(@NonNull String connectionId, @NonNull Credential cred, String requestName) {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (cred == null) {
            throw new NullPointerException("cred is marked non-null but is null");
        }
        Map<String, String> attrs = cred.getAttrs();
        ArrayList res = new ArrayList();
        attrs.forEach((name, value) -> res.add(PresentProofRequest.ProofRequest.ProofRestrictions.builder().addAttributeValueRestriction((String)name, (String)value).schemaId(cred.getSchemaId()).credentialDefinitionId(cred.getCredentialDefinitionId()).build().toJsonObject()));
        PresentProofRequest.ProofRequest.ProofRequestedAttributes requestedAttributes = PresentProofRequest.ProofRequest.ProofRequestedAttributes.builder().names(new ArrayList<String>(attrs.keySet())).restrictions(res).build();
        return V20PresProposalRequest.builder().autoPresent(Boolean.TRUE).connectionId(connectionId).presentationProposal(V20PresProposalByFormat.builder().indy(PresentProofRequest.ProofRequest.builder().name(requestName != null ? requestName : "proof-request").requestedAttributes(Map.of(UUID.randomUUID().toString(), requestedAttributes)).build()).build()).build();
    }
}

