/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import org.hyperledger.aries.api.present_proof.PresentationExchangeRole;
import org.hyperledger.aries.api.present_proof.PresentationExchangeState;

public interface PresExStateTranslator {
    public PresentationExchangeState getState();

    public PresentationExchangeRole getRole();

    default public boolean roleIsProver() {
        return PresentationExchangeRole.PROVER.equals((Object)this.getRole());
    }

    default public boolean roleIsVerifier() {
        return PresentationExchangeRole.VERIFIER.equals((Object)this.getRole());
    }

    default public boolean stateIsRequestSent() {
        return PresentationExchangeState.REQUEST_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsProposalReceived() {
        return PresentationExchangeState.PROPOSAL_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsPresentationReceived() {
        return PresentationExchangeState.PRESENTATION_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsRequestReceived() {
        return PresentationExchangeState.REQUEST_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsProposalSent() {
        return PresentationExchangeState.PROPOSAL_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsPresentationSent() {
        return PresentationExchangeState.PRESENTATIONS_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsPresentationAcked() {
        return PresentationExchangeState.PRESENTATION_ACKED.equals((Object)this.getState());
    }

    default public boolean stateIsVerified() {
        return PresentationExchangeState.VERIFIED.equals((Object)this.getState());
    }

    default public boolean stateIsAbandoned() {
        return PresentationExchangeState.ABANDONED.equals((Object)this.getState());
    }

    default public boolean stateIsDone() {
        return PresentationExchangeState.DONE.equals((Object)this.getState());
    }

    default public boolean roleIsProverAndRequestReceived() {
        return this.roleIsProver() && this.stateIsRequestReceived();
    }

    default public boolean roleIsProverAndPresentationSent() {
        return this.roleIsProver() && this.stateIsPresentationSent();
    }

    default public boolean roleIsProverAndProposalSent() {
        return this.roleIsProver() && this.stateIsProposalSent();
    }

    default public boolean roleIsProverAndPresentationAcked() {
        return this.roleIsProver() && this.stateIsPresentationAcked();
    }

    default public boolean roleIsProverAndStateIsPresentationAckedOrDone() {
        return this.roleIsProver() && (this.stateIsPresentationAcked() || this.stateIsDone());
    }

    default public boolean roleIsVerifierAndRequestSent() {
        return this.roleIsVerifier() && this.stateIsRequestSent();
    }

    default public boolean roleIsVerifierAndStateIsVerifiedOrDone() {
        return this.roleIsVerifier() && (this.stateIsVerified() || this.stateIsDone());
    }

    default public boolean roleIsVerifierAndVerified() {
        return this.roleIsVerifier() && this.stateIsVerified();
    }

    default public boolean roleIsVerifierAndDone() {
        return this.roleIsVerifier() && this.stateIsDone();
    }
}

