/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.present_proof;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.SerializedName;
import org.hyperledger.aries.api.ExchangeVersion;
import org.hyperledger.aries.api.present_proof.PresExStateTranslator;
import org.hyperledger.aries.api.present_proof.PresentationExchangeInitiator;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRole;
import org.hyperledger.aries.api.present_proof.PresentationExchangeState;

public abstract class BasePresExRecord
implements PresExStateTranslator {
    private String createdAt;
    private String updatedAt;
    private Boolean autoPresent;
    private Boolean autoVerify;
    private Boolean trace;
    private Boolean verified;
    private String errorMsg;
    private String connectionId;
    @SerializedName(value="presentation_exchange_id", alternate={"pres_ex_id", "presExId", "presentationExchangeId"})
    private String presentationExchangeId;
    private String threadId;
    private PresentationExchangeInitiator initiator;
    private PresentationExchangeRole role;
    private PresentationExchangeState state;

    @JsonIgnore
    public String getPresExId() {
        return this.presentationExchangeId;
    }

    public boolean isVerified() {
        return this.getVerified() != null && this.getVerified() != false;
    }

    public boolean initiatorIsSelf() {
        return PresentationExchangeInitiator.SELF.equals((Object)this.getInitiator());
    }

    public boolean initiatorIsExternal() {
        return PresentationExchangeInitiator.EXTERNAL.equals((Object)this.getInitiator());
    }

    public boolean versionIsV1() {
        return ExchangeVersion.V1.equals((Object)this.getVersion());
    }

    public abstract ExchangeVersion getVersion();

    protected BasePresExRecord(BasePresExRecordBuilder<?, ?> b) {
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.autoPresent = b.autoPresent;
        this.autoVerify = b.autoVerify;
        this.trace = b.trace;
        this.verified = b.verified;
        this.errorMsg = b.errorMsg;
        this.connectionId = b.connectionId;
        this.presentationExchangeId = b.presentationExchangeId;
        this.threadId = b.threadId;
        this.initiator = b.initiator;
        this.role = b.role;
        this.state = b.state;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getAutoPresent() {
        return this.autoPresent;
    }

    public Boolean getAutoVerify() {
        return this.autoVerify;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getPresentationExchangeId() {
        return this.presentationExchangeId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public PresentationExchangeInitiator getInitiator() {
        return this.initiator;
    }

    @Override
    public PresentationExchangeRole getRole() {
        return this.role;
    }

    @Override
    public PresentationExchangeState getState() {
        return this.state;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setAutoPresent(Boolean autoPresent) {
        this.autoPresent = autoPresent;
    }

    public void setAutoVerify(Boolean autoVerify) {
        this.autoVerify = autoVerify;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setPresentationExchangeId(String presentationExchangeId) {
        this.presentationExchangeId = presentationExchangeId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public void setInitiator(PresentationExchangeInitiator initiator) {
        this.initiator = initiator;
    }

    public void setRole(PresentationExchangeRole role) {
        this.role = role;
    }

    public void setState(PresentationExchangeState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePresExRecord)) {
            return false;
        }
        BasePresExRecord other = (BasePresExRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoPresent = this.getAutoPresent();
        Boolean other$autoPresent = other.getAutoPresent();
        if (this$autoPresent == null ? other$autoPresent != null : !((Object)this$autoPresent).equals(other$autoPresent)) {
            return false;
        }
        Boolean this$autoVerify = this.getAutoVerify();
        Boolean other$autoVerify = other.getAutoVerify();
        if (this$autoVerify == null ? other$autoVerify != null : !((Object)this$autoVerify).equals(other$autoVerify)) {
            return false;
        }
        Boolean this$trace = this.getTrace();
        Boolean other$trace = other.getTrace();
        if (this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace)) {
            return false;
        }
        Boolean this$verified = this.getVerified();
        Boolean other$verified = other.getVerified();
        if (this$verified == null ? other$verified != null : !((Object)this$verified).equals(other$verified)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$presentationExchangeId = this.getPresentationExchangeId();
        String other$presentationExchangeId = other.getPresentationExchangeId();
        if (this$presentationExchangeId == null ? other$presentationExchangeId != null : !this$presentationExchangeId.equals(other$presentationExchangeId)) {
            return false;
        }
        String this$threadId = this.getThreadId();
        String other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
            return false;
        }
        PresentationExchangeInitiator this$initiator = this.getInitiator();
        PresentationExchangeInitiator other$initiator = other.getInitiator();
        if (this$initiator == null ? other$initiator != null : !((Object)((Object)this$initiator)).equals((Object)other$initiator)) {
            return false;
        }
        PresentationExchangeRole this$role = this.getRole();
        PresentationExchangeRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        PresentationExchangeState this$state = this.getState();
        PresentationExchangeState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePresExRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoPresent = this.getAutoPresent();
        result = result * 59 + ($autoPresent == null ? 43 : ((Object)$autoPresent).hashCode());
        Boolean $autoVerify = this.getAutoVerify();
        result = result * 59 + ($autoVerify == null ? 43 : ((Object)$autoVerify).hashCode());
        Boolean $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        Boolean $verified = this.getVerified();
        result = result * 59 + ($verified == null ? 43 : ((Object)$verified).hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $presentationExchangeId = this.getPresentationExchangeId();
        result = result * 59 + ($presentationExchangeId == null ? 43 : $presentationExchangeId.hashCode());
        String $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
        PresentationExchangeInitiator $initiator = this.getInitiator();
        result = result * 59 + ($initiator == null ? 43 : ((Object)((Object)$initiator)).hashCode());
        PresentationExchangeRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        PresentationExchangeState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "BasePresExRecord(createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", autoPresent=" + this.getAutoPresent() + ", autoVerify=" + this.getAutoVerify() + ", trace=" + this.getTrace() + ", verified=" + this.getVerified() + ", errorMsg=" + this.getErrorMsg() + ", connectionId=" + this.getConnectionId() + ", presentationExchangeId=" + this.getPresentationExchangeId() + ", threadId=" + this.getThreadId() + ", initiator=" + this.getInitiator() + ", role=" + this.getRole() + ", state=" + this.getState() + ")";
    }

    public BasePresExRecord() {
    }

    public BasePresExRecord(String createdAt, String updatedAt, Boolean autoPresent, Boolean autoVerify, Boolean trace, Boolean verified, String errorMsg, String connectionId, String presentationExchangeId, String threadId, PresentationExchangeInitiator initiator, PresentationExchangeRole role, PresentationExchangeState state) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.autoPresent = autoPresent;
        this.autoVerify = autoVerify;
        this.trace = trace;
        this.verified = verified;
        this.errorMsg = errorMsg;
        this.connectionId = connectionId;
        this.presentationExchangeId = presentationExchangeId;
        this.threadId = threadId;
        this.initiator = initiator;
        this.role = role;
        this.state = state;
    }

    public static abstract class BasePresExRecordBuilder<C extends BasePresExRecord, B extends BasePresExRecordBuilder<C, B>> {
        private String createdAt;
        private String updatedAt;
        private Boolean autoPresent;
        private Boolean autoVerify;
        private Boolean trace;
        private Boolean verified;
        private String errorMsg;
        private String connectionId;
        private String presentationExchangeId;
        private String threadId;
        private PresentationExchangeInitiator initiator;
        private PresentationExchangeRole role;
        private PresentationExchangeState state;

        protected abstract B self();

        public abstract C build();

        public B createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        public B updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        public B autoPresent(Boolean autoPresent) {
            this.autoPresent = autoPresent;
            return this.self();
        }

        public B autoVerify(Boolean autoVerify) {
            this.autoVerify = autoVerify;
            return this.self();
        }

        public B trace(Boolean trace) {
            this.trace = trace;
            return this.self();
        }

        public B verified(Boolean verified) {
            this.verified = verified;
            return this.self();
        }

        public B errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this.self();
        }

        public B connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this.self();
        }

        public B presentationExchangeId(String presentationExchangeId) {
            this.presentationExchangeId = presentationExchangeId;
            return this.self();
        }

        public B threadId(String threadId) {
            this.threadId = threadId;
            return this.self();
        }

        public B initiator(PresentationExchangeInitiator initiator) {
            this.initiator = initiator;
            return this.self();
        }

        public B role(PresentationExchangeRole role) {
            this.role = role;
            return this.self();
        }

        public B state(PresentationExchangeState state) {
            this.state = state;
            return this.self();
        }

        public String toString() {
            return "BasePresExRecord.BasePresExRecordBuilder(createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", autoPresent=" + this.autoPresent + ", autoVerify=" + this.autoVerify + ", trace=" + this.trace + ", verified=" + this.verified + ", errorMsg=" + this.errorMsg + ", connectionId=" + this.connectionId + ", presentationExchangeId=" + this.presentationExchangeId + ", threadId=" + this.threadId + ", initiator=" + this.initiator + ", role=" + this.role + ", state=" + this.state + ")";
        }
    }
}

