/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.out_of_band;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hyperledger.acy_py.generated.model.AttachDecorator;

public class InvitationMessage<T> {
    public static final Type RFC0067_TYPE = new TypeToken<InvitationMessage<InvitationMessageService>>(){}.getType();
    public static final Type STRING_TYPE = new TypeToken<InvitationMessage<String>>(){}.getType();
    @SerializedName(value="@id")
    private String atId;
    @SerializedName(value="@type")
    private String atType;
    private String label;
    @SerializedName(value="goal_code")
    private String goalCode;
    private String goal;
    private List<String> accept;
    @SerializedName(value="handshake_protocols")
    private List<String> handshakeProtocols;
    @SerializedName(value="requests~attach")
    private List<AttachDecorator> requestsAttach;
    private List<T> services;

    private static <T> List<String> $default$handshakeProtocols() {
        return List.of("did:sov:BzCbsNYhMrjHiqZDTUASHg;spec/didexchange/1.0");
    }

    InvitationMessage(String atId, String atType, String label, String goalCode, String goal, List<String> accept, List<String> handshakeProtocols, List<AttachDecorator> requestsAttach, List<T> services) {
        this.atId = atId;
        this.atType = atType;
        this.label = label;
        this.goalCode = goalCode;
        this.goal = goal;
        this.accept = accept;
        this.handshakeProtocols = handshakeProtocols;
        this.requestsAttach = requestsAttach;
        this.services = services;
    }

    public static <T> InvitationMessageBuilder<T> builder() {
        return new InvitationMessageBuilder();
    }

    public String getAtId() {
        return this.atId;
    }

    public String getAtType() {
        return this.atType;
    }

    public String getLabel() {
        return this.label;
    }

    public String getGoalCode() {
        return this.goalCode;
    }

    public String getGoal() {
        return this.goal;
    }

    public List<String> getAccept() {
        return this.accept;
    }

    public List<String> getHandshakeProtocols() {
        return this.handshakeProtocols;
    }

    public List<AttachDecorator> getRequestsAttach() {
        return this.requestsAttach;
    }

    public List<T> getServices() {
        return this.services;
    }

    public void setAtId(String atId) {
        this.atId = atId;
    }

    public void setAtType(String atType) {
        this.atType = atType;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setGoalCode(String goalCode) {
        this.goalCode = goalCode;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public void setAccept(List<String> accept) {
        this.accept = accept;
    }

    public void setHandshakeProtocols(List<String> handshakeProtocols) {
        this.handshakeProtocols = handshakeProtocols;
    }

    public void setRequestsAttach(List<AttachDecorator> requestsAttach) {
        this.requestsAttach = requestsAttach;
    }

    public void setServices(List<T> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvitationMessage)) {
            return false;
        }
        InvitationMessage other = (InvitationMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$atId = this.getAtId();
        String other$atId = other.getAtId();
        if (this$atId == null ? other$atId != null : !this$atId.equals(other$atId)) {
            return false;
        }
        String this$atType = this.getAtType();
        String other$atType = other.getAtType();
        if (this$atType == null ? other$atType != null : !this$atType.equals(other$atType)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$goalCode = this.getGoalCode();
        String other$goalCode = other.getGoalCode();
        if (this$goalCode == null ? other$goalCode != null : !this$goalCode.equals(other$goalCode)) {
            return false;
        }
        String this$goal = this.getGoal();
        String other$goal = other.getGoal();
        if (this$goal == null ? other$goal != null : !this$goal.equals(other$goal)) {
            return false;
        }
        List<String> this$accept = this.getAccept();
        List<String> other$accept = other.getAccept();
        if (this$accept == null ? other$accept != null : !((Object)this$accept).equals(other$accept)) {
            return false;
        }
        List<String> this$handshakeProtocols = this.getHandshakeProtocols();
        List<String> other$handshakeProtocols = other.getHandshakeProtocols();
        if (this$handshakeProtocols == null ? other$handshakeProtocols != null : !((Object)this$handshakeProtocols).equals(other$handshakeProtocols)) {
            return false;
        }
        List<AttachDecorator> this$requestsAttach = this.getRequestsAttach();
        List<AttachDecorator> other$requestsAttach = other.getRequestsAttach();
        if (this$requestsAttach == null ? other$requestsAttach != null : !((Object)this$requestsAttach).equals(other$requestsAttach)) {
            return false;
        }
        List<T> this$services = this.getServices();
        List<T> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvitationMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $atId = this.getAtId();
        result = result * 59 + ($atId == null ? 43 : $atId.hashCode());
        String $atType = this.getAtType();
        result = result * 59 + ($atType == null ? 43 : $atType.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $goalCode = this.getGoalCode();
        result = result * 59 + ($goalCode == null ? 43 : $goalCode.hashCode());
        String $goal = this.getGoal();
        result = result * 59 + ($goal == null ? 43 : $goal.hashCode());
        List<String> $accept = this.getAccept();
        result = result * 59 + ($accept == null ? 43 : ((Object)$accept).hashCode());
        List<String> $handshakeProtocols = this.getHandshakeProtocols();
        result = result * 59 + ($handshakeProtocols == null ? 43 : ((Object)$handshakeProtocols).hashCode());
        List<AttachDecorator> $requestsAttach = this.getRequestsAttach();
        result = result * 59 + ($requestsAttach == null ? 43 : ((Object)$requestsAttach).hashCode());
        List<T> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public String toString() {
        return "InvitationMessage(atId=" + this.getAtId() + ", atType=" + this.getAtType() + ", label=" + this.getLabel() + ", goalCode=" + this.getGoalCode() + ", goal=" + this.getGoal() + ", accept=" + this.getAccept() + ", handshakeProtocols=" + this.getHandshakeProtocols() + ", requestsAttach=" + this.getRequestsAttach() + ", services=" + this.getServices() + ")";
    }

    public static class InvitationMessageBuilder<T> {
        private String atId;
        private String atType;
        private String label;
        private String goalCode;
        private String goal;
        private List<String> accept;
        private boolean handshakeProtocols$set;
        private List<String> handshakeProtocols$value;
        private List<AttachDecorator> requestsAttach;
        private ArrayList<T> services;

        InvitationMessageBuilder() {
        }

        public InvitationMessageBuilder<T> atId(String atId) {
            this.atId = atId;
            return this;
        }

        public InvitationMessageBuilder<T> atType(String atType) {
            this.atType = atType;
            return this;
        }

        public InvitationMessageBuilder<T> label(String label) {
            this.label = label;
            return this;
        }

        public InvitationMessageBuilder<T> goalCode(String goalCode) {
            this.goalCode = goalCode;
            return this;
        }

        public InvitationMessageBuilder<T> goal(String goal) {
            this.goal = goal;
            return this;
        }

        public InvitationMessageBuilder<T> accept(List<String> accept) {
            this.accept = accept;
            return this;
        }

        public InvitationMessageBuilder<T> handshakeProtocols(List<String> handshakeProtocols) {
            this.handshakeProtocols$value = handshakeProtocols;
            this.handshakeProtocols$set = true;
            return this;
        }

        public InvitationMessageBuilder<T> requestsAttach(List<AttachDecorator> requestsAttach) {
            this.requestsAttach = requestsAttach;
            return this;
        }

        public InvitationMessageBuilder<T> service(T service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public InvitationMessageBuilder<T> services(Collection<? extends T> services) {
            if (services == null) {
                throw new NullPointerException("services cannot be null");
            }
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public InvitationMessageBuilder<T> clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this;
        }

        public InvitationMessage<T> build() {
            List services;
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<T>(this.services));
                }
            }
            List<String> handshakeProtocols$value = this.handshakeProtocols$value;
            if (!this.handshakeProtocols$set) {
                handshakeProtocols$value = InvitationMessage.$default$handshakeProtocols();
            }
            return new InvitationMessage(this.atId, this.atType, this.label, this.goalCode, this.goal, this.accept, handshakeProtocols$value, this.requestsAttach, services);
        }

        public String toString() {
            return "InvitationMessage.InvitationMessageBuilder(atId=" + this.atId + ", atType=" + this.atType + ", label=" + this.label + ", goalCode=" + this.goalCode + ", goal=" + this.goal + ", accept=" + this.accept + ", handshakeProtocols$value=" + this.handshakeProtocols$value + ", requestsAttach=" + this.requestsAttach + ", services=" + this.services + ")";
        }
    }

    public static class InvitationMessageService {
        private String did;
        private String id;
        @SerializedName(value="recipientKeys")
        private List<String> recipientKeys;
        @SerializedName(value="routingKeys")
        private List<String> routingKeys;
        @SerializedName(value="serviceEndpoint")
        private String serviceEndpoint;
        private List<String> accept;
        private String type;

        InvitationMessageService(String did, String id, List<String> recipientKeys, List<String> routingKeys, String serviceEndpoint, List<String> accept, String type) {
            this.did = did;
            this.id = id;
            this.recipientKeys = recipientKeys;
            this.routingKeys = routingKeys;
            this.serviceEndpoint = serviceEndpoint;
            this.accept = accept;
            this.type = type;
        }

        public static InvitationMessageServiceBuilder builder() {
            return new InvitationMessageServiceBuilder();
        }

        public String getDid() {
            return this.did;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getRecipientKeys() {
            return this.recipientKeys;
        }

        public List<String> getRoutingKeys() {
            return this.routingKeys;
        }

        public String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public List<String> getAccept() {
            return this.accept;
        }

        public String getType() {
            return this.type;
        }

        public void setDid(String did) {
            this.did = did;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setRecipientKeys(List<String> recipientKeys) {
            this.recipientKeys = recipientKeys;
        }

        public void setRoutingKeys(List<String> routingKeys) {
            this.routingKeys = routingKeys;
        }

        public void setServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public void setAccept(List<String> accept) {
            this.accept = accept;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvitationMessageService)) {
                return false;
            }
            InvitationMessageService other = (InvitationMessageService)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$did = this.getDid();
            String other$did = other.getDid();
            if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$recipientKeys = this.getRecipientKeys();
            List<String> other$recipientKeys = other.getRecipientKeys();
            if (this$recipientKeys == null ? other$recipientKeys != null : !((Object)this$recipientKeys).equals(other$recipientKeys)) {
                return false;
            }
            List<String> this$routingKeys = this.getRoutingKeys();
            List<String> other$routingKeys = other.getRoutingKeys();
            if (this$routingKeys == null ? other$routingKeys != null : !((Object)this$routingKeys).equals(other$routingKeys)) {
                return false;
            }
            String this$serviceEndpoint = this.getServiceEndpoint();
            String other$serviceEndpoint = other.getServiceEndpoint();
            if (this$serviceEndpoint == null ? other$serviceEndpoint != null : !this$serviceEndpoint.equals(other$serviceEndpoint)) {
                return false;
            }
            List<String> this$accept = this.getAccept();
            List<String> other$accept = other.getAccept();
            if (this$accept == null ? other$accept != null : !((Object)this$accept).equals(other$accept)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvitationMessageService;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $did = this.getDid();
            result = result * 59 + ($did == null ? 43 : $did.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $recipientKeys = this.getRecipientKeys();
            result = result * 59 + ($recipientKeys == null ? 43 : ((Object)$recipientKeys).hashCode());
            List<String> $routingKeys = this.getRoutingKeys();
            result = result * 59 + ($routingKeys == null ? 43 : ((Object)$routingKeys).hashCode());
            String $serviceEndpoint = this.getServiceEndpoint();
            result = result * 59 + ($serviceEndpoint == null ? 43 : $serviceEndpoint.hashCode());
            List<String> $accept = this.getAccept();
            result = result * 59 + ($accept == null ? 43 : ((Object)$accept).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "InvitationMessage.InvitationMessageService(did=" + this.getDid() + ", id=" + this.getId() + ", recipientKeys=" + this.getRecipientKeys() + ", routingKeys=" + this.getRoutingKeys() + ", serviceEndpoint=" + this.getServiceEndpoint() + ", accept=" + this.getAccept() + ", type=" + this.getType() + ")";
        }

        public static class InvitationMessageServiceBuilder {
            private String did;
            private String id;
            private List<String> recipientKeys;
            private List<String> routingKeys;
            private String serviceEndpoint;
            private List<String> accept;
            private String type;

            InvitationMessageServiceBuilder() {
            }

            public InvitationMessageServiceBuilder did(String did) {
                this.did = did;
                return this;
            }

            public InvitationMessageServiceBuilder id(String id) {
                this.id = id;
                return this;
            }

            public InvitationMessageServiceBuilder recipientKeys(List<String> recipientKeys) {
                this.recipientKeys = recipientKeys;
                return this;
            }

            public InvitationMessageServiceBuilder routingKeys(List<String> routingKeys) {
                this.routingKeys = routingKeys;
                return this;
            }

            public InvitationMessageServiceBuilder serviceEndpoint(String serviceEndpoint) {
                this.serviceEndpoint = serviceEndpoint;
                return this;
            }

            public InvitationMessageServiceBuilder accept(List<String> accept) {
                this.accept = accept;
                return this;
            }

            public InvitationMessageServiceBuilder type(String type) {
                this.type = type;
                return this;
            }

            public InvitationMessageService build() {
                return new InvitationMessageService(this.did, this.id, this.recipientKeys, this.routingKeys, this.serviceEndpoint, this.accept, this.type);
            }

            public String toString() {
                return "InvitationMessage.InvitationMessageService.InvitationMessageServiceBuilder(did=" + this.did + ", id=" + this.id + ", recipientKeys=" + this.recipientKeys + ", routingKeys=" + this.routingKeys + ", serviceEndpoint=" + this.serviceEndpoint + ", accept=" + this.accept + ", type=" + this.type + ")";
            }
        }
    }
}

