/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.jsonld;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.hyperledger.aries.api.jsonld.LinkedDataProof;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;

@JsonPropertyOrder(value={"@context", "type"})
public class VerifiablePresentation<T extends VerifiableCredential> {
    public static final Type VERIFIABLE_CREDENTIAL_TYPE = new TypeToken<VerifiablePresentation<VerifiableCredential>>(){}.getType();
    public static final Type INDY_CREDENTIAL_TYPE = new TypeToken<VerifiablePresentation<VerifiableCredential.VerifiableIndyCredential>>(){}.getType();
    @Nonnull
    @SerializedName(value="@context")
    @JsonProperty(value="@context")
    @NonNull
    private List<String> context;
    @Nonnull
    @NonNull
    private List<String> type;
    @Nullable
    private String id;
    @Nullable
    @SerializedName(value="verifiableCredential")
    private List<T> verifiableCredential;
    private PresentationSubmission presentationSubmission;
    @Nullable
    private LinkedDataProof proof;

    public List<T> getVerifiableCredential() {
        return this.verifiableCredential != null ? this.verifiableCredential : new ArrayList();
    }

    private static <T extends VerifiableCredential> List<String> $default$context() {
        return List.of("https://www.w3.org/2018/credentials/v1");
    }

    private static <T extends VerifiableCredential> List<String> $default$type() {
        return List.of("VerifiablePresentation");
    }

    public static <T extends VerifiableCredential> VerifiablePresentationBuilder<T> builder() {
        return new VerifiablePresentationBuilder();
    }

    @Nonnull
    @NonNull
    public List<String> getContext() {
        return this.context;
    }

    @Nonnull
    @NonNull
    public List<String> getType() {
        return this.type;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public PresentationSubmission getPresentationSubmission() {
        return this.presentationSubmission;
    }

    @Nullable
    public LinkedDataProof getProof() {
        return this.proof;
    }

    @JsonProperty(value="@context")
    public void setContext(@Nonnull @NonNull List<String> context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    public void setType(@Nonnull @NonNull List<String> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setVerifiableCredential(@Nullable List<T> verifiableCredential) {
        this.verifiableCredential = verifiableCredential;
    }

    public void setPresentationSubmission(PresentationSubmission presentationSubmission) {
        this.presentationSubmission = presentationSubmission;
    }

    public void setProof(@Nullable LinkedDataProof proof) {
        this.proof = proof;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifiablePresentation)) {
            return false;
        }
        VerifiablePresentation other = (VerifiablePresentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$context = this.getContext();
        List<String> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<String> this$type = this.getType();
        List<String> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<T> this$verifiableCredential = this.getVerifiableCredential();
        List<T> other$verifiableCredential = other.getVerifiableCredential();
        if (this$verifiableCredential == null ? other$verifiableCredential != null : !((Object)this$verifiableCredential).equals(other$verifiableCredential)) {
            return false;
        }
        PresentationSubmission this$presentationSubmission = this.getPresentationSubmission();
        PresentationSubmission other$presentationSubmission = other.getPresentationSubmission();
        if (this$presentationSubmission == null ? other$presentationSubmission != null : !((Object)this$presentationSubmission).equals(other$presentationSubmission)) {
            return false;
        }
        LinkedDataProof this$proof = this.getProof();
        LinkedDataProof other$proof = other.getProof();
        return !(this$proof == null ? other$proof != null : !((Object)this$proof).equals(other$proof));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VerifiablePresentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<String> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<T> $verifiableCredential = this.getVerifiableCredential();
        result = result * 59 + ($verifiableCredential == null ? 43 : ((Object)$verifiableCredential).hashCode());
        PresentationSubmission $presentationSubmission = this.getPresentationSubmission();
        result = result * 59 + ($presentationSubmission == null ? 43 : ((Object)$presentationSubmission).hashCode());
        LinkedDataProof $proof = this.getProof();
        result = result * 59 + ($proof == null ? 43 : ((Object)$proof).hashCode());
        return result;
    }

    public String toString() {
        return "VerifiablePresentation(context=" + this.getContext() + ", type=" + this.getType() + ", id=" + this.getId() + ", verifiableCredential=" + this.getVerifiableCredential() + ", presentationSubmission=" + this.getPresentationSubmission() + ", proof=" + this.getProof() + ")";
    }

    public VerifiablePresentation() {
        this.context = VerifiablePresentation.$default$context();
        this.type = VerifiablePresentation.$default$type();
    }

    public VerifiablePresentation(@Nonnull @NonNull List<String> context, @Nonnull @NonNull List<String> type, @Nullable String id, @Nullable List<T> verifiableCredential, PresentationSubmission presentationSubmission, @Nullable LinkedDataProof proof) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.context = context;
        this.type = type;
        this.id = id;
        this.verifiableCredential = verifiableCredential;
        this.presentationSubmission = presentationSubmission;
        this.proof = proof;
    }

    public static class VerifiablePresentationBuilder<T extends VerifiableCredential> {
        private boolean context$set;
        private List<String> context$value;
        private boolean type$set;
        private List<String> type$value;
        private String id;
        private List<T> verifiableCredential;
        private PresentationSubmission presentationSubmission;
        private LinkedDataProof proof;

        VerifiablePresentationBuilder() {
        }

        @JsonProperty(value="@context")
        public VerifiablePresentationBuilder<T> context(@Nonnull @NonNull List<String> context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            this.context$value = context;
            this.context$set = true;
            return this;
        }

        public VerifiablePresentationBuilder<T> type(@Nonnull @NonNull List<String> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public VerifiablePresentationBuilder<T> id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public VerifiablePresentationBuilder<T> verifiableCredential(@Nullable List<T> verifiableCredential) {
            this.verifiableCredential = verifiableCredential;
            return this;
        }

        public VerifiablePresentationBuilder<T> presentationSubmission(PresentationSubmission presentationSubmission) {
            this.presentationSubmission = presentationSubmission;
            return this;
        }

        public VerifiablePresentationBuilder<T> proof(@Nullable LinkedDataProof proof) {
            this.proof = proof;
            return this;
        }

        public VerifiablePresentation<T> build() {
            List<String> context$value = this.context$value;
            if (!this.context$set) {
                context$value = VerifiablePresentation.$default$context();
            }
            List<String> type$value = this.type$value;
            if (!this.type$set) {
                type$value = VerifiablePresentation.$default$type();
            }
            return new VerifiablePresentation<T>(context$value, type$value, this.id, this.verifiableCredential, this.presentationSubmission, this.proof);
        }

        public String toString() {
            return "VerifiablePresentation.VerifiablePresentationBuilder(context$value=" + this.context$value + ", type$value=" + this.type$value + ", id=" + this.id + ", verifiableCredential=" + this.verifiableCredential + ", presentationSubmission=" + this.presentationSubmission + ", proof=" + this.proof + ")";
        }
    }

    public static final class PresentationSubmission {
        private UUID id;
        private UUID definitionId;
        private List<DescriptorMap> descriptorMap = List.of();

        public static PresentationSubmissionBuilder builder() {
            return new PresentationSubmissionBuilder();
        }

        public UUID getId() {
            return this.id;
        }

        public UUID getDefinitionId() {
            return this.definitionId;
        }

        public List<DescriptorMap> getDescriptorMap() {
            return this.descriptorMap;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public void setDefinitionId(UUID definitionId) {
            this.definitionId = definitionId;
        }

        public void setDescriptorMap(List<DescriptorMap> descriptorMap) {
            this.descriptorMap = descriptorMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PresentationSubmission)) {
                return false;
            }
            PresentationSubmission other = (PresentationSubmission)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            UUID this$definitionId = this.getDefinitionId();
            UUID other$definitionId = other.getDefinitionId();
            if (this$definitionId == null ? other$definitionId != null : !((Object)this$definitionId).equals(other$definitionId)) {
                return false;
            }
            List<DescriptorMap> this$descriptorMap = this.getDescriptorMap();
            List<DescriptorMap> other$descriptorMap = other.getDescriptorMap();
            return !(this$descriptorMap == null ? other$descriptorMap != null : !((Object)this$descriptorMap).equals(other$descriptorMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            UUID $definitionId = this.getDefinitionId();
            result = result * 59 + ($definitionId == null ? 43 : ((Object)$definitionId).hashCode());
            List<DescriptorMap> $descriptorMap = this.getDescriptorMap();
            result = result * 59 + ($descriptorMap == null ? 43 : ((Object)$descriptorMap).hashCode());
            return result;
        }

        public String toString() {
            return "VerifiablePresentation.PresentationSubmission(id=" + this.getId() + ", definitionId=" + this.getDefinitionId() + ", descriptorMap=" + this.getDescriptorMap() + ")";
        }

        public PresentationSubmission() {
        }

        public PresentationSubmission(UUID id, UUID definitionId, List<DescriptorMap> descriptorMap) {
            this.id = id;
            this.definitionId = definitionId;
            this.descriptorMap = descriptorMap;
        }

        public static class PresentationSubmissionBuilder {
            private UUID id;
            private UUID definitionId;
            private List<DescriptorMap> descriptorMap;

            PresentationSubmissionBuilder() {
            }

            public PresentationSubmissionBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            public PresentationSubmissionBuilder definitionId(UUID definitionId) {
                this.definitionId = definitionId;
                return this;
            }

            public PresentationSubmissionBuilder descriptorMap(List<DescriptorMap> descriptorMap) {
                this.descriptorMap = descriptorMap;
                return this;
            }

            public PresentationSubmission build() {
                return new PresentationSubmission(this.id, this.definitionId, this.descriptorMap);
            }

            public String toString() {
                return "VerifiablePresentation.PresentationSubmission.PresentationSubmissionBuilder(id=" + this.id + ", definitionId=" + this.definitionId + ", descriptorMap=" + this.descriptorMap + ")";
            }
        }

        public static final class DescriptorMap {
            private static final Pattern PATH_PATTERN = Pattern.compile("^.*?\\[\\D*(\\d+)\\D*].*$");
            private String id;
            private String format;
            private String path;

            public Integer getPathAsIndex() {
                if (this.path == null) {
                    return null;
                }
                Matcher matcher = PATH_PATTERN.matcher(this.path);
                return matcher.find() ? Integer.valueOf(Integer.parseInt(matcher.group(1))) : null;
            }

            public static DescriptorMapBuilder builder() {
                return new DescriptorMapBuilder();
            }

            public String getId() {
                return this.id;
            }

            public String getFormat() {
                return this.format;
            }

            public String getPath() {
                return this.path;
            }

            public void setId(String id) {
                this.id = id;
            }

            public void setFormat(String format) {
                this.format = format;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DescriptorMap)) {
                    return false;
                }
                DescriptorMap other = (DescriptorMap)o;
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$format = this.getFormat();
                String other$format = other.getFormat();
                if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                    return false;
                }
                String this$path = this.getPath();
                String other$path = other.getPath();
                return !(this$path == null ? other$path != null : !this$path.equals(other$path));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $format = this.getFormat();
                result = result * 59 + ($format == null ? 43 : $format.hashCode());
                String $path = this.getPath();
                result = result * 59 + ($path == null ? 43 : $path.hashCode());
                return result;
            }

            public String toString() {
                return "VerifiablePresentation.PresentationSubmission.DescriptorMap(id=" + this.getId() + ", format=" + this.getFormat() + ", path=" + this.getPath() + ")";
            }

            public DescriptorMap() {
            }

            public DescriptorMap(String id, String format, String path) {
                this.id = id;
                this.format = format;
                this.path = path;
            }

            public static class DescriptorMapBuilder {
                private String id;
                private String format;
                private String path;

                DescriptorMapBuilder() {
                }

                public DescriptorMapBuilder id(String id) {
                    this.id = id;
                    return this;
                }

                public DescriptorMapBuilder format(String format) {
                    this.format = format;
                    return this;
                }

                public DescriptorMapBuilder path(String path) {
                    this.path = path;
                    return this;
                }

                public DescriptorMap build() {
                    return new DescriptorMap(this.id, this.format, this.path);
                }

                public String toString() {
                    return "VerifiablePresentation.PresentationSubmission.DescriptorMap.DescriptorMapBuilder(id=" + this.id + ", format=" + this.format + ", path=" + this.path + ")";
                }
            }
        }
    }
}

