/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.jsonld;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.hyperledger.aries.api.jsonld.LinkedDataProof;
import org.hyperledger.aries.api.serializer.JsonObjectDeserializer;
import org.hyperledger.aries.api.serializer.JsonObjectSerializer;

@JsonPropertyOrder(value={"@context", "type"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VerifiableCredential {
    @SerializedName(value="@context")
    @JsonProperty(value="@context")
    @NonNull
    private List<Object> context;
    @SerializedName(value="credentialSubject")
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject credentialSubject;
    @Nullable
    @SerializedName(value="expirationDate")
    private String expirationDate;
    @Nullable
    private String id;
    @Nullable
    @SerializedName(value="issuanceDate")
    private String issuanceDate;
    @Nullable
    private String issuer;
    @Nullable
    private LinkedDataProof proof;
    @NonNull
    private List<String> type;

    public Map<String, String> subjectToFlatMap() {
        return this.credentialSubject == null ? Map.of() : this.credentialSubject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
    }

    private static List<Object> $default$context() {
        return List.of("https://www.w3.org/2018/credentials/v1");
    }

    private static List<String> $default$type() {
        return List.of("VerifiableCredential");
    }

    protected VerifiableCredential(VerifiableCredentialBuilder<?, ?> b) {
        this.context = b.context$set ? b.context$value : VerifiableCredential.$default$context();
        if (this.context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.credentialSubject = b.credentialSubject;
        this.expirationDate = b.expirationDate;
        this.id = b.id;
        this.issuanceDate = b.issuanceDate;
        this.issuer = b.issuer;
        this.proof = b.proof;
        this.type = b.type$set ? b.type$value : VerifiableCredential.$default$type();
        if (this.type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public static VerifiableCredentialBuilder<?, ?> builder() {
        return new VerifiableCredentialBuilderImpl();
    }

    @NonNull
    public List<Object> getContext() {
        return this.context;
    }

    public JsonObject getCredentialSubject() {
        return this.credentialSubject;
    }

    @Nullable
    public String getExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getIssuanceDate() {
        return this.issuanceDate;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    @Nullable
    public LinkedDataProof getProof() {
        return this.proof;
    }

    @NonNull
    public List<String> getType() {
        return this.type;
    }

    @JsonProperty(value="@context")
    public void setContext(@NonNull List<Object> context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    @JsonDeserialize(using=JsonObjectDeserializer.class)
    public void setCredentialSubject(JsonObject credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public void setExpirationDate(@Nullable String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setIssuanceDate(@Nullable String issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public void setIssuer(@Nullable String issuer) {
        this.issuer = issuer;
    }

    public void setProof(@Nullable LinkedDataProof proof) {
        this.proof = proof;
    }

    public void setType(@NonNull List<String> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerifiableCredential)) {
            return false;
        }
        VerifiableCredential other = (VerifiableCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Object> this$context = this.getContext();
        List<Object> other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        JsonObject this$credentialSubject = this.getCredentialSubject();
        JsonObject other$credentialSubject = other.getCredentialSubject();
        if (this$credentialSubject == null ? other$credentialSubject != null : !this$credentialSubject.equals(other$credentialSubject)) {
            return false;
        }
        String this$expirationDate = this.getExpirationDate();
        String other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !this$expirationDate.equals(other$expirationDate)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$issuanceDate = this.getIssuanceDate();
        String other$issuanceDate = other.getIssuanceDate();
        if (this$issuanceDate == null ? other$issuanceDate != null : !this$issuanceDate.equals(other$issuanceDate)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        LinkedDataProof this$proof = this.getProof();
        LinkedDataProof other$proof = other.getProof();
        if (this$proof == null ? other$proof != null : !((Object)this$proof).equals(other$proof)) {
            return false;
        }
        List<String> this$type = this.getType();
        List<String> other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VerifiableCredential;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Object> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        JsonObject $credentialSubject = this.getCredentialSubject();
        result = result * 59 + ($credentialSubject == null ? 43 : $credentialSubject.hashCode());
        String $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : $expirationDate.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $issuanceDate = this.getIssuanceDate();
        result = result * 59 + ($issuanceDate == null ? 43 : $issuanceDate.hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        LinkedDataProof $proof = this.getProof();
        result = result * 59 + ($proof == null ? 43 : ((Object)$proof).hashCode());
        List<String> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public String toString() {
        return "VerifiableCredential(context=" + this.getContext() + ", credentialSubject=" + this.getCredentialSubject() + ", expirationDate=" + this.getExpirationDate() + ", id=" + this.getId() + ", issuanceDate=" + this.getIssuanceDate() + ", issuer=" + this.getIssuer() + ", proof=" + this.getProof() + ", type=" + this.getType() + ")";
    }

    public VerifiableCredential() {
        this.context = VerifiableCredential.$default$context();
        this.type = VerifiableCredential.$default$type();
    }

    public VerifiableCredential(@NonNull List<Object> context, JsonObject credentialSubject, @Nullable String expirationDate, @Nullable String id, @Nullable String issuanceDate, @Nullable String issuer, @Nullable LinkedDataProof proof, @NonNull List<String> type) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.context = context;
        this.credentialSubject = credentialSubject;
        this.expirationDate = expirationDate;
        this.id = id;
        this.issuanceDate = issuanceDate;
        this.issuer = issuer;
        this.proof = proof;
        this.type = type;
    }

    private static final class VerifiableCredentialBuilderImpl
    extends VerifiableCredentialBuilder<VerifiableCredential, VerifiableCredentialBuilderImpl> {
        private VerifiableCredentialBuilderImpl() {
        }

        @Override
        protected VerifiableCredentialBuilderImpl self() {
            return this;
        }

        @Override
        public VerifiableCredential build() {
            return new VerifiableCredential(this);
        }
    }

    public static abstract class VerifiableCredentialBuilder<C extends VerifiableCredential, B extends VerifiableCredentialBuilder<C, B>> {
        private boolean context$set;
        private List<Object> context$value;
        private JsonObject credentialSubject;
        private String expirationDate;
        private String id;
        private String issuanceDate;
        private String issuer;
        private LinkedDataProof proof;
        private boolean type$set;
        private List<String> type$value;

        protected abstract B self();

        public abstract C build();

        @JsonProperty(value="@context")
        public B context(@NonNull List<Object> context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            this.context$value = context;
            this.context$set = true;
            return this.self();
        }

        @JsonDeserialize(using=JsonObjectDeserializer.class)
        public B credentialSubject(JsonObject credentialSubject) {
            this.credentialSubject = credentialSubject;
            return this.self();
        }

        public B expirationDate(@Nullable String expirationDate) {
            this.expirationDate = expirationDate;
            return this.self();
        }

        public B id(@Nullable String id) {
            this.id = id;
            return this.self();
        }

        public B issuanceDate(@Nullable String issuanceDate) {
            this.issuanceDate = issuanceDate;
            return this.self();
        }

        public B issuer(@Nullable String issuer) {
            this.issuer = issuer;
            return this.self();
        }

        public B proof(@Nullable LinkedDataProof proof) {
            this.proof = proof;
            return this.self();
        }

        public B type(@NonNull List<String> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this.self();
        }

        public String toString() {
            return "VerifiableCredential.VerifiableCredentialBuilder(context$value=" + this.context$value + ", credentialSubject=" + this.credentialSubject + ", expirationDate=" + this.expirationDate + ", id=" + this.id + ", issuanceDate=" + this.issuanceDate + ", issuer=" + this.issuer + ", proof=" + this.proof + ", type$value=" + this.type$value + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VerifiableCredentialMatch
    extends VerifiableCredential {
        private String recordId;

        protected VerifiableCredentialMatch(VerifiableCredentialMatchBuilder<?, ?> b) {
            super(b);
            this.recordId = b.recordId;
        }

        public static VerifiableCredentialMatchBuilder<?, ?> builder() {
            return new VerifiableCredentialMatchBuilderImpl();
        }

        public VerifiableCredentialMatch() {
        }

        public VerifiableCredentialMatch(String recordId) {
            this.recordId = recordId;
        }

        public String getRecordId() {
            return this.recordId;
        }

        public void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifiableCredentialMatch)) {
                return false;
            }
            VerifiableCredentialMatch other = (VerifiableCredentialMatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$recordId = this.getRecordId();
            String other$recordId = other.getRecordId();
            return !(this$recordId == null ? other$recordId != null : !this$recordId.equals(other$recordId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof VerifiableCredentialMatch;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $recordId = this.getRecordId();
            result = result * 59 + ($recordId == null ? 43 : $recordId.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "VerifiableCredential.VerifiableCredentialMatch(super=" + super.toString() + ", recordId=" + this.getRecordId() + ")";
        }

        private static final class VerifiableCredentialMatchBuilderImpl
        extends VerifiableCredentialMatchBuilder<VerifiableCredentialMatch, VerifiableCredentialMatchBuilderImpl> {
            private VerifiableCredentialMatchBuilderImpl() {
            }

            @Override
            protected VerifiableCredentialMatchBuilderImpl self() {
                return this;
            }

            @Override
            public VerifiableCredentialMatch build() {
                return new VerifiableCredentialMatch(this);
            }
        }

        public static abstract class VerifiableCredentialMatchBuilder<C extends VerifiableCredentialMatch, B extends VerifiableCredentialMatchBuilder<C, B>>
        extends VerifiableCredentialBuilder<C, B> {
            private String recordId;

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            public B recordId(String recordId) {
                this.recordId = recordId;
                return (B)this.self();
            }

            @Override
            public String toString() {
                return "VerifiableCredential.VerifiableCredentialMatch.VerifiableCredentialMatchBuilder(super=" + super.toString() + ", recordId=" + this.recordId + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class VerifiableIndyCredential
    extends LabeledVerifiableCredential {
        @Nullable
        @SerializedName(value="indyIssuer")
        private String indyIssuer;
        @Nullable
        @SerializedName(value="schemaId")
        private String schemaId;
        @Nullable
        @SerializedName(value="credDefId")
        private String credDefId;

        protected VerifiableIndyCredential(VerifiableIndyCredentialBuilder<?, ?> b) {
            super((LabeledVerifiableCredential.LabeledVerifiableCredentialBuilder<?, ?>)b);
            this.indyIssuer = b.indyIssuer;
            this.schemaId = b.schemaId;
            this.credDefId = b.credDefId;
        }

        public static VerifiableIndyCredentialBuilder<?, ?> builder() {
            return new VerifiableIndyCredentialBuilderImpl();
        }

        public VerifiableIndyCredential() {
        }

        public VerifiableIndyCredential(@Nullable String indyIssuer, @Nullable String schemaId, @Nullable String credDefId) {
            this.indyIssuer = indyIssuer;
            this.schemaId = schemaId;
            this.credDefId = credDefId;
        }

        @Nullable
        public String getIndyIssuer() {
            return this.indyIssuer;
        }

        @Nullable
        public String getSchemaId() {
            return this.schemaId;
        }

        @Nullable
        public String getCredDefId() {
            return this.credDefId;
        }

        public void setIndyIssuer(@Nullable String indyIssuer) {
            this.indyIssuer = indyIssuer;
        }

        public void setSchemaId(@Nullable String schemaId) {
            this.schemaId = schemaId;
        }

        public void setCredDefId(@Nullable String credDefId) {
            this.credDefId = credDefId;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifiableIndyCredential)) {
                return false;
            }
            VerifiableIndyCredential other = (VerifiableIndyCredential)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$indyIssuer = this.getIndyIssuer();
            String other$indyIssuer = other.getIndyIssuer();
            if (this$indyIssuer == null ? other$indyIssuer != null : !this$indyIssuer.equals(other$indyIssuer)) {
                return false;
            }
            String this$schemaId = this.getSchemaId();
            String other$schemaId = other.getSchemaId();
            if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                return false;
            }
            String this$credDefId = this.getCredDefId();
            String other$credDefId = other.getCredDefId();
            return !(this$credDefId == null ? other$credDefId != null : !this$credDefId.equals(other$credDefId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof VerifiableIndyCredential;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $indyIssuer = this.getIndyIssuer();
            result = result * 59 + ($indyIssuer == null ? 43 : $indyIssuer.hashCode());
            String $schemaId = this.getSchemaId();
            result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
            String $credDefId = this.getCredDefId();
            result = result * 59 + ($credDefId == null ? 43 : $credDefId.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "VerifiableCredential.VerifiableIndyCredential(super=" + super.toString() + ", indyIssuer=" + this.getIndyIssuer() + ", schemaId=" + this.getSchemaId() + ", credDefId=" + this.getCredDefId() + ")";
        }

        private static final class VerifiableIndyCredentialBuilderImpl
        extends VerifiableIndyCredentialBuilder<VerifiableIndyCredential, VerifiableIndyCredentialBuilderImpl> {
            private VerifiableIndyCredentialBuilderImpl() {
            }

            @Override
            protected VerifiableIndyCredentialBuilderImpl self() {
                return this;
            }

            @Override
            public VerifiableIndyCredential build() {
                return new VerifiableIndyCredential(this);
            }
        }

        public static abstract class VerifiableIndyCredentialBuilder<C extends VerifiableIndyCredential, B extends VerifiableIndyCredentialBuilder<C, B>>
        extends LabeledVerifiableCredential.LabeledVerifiableCredentialBuilder<C, B> {
            private String indyIssuer;
            private String schemaId;
            private String credDefId;

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            public B indyIssuer(@Nullable String indyIssuer) {
                this.indyIssuer = indyIssuer;
                return (B)this.self();
            }

            public B schemaId(@Nullable String schemaId) {
                this.schemaId = schemaId;
                return (B)this.self();
            }

            public B credDefId(@Nullable String credDefId) {
                this.credDefId = credDefId;
                return (B)this.self();
            }

            @Override
            public String toString() {
                return "VerifiableCredential.VerifiableIndyCredential.VerifiableIndyCredentialBuilder(super=" + super.toString() + ", indyIssuer=" + this.indyIssuer + ", schemaId=" + this.schemaId + ", credDefId=" + this.credDefId + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class LabeledVerifiableCredential
    extends VerifiableCredential {
        private String label;

        protected LabeledVerifiableCredential(LabeledVerifiableCredentialBuilder<?, ?> b) {
            super(b);
            this.label = b.label;
        }

        public static LabeledVerifiableCredentialBuilder<?, ?> builder() {
            return new LabeledVerifiableCredentialBuilderImpl();
        }

        public LabeledVerifiableCredential() {
        }

        public LabeledVerifiableCredential(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LabeledVerifiableCredential)) {
                return false;
            }
            LabeledVerifiableCredential other = (LabeledVerifiableCredential)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !this$label.equals(other$label));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LabeledVerifiableCredential;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "VerifiableCredential.LabeledVerifiableCredential(super=" + super.toString() + ", label=" + this.getLabel() + ")";
        }

        private static final class LabeledVerifiableCredentialBuilderImpl
        extends LabeledVerifiableCredentialBuilder<LabeledVerifiableCredential, LabeledVerifiableCredentialBuilderImpl> {
            private LabeledVerifiableCredentialBuilderImpl() {
            }

            @Override
            protected LabeledVerifiableCredentialBuilderImpl self() {
                return this;
            }

            @Override
            public LabeledVerifiableCredential build() {
                return new LabeledVerifiableCredential(this);
            }
        }

        public static abstract class LabeledVerifiableCredentialBuilder<C extends LabeledVerifiableCredential, B extends LabeledVerifiableCredentialBuilder<C, B>>
        extends VerifiableCredentialBuilder<C, B> {
            private String label;

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            public B label(String label) {
                this.label = label;
                return (B)this.self();
            }

            @Override
            public String toString() {
                return "VerifiableCredential.LabeledVerifiableCredential.LabeledVerifiableCredentialBuilder(super=" + super.toString() + ", label=" + this.label + ")";
            }
        }
    }
}

