/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.jsonld;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.api.jsonld.VerifiablePresentation;
import org.hyperledger.aries.config.GsonConfig;

public final class SignRequest {
    @Nonnull
    @NonNull
    private String verkey;
    @Nonnull
    @NonNull
    private SignDocument doc;

    public static SignRequest from(String verkey, Object t, SignDocument.Options options) {
        if (t instanceof VerifiableCredential || t instanceof VerifiablePresentation) {
            Gson gson = GsonConfig.defaultConfig();
            return SignRequest.builder().verkey(verkey).doc(SignDocument.builder().credential(gson.toJsonTree(t).getAsJsonObject()).options(options).build()).build();
        }
        throw new IllegalStateException("Expecting either VerifiableCredential or VerifiablePresentation");
    }

    SignRequest(@Nonnull @NonNull String verkey, @Nonnull @NonNull SignDocument doc) {
        if (verkey == null) {
            throw new NullPointerException("verkey is marked non-null but is null");
        }
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        this.verkey = verkey;
        this.doc = doc;
    }

    public static SignRequestBuilder builder() {
        return new SignRequestBuilder();
    }

    @Nonnull
    @NonNull
    public String getVerkey() {
        return this.verkey;
    }

    @Nonnull
    @NonNull
    public SignDocument getDoc() {
        return this.doc;
    }

    public void setVerkey(@Nonnull @NonNull String verkey) {
        if (verkey == null) {
            throw new NullPointerException("verkey is marked non-null but is null");
        }
        this.verkey = verkey;
    }

    public void setDoc(@Nonnull @NonNull SignDocument doc) {
        if (doc == null) {
            throw new NullPointerException("doc is marked non-null but is null");
        }
        this.doc = doc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignRequest)) {
            return false;
        }
        SignRequest other = (SignRequest)o;
        String this$verkey = this.getVerkey();
        String other$verkey = other.getVerkey();
        if (this$verkey == null ? other$verkey != null : !this$verkey.equals(other$verkey)) {
            return false;
        }
        SignDocument this$doc = this.getDoc();
        SignDocument other$doc = other.getDoc();
        return !(this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $verkey = this.getVerkey();
        result = result * 59 + ($verkey == null ? 43 : $verkey.hashCode());
        SignDocument $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        return result;
    }

    public String toString() {
        return "SignRequest(verkey=" + this.getVerkey() + ", doc=" + this.getDoc() + ")";
    }

    public static class SignRequestBuilder {
        private String verkey;
        private SignDocument doc;

        SignRequestBuilder() {
        }

        public SignRequestBuilder verkey(@Nonnull @NonNull String verkey) {
            if (verkey == null) {
                throw new NullPointerException("verkey is marked non-null but is null");
            }
            this.verkey = verkey;
            return this;
        }

        public SignRequestBuilder doc(@Nonnull @NonNull SignDocument doc) {
            if (doc == null) {
                throw new NullPointerException("doc is marked non-null but is null");
            }
            this.doc = doc;
            return this;
        }

        public SignRequest build() {
            return new SignRequest(this.verkey, this.doc);
        }

        public String toString() {
            return "SignRequest.SignRequestBuilder(verkey=" + this.verkey + ", doc=" + this.doc + ")";
        }
    }

    public static final class SignDocument {
        @Nonnull
        @NonNull
        private JsonObject credential;
        @Nonnull
        @NonNull
        private Options options;

        SignDocument(@Nonnull @NonNull JsonObject credential, @Nonnull @NonNull Options options) {
            if (credential == null) {
                throw new NullPointerException("credential is marked non-null but is null");
            }
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.credential = credential;
            this.options = options;
        }

        public static SignDocumentBuilder builder() {
            return new SignDocumentBuilder();
        }

        @Nonnull
        @NonNull
        public JsonObject getCredential() {
            return this.credential;
        }

        @Nonnull
        @NonNull
        public Options getOptions() {
            return this.options;
        }

        public void setCredential(@Nonnull @NonNull JsonObject credential) {
            if (credential == null) {
                throw new NullPointerException("credential is marked non-null but is null");
            }
            this.credential = credential;
        }

        public void setOptions(@Nonnull @NonNull Options options) {
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            this.options = options;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignDocument)) {
                return false;
            }
            SignDocument other = (SignDocument)o;
            JsonObject this$credential = this.getCredential();
            JsonObject other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
                return false;
            }
            Options this$options = this.getOptions();
            Options other$options = other.getOptions();
            return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JsonObject $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            Options $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            return result;
        }

        public String toString() {
            return "SignRequest.SignDocument(credential=" + this.getCredential() + ", options=" + this.getOptions() + ")";
        }

        public static class SignDocumentBuilder {
            private JsonObject credential;
            private Options options;

            SignDocumentBuilder() {
            }

            public SignDocumentBuilder credential(@Nonnull @NonNull JsonObject credential) {
                if (credential == null) {
                    throw new NullPointerException("credential is marked non-null but is null");
                }
                this.credential = credential;
                return this;
            }

            public SignDocumentBuilder options(@Nonnull @NonNull Options options) {
                if (options == null) {
                    throw new NullPointerException("options is marked non-null but is null");
                }
                this.options = options;
                return this;
            }

            public SignDocument build() {
                return new SignDocument(this.credential, this.options);
            }

            public String toString() {
                return "SignRequest.SignDocument.SignDocumentBuilder(credential=" + this.credential + ", options=" + this.options + ")";
            }
        }

        public static final class Options {
            @Nullable
            private String creator;
            @Nullable
            @SerializedName(value="verificationMethod")
            private String verificationMethod;
            @Nullable
            @SerializedName(value="proofPurpose")
            private String proofPurpose;
            private String type;

            public static OptionsBuilder builderWithDefaults() {
                return Options.builder().type("Ed25519Signature2018").proofPurpose("authentication");
            }

            Options(@Nullable String creator, @Nullable String verificationMethod, @Nullable String proofPurpose, String type) {
                this.creator = creator;
                this.verificationMethod = verificationMethod;
                this.proofPurpose = proofPurpose;
                this.type = type;
            }

            public static OptionsBuilder builder() {
                return new OptionsBuilder();
            }

            @Nullable
            public String getCreator() {
                return this.creator;
            }

            @Nullable
            public String getVerificationMethod() {
                return this.verificationMethod;
            }

            @Nullable
            public String getProofPurpose() {
                return this.proofPurpose;
            }

            public String getType() {
                return this.type;
            }

            public void setCreator(@Nullable String creator) {
                this.creator = creator;
            }

            public void setVerificationMethod(@Nullable String verificationMethod) {
                this.verificationMethod = verificationMethod;
            }

            public void setProofPurpose(@Nullable String proofPurpose) {
                this.proofPurpose = proofPurpose;
            }

            public void setType(String type) {
                this.type = type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Options)) {
                    return false;
                }
                Options other = (Options)o;
                String this$creator = this.getCreator();
                String other$creator = other.getCreator();
                if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
                    return false;
                }
                String this$verificationMethod = this.getVerificationMethod();
                String other$verificationMethod = other.getVerificationMethod();
                if (this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod)) {
                    return false;
                }
                String this$proofPurpose = this.getProofPurpose();
                String other$proofPurpose = other.getProofPurpose();
                if (this$proofPurpose == null ? other$proofPurpose != null : !this$proofPurpose.equals(other$proofPurpose)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $creator = this.getCreator();
                result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
                String $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                String $proofPurpose = this.getProofPurpose();
                result = result * 59 + ($proofPurpose == null ? 43 : $proofPurpose.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "SignRequest.SignDocument.Options(creator=" + this.getCreator() + ", verificationMethod=" + this.getVerificationMethod() + ", proofPurpose=" + this.getProofPurpose() + ", type=" + this.getType() + ")";
            }

            public static class OptionsBuilder {
                private String creator;
                private String verificationMethod;
                private String proofPurpose;
                private String type;

                OptionsBuilder() {
                }

                public OptionsBuilder creator(@Nullable String creator) {
                    this.creator = creator;
                    return this;
                }

                public OptionsBuilder verificationMethod(@Nullable String verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }

                public OptionsBuilder proofPurpose(@Nullable String proofPurpose) {
                    this.proofPurpose = proofPurpose;
                    return this;
                }

                public OptionsBuilder type(String type) {
                    this.type = type;
                    return this;
                }

                public Options build() {
                    return new Options(this.creator, this.verificationMethod, this.proofPurpose, this.type);
                }

                public String toString() {
                    return "SignRequest.SignDocument.Options.OptionsBuilder(creator=" + this.creator + ", verificationMethod=" + this.verificationMethod + ", proofPurpose=" + this.proofPurpose + ", type=" + this.type + ")";
                }
            }
        }
    }
}

