/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v2;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.hyperledger.aries.api.credentials.Credential;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecordByFormat;
import org.hyperledger.aries.api.issue_credential_v2.V20CredProposal;
import org.hyperledger.aries.config.GsonConfig;

public class V2ToV1IndyCredentialConverter {
    private final Gson gson = GsonConfig.defaultConfig();

    public static V2ToV1IndyCredentialConverter INSTANCE() {
        return new V2ToV1IndyCredentialConverter();
    }

    public V1CredentialExchange toV1Proposal(@NonNull V20CredExRecord v2Record) {
        if (v2Record == null) {
            throw new NullPointerException("v2Record is marked non-null but is null");
        }
        V20CredExRecordByFormat byFormat = v2Record.getByFormat();
        V20CredProposal credProposal = v2Record.getCredProposal();
        return ((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)v2Record.toV1Builder().schemaId(byFormat != null ? byFormat.findSchemaIdInIndyProposal() : null)).credentialProposalDict(V1CredentialExchange.CredentialProposalDict.builder().schemaId(byFormat != null ? byFormat.findSchemaIdInIndyProposal() : null).credentialProposal(V1CredentialExchange.CredentialProposalDict.CredentialProposal.builder().attributes(credProposal.getCredentialPreview() != null ? credProposal.getCredentialPreview().getAttributes() : null).build()).build())).build();
    }

    public V1CredentialExchange toV1Offer(@NonNull V20CredExRecord v2Record) {
        if (v2Record == null) {
            throw new NullPointerException("v2Record is marked non-null but is null");
        }
        IdWrapper ids = this.getIdsFromOffer(v2Record);
        return ((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)v2Record.toV1Builder().credentialDefinitionId(ids.getCredentialDefinitionId())).schemaId(ids.getSchemaId())).credentialProposalDict(V1CredentialExchange.CredentialProposalDict.builder().schemaId(ids.getSchemaId()).credDefId(ids.getCredentialDefinitionId()).credentialProposal(V1CredentialExchange.CredentialProposalDict.CredentialProposal.builder().attributes(v2Record.getCredOffer() != null && v2Record.getCredOffer().getCredentialPreview() != null ? v2Record.getCredOffer().getCredentialPreview().getAttributes() : null).build()).build())).build();
    }

    public Optional<Credential> toV1Credential(@NonNull V20CredExRecord v2Record) {
        JsonElement values;
        JsonElement typeIndy;
        if (v2Record == null) {
            throw new NullPointerException("v2Record is marked non-null but is null");
        }
        Optional<JsonObject> credential = this.getIndyCredential(v2Record);
        if (credential.isPresent() && (typeIndy = credential.get().get("indy")) != null && (values = typeIndy.getAsJsonObject().get("values")) != null) {
            Set entries = values.getAsJsonObject().entrySet();
            Map<String, String> raw = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, v -> this.getRawValue((JsonElement)v.getValue())));
            Credential v1Credential = (Credential)this.gson.fromJson(typeIndy, Credential.class);
            v1Credential.setAttrs(raw);
            return Optional.of(v1Credential);
        }
        return Optional.empty();
    }

    private Optional<JsonObject> getIndyCredential(@NonNull V20CredExRecord indy) {
        if (indy == null) {
            throw new NullPointerException("indy is marked non-null but is null");
        }
        if (indy.getByFormat() != null && indy.getByFormat().getCredIssue() != null) {
            return Optional.of(indy.getByFormat().getCredIssue());
        }
        return Optional.empty();
    }

    private IdWrapper getIdsFromOffer(@NonNull V20CredExRecord indy) {
        JsonObject typeIndy;
        JsonObject offer;
        if (indy == null) {
            throw new NullPointerException("indy is marked non-null but is null");
        }
        IdWrapper.IdWrapperBuilder b = IdWrapper.builder();
        if (indy.getByFormat() != null && indy.getByFormat().getCredOffer() != null && (offer = indy.getByFormat().getCredOffer()) != null && (typeIndy = offer.getAsJsonObject("indy")) != null) {
            b.schemaId(typeIndy.get("schema_id").getAsString());
            b.credentialDefinitionId(typeIndy.get("cred_def_id").getAsString());
        }
        return b.build();
    }

    private String getRawValue(@NonNull JsonElement el) {
        if (el == null) {
            throw new NullPointerException("el is marked non-null but is null");
        }
        JsonElement raw = el.getAsJsonObject().get("raw");
        if (raw != null) {
            return raw.getAsString();
        }
        return "";
    }

    private static final class IdWrapper {
        private String schemaId;
        private String credentialDefinitionId;

        IdWrapper(String schemaId, String credentialDefinitionId) {
            this.schemaId = schemaId;
            this.credentialDefinitionId = credentialDefinitionId;
        }

        public static IdWrapperBuilder builder() {
            return new IdWrapperBuilder();
        }

        public String getSchemaId() {
            return this.schemaId;
        }

        public String getCredentialDefinitionId() {
            return this.credentialDefinitionId;
        }

        public void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        public void setCredentialDefinitionId(String credentialDefinitionId) {
            this.credentialDefinitionId = credentialDefinitionId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdWrapper)) {
                return false;
            }
            IdWrapper other = (IdWrapper)o;
            String this$schemaId = this.getSchemaId();
            String other$schemaId = other.getSchemaId();
            if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                return false;
            }
            String this$credentialDefinitionId = this.getCredentialDefinitionId();
            String other$credentialDefinitionId = other.getCredentialDefinitionId();
            return !(this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $schemaId = this.getSchemaId();
            result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
            String $credentialDefinitionId = this.getCredentialDefinitionId();
            result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
            return result;
        }

        public String toString() {
            return "V2ToV1IndyCredentialConverter.IdWrapper(schemaId=" + this.getSchemaId() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ")";
        }

        public static class IdWrapperBuilder {
            private String schemaId;
            private String credentialDefinitionId;

            IdWrapperBuilder() {
            }

            public IdWrapperBuilder schemaId(String schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            public IdWrapperBuilder credentialDefinitionId(String credentialDefinitionId) {
                this.credentialDefinitionId = credentialDefinitionId;
                return this;
            }

            public IdWrapper build() {
                return new IdWrapper(this.schemaId, this.credentialDefinitionId);
            }

            public String toString() {
                return "V2ToV1IndyCredentialConverter.IdWrapper.IdWrapperBuilder(schemaId=" + this.schemaId + ", credentialDefinitionId=" + this.credentialDefinitionId + ")";
            }
        }
    }
}

