/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hyperledger.aries.api.issue_credential_v2.V2CredentialExchangeFree;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.config.GsonConfig;

public class V20CredExRecordByFormat {
    public static final String INDY = "indy";
    public static final String LD_PROOF = "ld_proof";
    private JsonObject credProposal;
    private JsonObject credOffer;
    private JsonObject credRequest;
    private JsonObject credIssue;

    public String findSchemaIdInIndyProposal() {
        JsonObject indy;
        String result = null;
        if (this.credProposal != null && (indy = this.resolveIndyPayload(this.credProposal)) != null) {
            result = indy.getAsJsonObject().get("schema_id").getAsString();
        }
        return result;
    }

    public Optional<Map<String, String>> findValuesInIndyCredIssue() {
        JsonObject indy;
        if (this.credIssue != null && (indy = this.resolveIndyPayload(this.credIssue)) != null) {
            Set attrs = indy.getAsJsonObject("values").entrySet();
            return Optional.of(attrs.stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsJsonObject().get("raw").getAsString())));
        }
        return Optional.empty();
    }

    public boolean hasIndyPayload() {
        return this.resolveIndyPayload(this.credProposal) != null || this.resolveIndyPayload(this.credOffer) != null || this.resolveIndyPayload(this.credRequest) != null || this.resolveIndyPayload(this.credIssue) != null;
    }

    public boolean hasLdProof() {
        return this.resolveLdPayload(this.credProposal) != null || this.resolveLdPayload(this.credOffer) != null || this.resolveLdPayload(this.credRequest) != null || this.resolveLdPayload(this.credIssue) != null;
    }

    public LdProof convertToLdProof(JsonObject jo) {
        return this.convertToLdProof(jo, LdProof.class);
    }

    public <T> T convertToLdProof(JsonObject jo, Class<T> type) {
        JsonObject ld = jo.getAsJsonObject(LD_PROOF);
        return (T)GsonConfig.defaultConfig().fromJson((JsonElement)ld, type);
    }

    private JsonObject resolveLdPayload(JsonObject jo) {
        return jo != null ? jo.getAsJsonObject(LD_PROOF) : null;
    }

    private JsonObject resolveIndyPayload(JsonObject jo) {
        return jo != null ? jo.getAsJsonObject(INDY) : null;
    }

    public static V20CredExRecordByFormatBuilder builder() {
        return new V20CredExRecordByFormatBuilder();
    }

    public JsonObject getCredProposal() {
        return this.credProposal;
    }

    public JsonObject getCredOffer() {
        return this.credOffer;
    }

    public JsonObject getCredRequest() {
        return this.credRequest;
    }

    public JsonObject getCredIssue() {
        return this.credIssue;
    }

    public void setCredProposal(JsonObject credProposal) {
        this.credProposal = credProposal;
    }

    public void setCredOffer(JsonObject credOffer) {
        this.credOffer = credOffer;
    }

    public void setCredRequest(JsonObject credRequest) {
        this.credRequest = credRequest;
    }

    public void setCredIssue(JsonObject credIssue) {
        this.credIssue = credIssue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V20CredExRecordByFormat)) {
            return false;
        }
        V20CredExRecordByFormat other = (V20CredExRecordByFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonObject this$credProposal = this.getCredProposal();
        JsonObject other$credProposal = other.getCredProposal();
        if (this$credProposal == null ? other$credProposal != null : !this$credProposal.equals(other$credProposal)) {
            return false;
        }
        JsonObject this$credOffer = this.getCredOffer();
        JsonObject other$credOffer = other.getCredOffer();
        if (this$credOffer == null ? other$credOffer != null : !this$credOffer.equals(other$credOffer)) {
            return false;
        }
        JsonObject this$credRequest = this.getCredRequest();
        JsonObject other$credRequest = other.getCredRequest();
        if (this$credRequest == null ? other$credRequest != null : !this$credRequest.equals(other$credRequest)) {
            return false;
        }
        JsonObject this$credIssue = this.getCredIssue();
        JsonObject other$credIssue = other.getCredIssue();
        return !(this$credIssue == null ? other$credIssue != null : !this$credIssue.equals(other$credIssue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V20CredExRecordByFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonObject $credProposal = this.getCredProposal();
        result = result * 59 + ($credProposal == null ? 43 : $credProposal.hashCode());
        JsonObject $credOffer = this.getCredOffer();
        result = result * 59 + ($credOffer == null ? 43 : $credOffer.hashCode());
        JsonObject $credRequest = this.getCredRequest();
        result = result * 59 + ($credRequest == null ? 43 : $credRequest.hashCode());
        JsonObject $credIssue = this.getCredIssue();
        result = result * 59 + ($credIssue == null ? 43 : $credIssue.hashCode());
        return result;
    }

    public String toString() {
        return "V20CredExRecordByFormat(credProposal=" + this.getCredProposal() + ", credOffer=" + this.getCredOffer() + ", credRequest=" + this.getCredRequest() + ", credIssue=" + this.getCredIssue() + ")";
    }

    public V20CredExRecordByFormat(JsonObject credProposal, JsonObject credOffer, JsonObject credRequest, JsonObject credIssue) {
        this.credProposal = credProposal;
        this.credOffer = credOffer;
        this.credRequest = credRequest;
        this.credIssue = credIssue;
    }

    public V20CredExRecordByFormat() {
    }

    public static class V20CredExRecordByFormatBuilder {
        private JsonObject credProposal;
        private JsonObject credOffer;
        private JsonObject credRequest;
        private JsonObject credIssue;

        V20CredExRecordByFormatBuilder() {
        }

        public V20CredExRecordByFormatBuilder credProposal(JsonObject credProposal) {
            this.credProposal = credProposal;
            return this;
        }

        public V20CredExRecordByFormatBuilder credOffer(JsonObject credOffer) {
            this.credOffer = credOffer;
            return this;
        }

        public V20CredExRecordByFormatBuilder credRequest(JsonObject credRequest) {
            this.credRequest = credRequest;
            return this;
        }

        public V20CredExRecordByFormatBuilder credIssue(JsonObject credIssue) {
            this.credIssue = credIssue;
            return this;
        }

        public V20CredExRecordByFormat build() {
            return new V20CredExRecordByFormat(this.credProposal, this.credOffer, this.credRequest, this.credIssue);
        }

        public String toString() {
            return "V20CredExRecordByFormat.V20CredExRecordByFormatBuilder(credProposal=" + this.credProposal + ", credOffer=" + this.credOffer + ", credRequest=" + this.credRequest + ", credIssue=" + this.credIssue + ")";
        }
    }

    public static class LdProof {
        private VerifiableCredential credential;
        private V2CredentialExchangeFree.LDProofVCDetailOptions options;

        public Map<String, String> toFlatMap() {
            return this.credential == null ? Map.of() : this.credential.subjectToFlatMap();
        }

        public static LdProofBuilder builder() {
            return new LdProofBuilder();
        }

        public VerifiableCredential getCredential() {
            return this.credential;
        }

        public V2CredentialExchangeFree.LDProofVCDetailOptions getOptions() {
            return this.options;
        }

        public void setCredential(VerifiableCredential credential) {
            this.credential = credential;
        }

        public void setOptions(V2CredentialExchangeFree.LDProofVCDetailOptions options) {
            this.options = options;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LdProof)) {
                return false;
            }
            LdProof other = (LdProof)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VerifiableCredential this$credential = this.getCredential();
            VerifiableCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            V2CredentialExchangeFree.LDProofVCDetailOptions this$options = this.getOptions();
            V2CredentialExchangeFree.LDProofVCDetailOptions other$options = other.getOptions();
            return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LdProof;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VerifiableCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            V2CredentialExchangeFree.LDProofVCDetailOptions $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            return result;
        }

        public String toString() {
            return "V20CredExRecordByFormat.LdProof(credential=" + this.getCredential() + ", options=" + this.getOptions() + ")";
        }

        public LdProof(VerifiableCredential credential, V2CredentialExchangeFree.LDProofVCDetailOptions options) {
            this.credential = credential;
            this.options = options;
        }

        public LdProof() {
        }

        public static class LdProofBuilder {
            private VerifiableCredential credential;
            private V2CredentialExchangeFree.LDProofVCDetailOptions options;

            LdProofBuilder() {
            }

            public LdProofBuilder credential(VerifiableCredential credential) {
                this.credential = credential;
                return this;
            }

            public LdProofBuilder options(V2CredentialExchangeFree.LDProofVCDetailOptions options) {
                this.options = options;
                return this;
            }

            public LdProof build() {
                return new LdProof(this.credential, this.options);
            }

            public String toString() {
                return "V20CredExRecordByFormat.LdProof.LdProofBuilder(credential=" + this.credential + ", options=" + this.options + ")";
            }
        }
    }
}

