/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v2;

import org.hyperledger.acy_py.generated.model.V20CredIssue;
import org.hyperledger.acy_py.generated.model.V20CredPreview;
import org.hyperledger.acy_py.generated.model.V20CredRequest;
import org.hyperledger.aries.api.issue_credential_v1.BaseCredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecordByFormat;
import org.hyperledger.aries.api.issue_credential_v2.V20CredOffer;
import org.hyperledger.aries.api.issue_credential_v2.V20CredProposal;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;

public class V20CredExRecord
extends BaseCredExRecord {
    private V20CredExRecordByFormat byFormat;
    private V20CredOffer credOffer;
    private V20CredPreview credPreview;
    private V20CredProposal credProposal;
    private V20CredIssue credIssue;
    private V20CredRequest credRequest;

    public boolean payloadIsIndy() {
        return this.byFormat != null && this.byFormat.hasIndyPayload();
    }

    public boolean payloadIsLdProof() {
        return this.byFormat != null && this.byFormat.hasLdProof();
    }

    public V20CredExRecordByFormat.LdProof resolveLDCredOffer() {
        if (this.byFormat != null && this.byFormat.hasLdProof() && this.byFormat.getCredOffer() != null) {
            return this.byFormat.convertToLdProof(this.byFormat.getCredOffer());
        }
        return null;
    }

    public V20CredExRecordByFormat.LdProof resolveLDCredProposal() {
        if (this.byFormat != null && this.byFormat.hasLdProof() && this.byFormat.getCredProposal() != null) {
            return this.byFormat.convertToLdProof(this.byFormat.getCredProposal());
        }
        return null;
    }

    public V20CredExRecordByFormat.LdProof resolveLDCredRequest() {
        if (this.byFormat != null && this.byFormat.hasLdProof() && this.byFormat.getCredRequest() != null) {
            return this.byFormat.convertToLdProof(this.byFormat.getCredRequest());
        }
        return null;
    }

    public V20CredExRecordByFormat.LdProof resolveLDCredential() {
        if (this.byFormat != null && this.byFormat.hasLdProof() && this.byFormat.getCredIssue() != null) {
            return V20CredExRecordByFormat.LdProof.builder().credential(this.byFormat.convertToLdProof(this.byFormat.getCredIssue(), VerifiableCredential.class)).build();
        }
        return null;
    }

    protected V20CredExRecord(V20CredExRecordBuilder<?, ?> b) {
        super(b);
        this.byFormat = b.byFormat;
        this.credOffer = b.credOffer;
        this.credPreview = b.credPreview;
        this.credProposal = b.credProposal;
        this.credIssue = b.credIssue;
        this.credRequest = b.credRequest;
    }

    public static V20CredExRecordBuilder<?, ?> builder() {
        return new V20CredExRecordBuilderImpl();
    }

    public V20CredExRecordByFormat getByFormat() {
        return this.byFormat;
    }

    public V20CredOffer getCredOffer() {
        return this.credOffer;
    }

    public V20CredPreview getCredPreview() {
        return this.credPreview;
    }

    public V20CredProposal getCredProposal() {
        return this.credProposal;
    }

    public V20CredIssue getCredIssue() {
        return this.credIssue;
    }

    public V20CredRequest getCredRequest() {
        return this.credRequest;
    }

    public void setByFormat(V20CredExRecordByFormat byFormat) {
        this.byFormat = byFormat;
    }

    public void setCredOffer(V20CredOffer credOffer) {
        this.credOffer = credOffer;
    }

    public void setCredPreview(V20CredPreview credPreview) {
        this.credPreview = credPreview;
    }

    public void setCredProposal(V20CredProposal credProposal) {
        this.credProposal = credProposal;
    }

    public void setCredIssue(V20CredIssue credIssue) {
        this.credIssue = credIssue;
    }

    public void setCredRequest(V20CredRequest credRequest) {
        this.credRequest = credRequest;
    }

    public V20CredExRecord() {
    }

    public V20CredExRecord(V20CredExRecordByFormat byFormat, V20CredOffer credOffer, V20CredPreview credPreview, V20CredProposal credProposal, V20CredIssue credIssue, V20CredRequest credRequest) {
        this.byFormat = byFormat;
        this.credOffer = credOffer;
        this.credPreview = credPreview;
        this.credProposal = credProposal;
        this.credIssue = credIssue;
        this.credRequest = credRequest;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V20CredExRecord)) {
            return false;
        }
        V20CredExRecord other = (V20CredExRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V20CredExRecordByFormat this$byFormat = this.getByFormat();
        V20CredExRecordByFormat other$byFormat = other.getByFormat();
        if (this$byFormat == null ? other$byFormat != null : !((Object)this$byFormat).equals(other$byFormat)) {
            return false;
        }
        V20CredOffer this$credOffer = this.getCredOffer();
        V20CredOffer other$credOffer = other.getCredOffer();
        if (this$credOffer == null ? other$credOffer != null : !((Object)this$credOffer).equals(other$credOffer)) {
            return false;
        }
        V20CredPreview this$credPreview = this.getCredPreview();
        V20CredPreview other$credPreview = other.getCredPreview();
        if (this$credPreview == null ? other$credPreview != null : !((Object)this$credPreview).equals(other$credPreview)) {
            return false;
        }
        V20CredProposal this$credProposal = this.getCredProposal();
        V20CredProposal other$credProposal = other.getCredProposal();
        if (this$credProposal == null ? other$credProposal != null : !((Object)this$credProposal).equals(other$credProposal)) {
            return false;
        }
        V20CredIssue this$credIssue = this.getCredIssue();
        V20CredIssue other$credIssue = other.getCredIssue();
        if (this$credIssue == null ? other$credIssue != null : !((Object)this$credIssue).equals(other$credIssue)) {
            return false;
        }
        V20CredRequest this$credRequest = this.getCredRequest();
        V20CredRequest other$credRequest = other.getCredRequest();
        return !(this$credRequest == null ? other$credRequest != null : !((Object)this$credRequest).equals(other$credRequest));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof V20CredExRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        V20CredExRecordByFormat $byFormat = this.getByFormat();
        result = result * 59 + ($byFormat == null ? 43 : ((Object)$byFormat).hashCode());
        V20CredOffer $credOffer = this.getCredOffer();
        result = result * 59 + ($credOffer == null ? 43 : ((Object)$credOffer).hashCode());
        V20CredPreview $credPreview = this.getCredPreview();
        result = result * 59 + ($credPreview == null ? 43 : ((Object)$credPreview).hashCode());
        V20CredProposal $credProposal = this.getCredProposal();
        result = result * 59 + ($credProposal == null ? 43 : ((Object)$credProposal).hashCode());
        V20CredIssue $credIssue = this.getCredIssue();
        result = result * 59 + ($credIssue == null ? 43 : ((Object)$credIssue).hashCode());
        V20CredRequest $credRequest = this.getCredRequest();
        result = result * 59 + ($credRequest == null ? 43 : ((Object)$credRequest).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "V20CredExRecord(super=" + super.toString() + ", byFormat=" + this.getByFormat() + ", credOffer=" + this.getCredOffer() + ", credPreview=" + this.getCredPreview() + ", credProposal=" + this.getCredProposal() + ", credIssue=" + this.getCredIssue() + ", credRequest=" + this.getCredRequest() + ")";
    }

    private static final class V20CredExRecordBuilderImpl
    extends V20CredExRecordBuilder<V20CredExRecord, V20CredExRecordBuilderImpl> {
        private V20CredExRecordBuilderImpl() {
        }

        @Override
        protected V20CredExRecordBuilderImpl self() {
            return this;
        }

        @Override
        public V20CredExRecord build() {
            return new V20CredExRecord(this);
        }
    }

    public static abstract class V20CredExRecordBuilder<C extends V20CredExRecord, B extends V20CredExRecordBuilder<C, B>>
    extends BaseCredExRecord.BaseCredExRecordBuilder<C, B> {
        private V20CredExRecordByFormat byFormat;
        private V20CredOffer credOffer;
        private V20CredPreview credPreview;
        private V20CredProposal credProposal;
        private V20CredIssue credIssue;
        private V20CredRequest credRequest;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B byFormat(V20CredExRecordByFormat byFormat) {
            this.byFormat = byFormat;
            return (B)this.self();
        }

        public B credOffer(V20CredOffer credOffer) {
            this.credOffer = credOffer;
            return (B)this.self();
        }

        public B credPreview(V20CredPreview credPreview) {
            this.credPreview = credPreview;
            return (B)this.self();
        }

        public B credProposal(V20CredProposal credProposal) {
            this.credProposal = credProposal;
            return (B)this.self();
        }

        public B credIssue(V20CredIssue credIssue) {
            this.credIssue = credIssue;
            return (B)this.self();
        }

        public B credRequest(V20CredRequest credRequest) {
            this.credRequest = credRequest;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "V20CredExRecord.V20CredExRecordBuilder(super=" + super.toString() + ", byFormat=" + this.byFormat + ", credOffer=" + this.credOffer + ", credPreview=" + this.credPreview + ", credProposal=" + this.credProposal + ", credIssue=" + this.credIssue + ", credRequest=" + this.credRequest + ")";
        }
    }
}

