/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v2;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.hyperledger.acy_py.generated.model.CredAttrSpec;
import org.hyperledger.acy_py.generated.model.V10CredentialBoundOfferRequest;
import org.hyperledger.acy_py.generated.model.V20CredAttrSpec;
import org.hyperledger.acy_py.generated.model.V20CredFilterIndy;
import org.hyperledger.aries.api.credentials.CredentialAttributes;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialProposalRequest;
import org.hyperledger.aries.api.issue_credential_v2.V20CredBoundOfferRequest;
import org.hyperledger.aries.api.issue_credential_v2.V2CredentialExchangeFree;

public class V1ToV2IssueCredentialConverter {
    public static V20CredBoundOfferRequest toV20CredBoundOfferRequest(@NonNull V10CredentialBoundOfferRequest v1) {
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        return V20CredBoundOfferRequest.builder().counterPreview(V2CredentialExchangeFree.V2CredentialPreview.builder().attributes(v1.getCounterProposal() != null && v1.getCounterProposal().getCredentialProposal() != null ? V1ToV2IssueCredentialConverter.toV20CredAttrSpec(v1.getCounterProposal().getCredentialProposal().getAttributes()) : null).build()).filter(V2CredentialExchangeFree.V20CredFilter.builder().indy(V20CredFilterIndy.builder().credDefId(v1.getCounterProposal() != null ? v1.getCounterProposal().getCredDefId() : null).issuerDid(v1.getCounterProposal() != null ? v1.getCounterProposal().getIssuerDid() : null).schemaId(v1.getCounterProposal() != null ? v1.getCounterProposal().getSchemaId() : null).schemaIssuerDid(v1.getCounterProposal() != null ? v1.getCounterProposal().getSchemaIssuerDid() : null).schemaVersion(v1.getCounterProposal() != null ? v1.getCounterProposal().getSchemaVersion() : null).schemaName(v1.getCounterProposal() != null ? v1.getCounterProposal().getSchemaName() : null).build()).build()).build();
    }

    public static V2CredentialExchangeFree toV2CredentialSendRequest(@NonNull V1CredentialProposalRequest v1) {
        if (v1 == null) {
            throw new NullPointerException("v1 is marked non-null but is null");
        }
        return V2CredentialExchangeFree.builder().connectionId(UUID.fromString(v1.getConnectionId())).comment(v1.getComment()).trace(v1.getTrace()).autoRemove(v1.getAutoRemove()).credentialPreview(V2CredentialExchangeFree.V2CredentialPreview.builder().attributes(v1.getCredentialProposal() != null ? v1.getCredentialProposal().getAttributes() : null).build()).filter(V2CredentialExchangeFree.V20CredFilter.builder().indy(V20CredFilterIndy.builder().credDefId(v1.getCredentialDefinitionId()).issuerDid(v1.getIssuerDid()).schemaId(v1.getSchemaId()).schemaIssuerDid(v1.getSchemaIssuerDid()).schemaVersion(v1.getSchemaVersion()).schemaName(v1.getSchemaName()).build()).build()).build();
    }

    public static List<CredentialAttributes> toV20CredAttrSpec(@NonNull List<CredAttrSpec> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return attributes.stream().map(a -> CredentialAttributes.builder().mimeType(a.getMimeType()).name(a.getName()).value(a.getValue()).build()).collect(Collectors.toList());
    }

    public static List<V20CredAttrSpec> toV20CredAttrSpecFromAttributes(@NonNull List<CredentialAttributes> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return attributes.stream().map(a -> V20CredAttrSpec.builder().mimeType(a.getMimeType()).name(a.getName()).value(a.getValue()).build()).collect(Collectors.toList());
    }

    public static V2CredentialExchangeFree toV20CredExFree(@NonNull V1CredentialProposalRequest v1Proposal) {
        if (v1Proposal == null) {
            throw new NullPointerException("v1Proposal is marked non-null but is null");
        }
        return V2CredentialExchangeFree.builder().connectionId(UUID.fromString(v1Proposal.getConnectionId())).comment(v1Proposal.getComment()).autoRemove(v1Proposal.getAutoRemove()).trace(v1Proposal.getTrace()).filter(V2CredentialExchangeFree.V20CredFilter.builder().indy(V20CredFilterIndy.builder().schemaName(v1Proposal.getSchemaName()).credDefId(v1Proposal.getCredentialDefinitionId()).schemaVersion(v1Proposal.getSchemaVersion()).issuerDid(v1Proposal.getIssuerDid()).schemaId(v1Proposal.getSchemaId()).schemaIssuerDid(v1Proposal.getSchemaIssuerDid()).build()).build()).credentialPreview(V2CredentialExchangeFree.V2CredentialPreview.builder().attributes(v1Proposal.getCredentialProposal() != null ? v1Proposal.getCredentialProposal().getAttributes() : null).build()).build();
    }
}

